/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaBeanInfo {
    final Constructor<?> defaultConstructor;
    final int defaultConstructorParameterSize;
    final Constructor<?> creatorConstructor;
    final Method factoryMethod;
    final FieldInfo[] fields;
    final FieldInfo[] sortedFields;
    final JSONType jsonType;
    boolean ordered = false;
    final boolean supportBeanToArray;
    public final String typeName;

    JavaBeanInfo(Class<?> clazz, Constructor<?> defaultConstructor, Constructor<?> creatorConstructor, Method factoryMethod, FieldInfo[] fields, FieldInfo[] sortedFields, JSONType jsonType) {
        String typeName;
        this.defaultConstructor = defaultConstructor;
        this.creatorConstructor = creatorConstructor;
        this.factoryMethod = factoryMethod;
        this.fields = fields;
        this.jsonType = jsonType;
        this.typeName = jsonType != null ? ((typeName = jsonType.typeName()).length() != 0 ? typeName : clazz.getName()) : clazz.getName();
        boolean supportBeanToArray = false;
        if (jsonType != null) {
            for (Feature feature : jsonType.parseFeatures()) {
                if (feature != Feature.SupportArrayToBean) continue;
                supportBeanToArray = true;
            }
        }
        this.supportBeanToArray = supportBeanToArray;
        this.sortedFields = Arrays.equals(fields, sortedFields = this.computeSortedFields(fields, sortedFields)) ? fields : sortedFields;
        this.defaultConstructorParameterSize = defaultConstructor != null ? defaultConstructor.getParameterTypes().length : 0;
    }

    private FieldInfo[] computeSortedFields(FieldInfo[] fields, FieldInfo[] sortedFields) {
        if (this.jsonType == null) {
            return sortedFields;
        }
        String[] orders = this.jsonType.orders();
        if (orders != null && orders.length != 0) {
            int i;
            int i2;
            int j;
            boolean containsAll = true;
            for (int i3 = 0; i3 < orders.length; ++i3) {
                boolean got = false;
                for (j = 0; j < sortedFields.length; ++j) {
                    if (!sortedFields[j].name.equals(orders[i3])) continue;
                    got = true;
                    break;
                }
                if (got) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) {
                return sortedFields;
            }
            if (orders.length == fields.length) {
                boolean orderMatch = true;
                for (i2 = 0; i2 < orders.length; ++i2) {
                    if (sortedFields[i2].name.equals(orders[i2])) continue;
                    orderMatch = false;
                    break;
                }
                if (orderMatch) {
                    return sortedFields;
                }
                FieldInfo[] newSortedFields = new FieldInfo[sortedFields.length];
                block3: for (i = 0; i < orders.length; ++i) {
                    for (int j2 = 0; j2 < sortedFields.length; ++j2) {
                        if (!sortedFields[j2].name.equals(orders[i])) continue;
                        newSortedFields[i] = sortedFields[j2];
                        continue block3;
                    }
                }
                sortedFields = newSortedFields;
                this.ordered = true;
                return newSortedFields;
            }
            FieldInfo[] newSortedFields = new FieldInfo[sortedFields.length];
            block5: for (i2 = 0; i2 < orders.length; ++i2) {
                for (j = 0; j < sortedFields.length; ++j) {
                    if (!sortedFields[j].name.equals(orders[i2])) continue;
                    newSortedFields[i2] = sortedFields[j];
                    continue block5;
                }
            }
            int fieldIndex = orders.length;
            for (i = 0; i < sortedFields.length; ++i) {
                boolean contains = false;
                for (int j3 = 0; j3 < newSortedFields.length && j3 < fieldIndex; ++j3) {
                    if (!newSortedFields[i].equals(sortedFields[j3])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                newSortedFields[fieldIndex] = sortedFields[i];
                ++fieldIndex;
            }
            this.ordered = true;
        }
        return sortedFields;
    }

    static boolean addField(List<FieldInfo> fields, FieldInfo field, boolean fieldOnly) {
        if (!fieldOnly) {
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                FieldInfo item = fields.get(i);
                if (!item.name.equals(field.name) || item.getOnly && !field.getOnly) continue;
                return false;
            }
        }
        fields.add(field);
        return true;
    }

    /*
     * Could not resolve type clashes
     */
    public static JavaBeanInfo build(Class<?> clazz, int classModifiers, Type type, boolean fieldOnly, boolean jsonTypeSupport, boolean jsonFieldSupport, boolean fieldGenericSupport) {
        String propertyName;
        JSONField annotation;
        ArrayList<FieldInfo> fieldList = new ArrayList<FieldInfo>();
        Object defaultConstructor = null;
        if ((classModifiers & 0x400) == 0) {
            try {
                defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (defaultConstructor == null && clazz.isMemberClass() && (classModifiers & 8) == 0) {
                for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                    AnnotatedElement[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 1 || !parameterTypes[0].equals(clazz.getDeclaringClass())) continue;
                    defaultConstructor = constructor;
                    break;
                }
            }
        }
        Object creatorConstructor = null;
        Method[] methods = fieldOnly ? null : clazz.getMethods();
        Field[] declaredFields = clazz.getDeclaredFields();
        if (defaultConstructor == null && !clazz.isInterface() && (classModifiers & 0x400) == 0) {
            creatorConstructor = null;
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                JSONCreator annotation2 = constructor.getAnnotation(JSONCreator.class);
                if (annotation2 == null) continue;
                if (creatorConstructor != null) {
                    throw new JSONException("multi-json creator");
                }
                creatorConstructor = constructor;
                break;
            }
            if (creatorConstructor != null) {
                TypeUtils.setAccessible(clazz, creatorConstructor, classModifiers);
                Class<?>[] parameterTypes = ((Constructor)creatorConstructor).getParameterTypes();
                Type[] getGenericParameterTypes = fieldGenericSupport ? ((Constructor)creatorConstructor).getGenericParameterTypes() : parameterTypes;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Annotation[] paramAnnotations = ((Constructor)creatorConstructor).getParameterAnnotations()[i];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = parameterTypes[i];
                    Type fieldType = getGenericParameterTypes[i];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                    if (field != null) {
                        TypeUtils.setAccessible(clazz, field, classModifiers);
                    }
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    JavaBeanInfo.addField(fieldList, fieldInfo, fieldOnly);
                }
                FieldInfo[] fields = new FieldInfo[fieldList.size()];
                fieldList.toArray(fields);
                Object[] sortedFields = new FieldInfo[fields.length];
                System.arraycopy(fields, 0, sortedFields, 0, fields.length);
                Arrays.sort(sortedFields);
                JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
                return new JavaBeanInfo(clazz, null, (Constructor<?>)creatorConstructor, null, fields, (FieldInfo[])sortedFields, jsonType);
            }
            Object factoryMethod = null;
            for (Method method : methods) {
                JSONCreator annotation3;
                if (!Modifier.isStatic(method.getModifiers()) || !clazz.isAssignableFrom(method.getReturnType()) || (annotation3 = method.getAnnotation(JSONCreator.class)) == null) continue;
                if (factoryMethod != null) {
                    throw new JSONException("multi-json creator");
                }
                factoryMethod = method;
                break;
            }
            if (factoryMethod != null) {
                TypeUtils.setAccessible(clazz, (Member)factoryMethod, classModifiers);
                Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
                Type[] genericParameterTypes = fieldGenericSupport ? factoryMethod.getGenericParameterTypes() : parameterTypes;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Annotation[] paramAnnotations = factoryMethod.getParameterAnnotations()[i];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = parameterTypes[i];
                    Type fieldType = genericParameterTypes[i];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    JavaBeanInfo.addField(fieldList, fieldInfo, fieldOnly);
                }
                Object[] fields = new FieldInfo[fieldList.size()];
                fieldList.toArray(fields);
                Object[] sortedFields = new FieldInfo[fields.length];
                System.arraycopy(fields, 0, sortedFields, 0, fields.length);
                Arrays.sort(sortedFields);
                if (Arrays.equals(fields, sortedFields)) {
                    sortedFields = fields;
                }
                JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
                JavaBeanInfo beanInfo = new JavaBeanInfo(clazz, null, null, (Method)factoryMethod, (FieldInfo[])fields, (FieldInfo[])sortedFields, jsonType);
                return beanInfo;
            }
            throw new JSONException("default constructor not found. " + clazz);
        }
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(clazz, defaultConstructor, classModifiers);
        }
        if (!fieldOnly) {
            for (Method method : methods) {
                String propertyName2;
                Class<?> returnType;
                int ordinal = 0;
                int serialzeFeatures = 0;
                String methodName = method.getName();
                if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || (returnType = method.getReturnType()) != Void.TYPE && returnType != method.getDeclaringClass() || method.getParameterTypes().length != 1 || method.getDeclaringClass() == Object.class) continue;
                JSONField jSONField = annotation = jsonFieldSupport ? method.getAnnotation(JSONField.class) : null;
                if (annotation == null && jsonFieldSupport) {
                    annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
                }
                if (annotation != null) {
                    if (!annotation.deserialize()) continue;
                    ordinal = annotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                    if (annotation.name().length() != 0) {
                        String propertyName3 = annotation.name();
                        JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName3, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null, fieldGenericSupport), fieldOnly);
                        TypeUtils.setAccessible(clazz, method, classModifiers);
                        continue;
                    }
                }
                if (!methodName.startsWith("set")) continue;
                char c3 = methodName.charAt(3);
                if (Character.isUpperCase(c3)) {
                    propertyName2 = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                } else if (c3 == '_') {
                    propertyName2 = methodName.substring(4);
                } else if (c3 == 'f') {
                    propertyName2 = methodName.substring(3);
                } else {
                    if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                    propertyName2 = TypeUtils.decapitalize(methodName.substring(3));
                }
                Field field = TypeUtils.getField(clazz, propertyName2, declaredFields);
                if (field == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                    String isFieldName = "is" + Character.toUpperCase(propertyName2.charAt(0)) + propertyName2.substring(1);
                    field = TypeUtils.getField(clazz, isFieldName, declaredFields);
                }
                if (field != null) {
                    JSONField fieldAnnotation;
                    JSONField jSONField2 = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
                    if (fieldAnnotation != null) {
                        ordinal = fieldAnnotation.ordinal();
                        serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        if (fieldAnnotation.name().length() != 0) {
                            propertyName2 = fieldAnnotation.name();
                            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName2, method, field, clazz, type, ordinal, serialzeFeatures, annotation, fieldAnnotation, fieldGenericSupport), fieldOnly);
                            continue;
                        }
                    }
                }
                JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName2, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null, fieldGenericSupport), fieldOnly);
                TypeUtils.setAccessible(clazz, method, classModifiers);
            }
        }
        ArrayList<AnnotatedElement> classfields = new ArrayList<AnnotatedElement>(declaredFields.length);
        for (AnnotatedElement f : declaredFields) {
            if ((((Field)f).getModifiers() & 8) != 0 || (((Field)f).getModifiers() & 1) == 0) continue;
            classfields.add(f);
        }
        for (Object c = clazz.getSuperclass(); c != null && c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if ((f.getModifiers() & 8) != 0 || (f.getModifiers() & 1) == 0) continue;
                classfields.add(f);
            }
        }
        for (Field field : classfields) {
            JSONField fieldAnnotation;
            String fieldName = field.getName();
            boolean contains = false;
            int size = fieldList.size();
            for (int i = 0; i < size; ++i) {
                FieldInfo item = (FieldInfo)fieldList.get(i);
                if (!item.name.equals(fieldName)) continue;
                contains = true;
            }
            if (contains) continue;
            int ordinal = 0;
            int serialzeFeatures = 0;
            propertyName = fieldName;
            JSONField jSONField = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
            if (fieldAnnotation != null) {
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
            }
            TypeUtils.setAccessible(clazz, field, classModifiers);
            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, null, field, clazz, type, ordinal, serialzeFeatures, null, fieldAnnotation, fieldGenericSupport), fieldOnly);
        }
        if (!fieldOnly) {
            for (Method method : clazz.getMethods()) {
                String annotationName;
                Class<?> methodReturnType;
                String methodName = method.getName();
                if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || !methodName.startsWith("get") || !Character.isUpperCase(methodName.charAt(3)) || method.getParameterTypes().length != 0 || !Collection.class.isAssignableFrom(methodReturnType = method.getReturnType()) && !Map.class.isAssignableFrom(methodReturnType)) continue;
                annotation = jsonFieldSupport ? method.getAnnotation(JSONField.class) : null;
                propertyName = annotation != null && (annotationName = annotation.name()).length() > 0 ? annotationName : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, null, clazz, type, 0, 0, annotation, null, fieldGenericSupport), fieldOnly);
                TypeUtils.setAccessible(clazz, method, classModifiers);
            }
        }
        FieldInfo[] fields = new FieldInfo[fieldList.size()];
        fieldList.toArray(fields);
        Object[] sortedFields = new FieldInfo[fields.length];
        System.arraycopy(fields, 0, sortedFields, 0, fields.length);
        Arrays.sort(sortedFields);
        JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
        return new JavaBeanInfo(clazz, (Constructor<?>)defaultConstructor, null, null, fields, (FieldInfo[])sortedFields, jsonType);
    }
}

