/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaBeanInfo {
    final Constructor<?> defaultConstructor;
    final int defaultConstructorParameterSize;
    final Constructor<?> creatorConstructor;
    final Method factoryMethod;
    final FieldInfo[] fields;
    final FieldInfo[] sortedFields;
    final JSONType jsonType;
    boolean ordered = false;
    final boolean supportBeanToArray;

    JavaBeanInfo(Class<?> clazz, Constructor<?> defaultConstructor, Constructor<?> creatorConstructor, Method factoryMethod, FieldInfo[] fields, FieldInfo[] sortedFields, JSONType jsonType) {
        this.defaultConstructor = defaultConstructor;
        this.creatorConstructor = creatorConstructor;
        this.factoryMethod = factoryMethod;
        this.fields = fields;
        this.jsonType = jsonType;
        boolean supportBeanToArray = false;
        if (jsonType != null) {
            for (Feature feature : jsonType.parseFeatures()) {
                if (feature != Feature.SupportArrayToBean) continue;
                supportBeanToArray = true;
            }
        }
        this.supportBeanToArray = supportBeanToArray;
        this.sortedFields = Arrays.equals(fields, sortedFields = this.computeSortedFields(fields, sortedFields)) ? fields : sortedFields;
        this.defaultConstructorParameterSize = defaultConstructor != null ? defaultConstructor.getParameterTypes().length : 0;
    }

    private FieldInfo[] computeSortedFields(FieldInfo[] fields, FieldInfo[] sortedFields) {
        if (this.jsonType == null) {
            return sortedFields;
        }
        String[] orders = this.jsonType.orders();
        if (orders != null && orders.length != 0) {
            int i;
            int i2;
            int j;
            boolean containsAll = true;
            for (int i3 = 0; i3 < orders.length; ++i3) {
                boolean got = false;
                for (j = 0; j < sortedFields.length; ++j) {
                    if (!sortedFields[j].name.equals(orders[i3])) continue;
                    got = true;
                    break;
                }
                if (got) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) {
                return sortedFields;
            }
            if (orders.length == fields.length) {
                boolean orderMatch = true;
                for (i2 = 0; i2 < orders.length; ++i2) {
                    if (sortedFields[i2].name.equals(orders[i2])) continue;
                    orderMatch = false;
                    break;
                }
                if (orderMatch) {
                    return sortedFields;
                }
                FieldInfo[] newSortedFields = new FieldInfo[sortedFields.length];
                block3: for (i = 0; i < orders.length; ++i) {
                    for (int j2 = 0; j2 < sortedFields.length; ++j2) {
                        if (!sortedFields[j2].name.equals(orders[i])) continue;
                        newSortedFields[i] = sortedFields[j2];
                        continue block3;
                    }
                }
                sortedFields = newSortedFields;
                this.ordered = true;
                return newSortedFields;
            }
            FieldInfo[] newSortedFields = new FieldInfo[sortedFields.length];
            block5: for (i2 = 0; i2 < orders.length; ++i2) {
                for (j = 0; j < sortedFields.length; ++j) {
                    if (!sortedFields[j].name.equals(orders[i2])) continue;
                    newSortedFields[i2] = sortedFields[j];
                    continue block5;
                }
            }
            int fieldIndex = orders.length;
            for (i = 0; i < sortedFields.length; ++i) {
                boolean contains = false;
                for (int j3 = 0; j3 < newSortedFields.length && j3 < fieldIndex; ++j3) {
                    if (!newSortedFields[i].equals(sortedFields[j3])) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                newSortedFields[fieldIndex] = sortedFields[i];
                ++fieldIndex;
            }
            this.ordered = true;
        }
        return sortedFields;
    }

    static boolean addField(List<FieldInfo> fields, FieldInfo field, boolean fieldOnly) {
        if (!fieldOnly) {
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                FieldInfo item = fields.get(i);
                if (!item.name.equals(field.name) || item.getOnly && !field.getOnly) continue;
                return false;
            }
        }
        fields.add(field);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static JavaBeanInfo build(Class<?> clazz, int classModifiers, Type type, boolean fieldOnly, boolean jsonTypeSupport, boolean jsonFieldSupport, boolean fieldGenericSupport) {
        Field[] declaredFields;
        ArrayList<FieldInfo> fieldList = new ArrayList<FieldInfo>();
        Constructor<?> defaultConstructor = null;
        if ((classModifiers & 0x400) == 0) {
            try {
                defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (defaultConstructor == null && clazz.isMemberClass() && (classModifiers & 8) == 0) {
                for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 1 || !parameterTypes[0].equals(clazz.getDeclaringClass())) continue;
                    defaultConstructor = constructor;
                    break;
                }
            }
        }
        Constructor<?> creatorConstructor = null;
        Method[] methods = fieldOnly ? null : clazz.getMethods();
        Field[] fieldArray = declaredFields = fieldOnly ? null : clazz.getDeclaredFields();
        if (defaultConstructor == null && !clazz.isInterface() && (classModifiers & 0x400) == 0) {
            void var12_20;
            void var15_44;
            creatorConstructor = null;
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                JSONCreator annotation = constructor.getAnnotation(JSONCreator.class);
                if (annotation == null) continue;
                if (creatorConstructor != null) {
                    throw new JSONException("multi-json creator");
                }
                creatorConstructor = constructor;
                break;
            }
            if (creatorConstructor != null) {
                TypeUtils.setAccessible(clazz, creatorConstructor, classModifiers);
                Class<?>[] classArray = creatorConstructor.getParameterTypes();
                Type[] getGenericParameterTypes = fieldGenericSupport ? creatorConstructor.getGenericParameterTypes() : classArray;
                for (int i = 0; i < classArray.length; ++i) {
                    Annotation[] annotationArray = creatorConstructor.getParameterAnnotations()[i];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : annotationArray) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = classArray[i];
                    Type fieldType = getGenericParameterTypes[i];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                    if (field != null) {
                        TypeUtils.setAccessible(clazz, field, classModifiers);
                    }
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    JavaBeanInfo.addField(fieldList, fieldInfo, fieldOnly);
                }
                FieldInfo[] fields = new FieldInfo[fieldList.size()];
                fieldList.toArray(fields);
                Object[] objectArray = new FieldInfo[fields.length];
                System.arraycopy(fields, 0, objectArray, 0, fields.length);
                Arrays.sort(objectArray);
                JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
                return new JavaBeanInfo(clazz, null, creatorConstructor, null, fields, (FieldInfo[])objectArray, jsonType);
            }
            Object var12_18 = null;
            Method[] getGenericParameterTypes = methods;
            int fields = getGenericParameterTypes.length;
            boolean bl = false;
            while (var15_44 < fields) {
                JSONCreator annotation;
                Method method = getGenericParameterTypes[var15_44];
                if (Modifier.isStatic(method.getModifiers()) && clazz.isAssignableFrom(method.getReturnType()) && (annotation = method.getAnnotation(JSONCreator.class)) != null) {
                    if (var12_18 != null) {
                        throw new JSONException("multi-json creator");
                    }
                    Method method2 = method;
                    break;
                }
                ++var15_44;
            }
            if (var12_20 != null) {
                void var15_46;
                TypeUtils.setAccessible(clazz, (Member)var12_20, classModifiers);
                Class<?>[] parameterTypes = var12_20.getParameterTypes();
                Type[] genericParameterTypes = fieldGenericSupport ? var12_20.getGenericParameterTypes() : parameterTypes;
                boolean bl2 = false;
                while (var15_46 < parameterTypes.length) {
                    Annotation[] paramAnnotations = var12_20.getParameterAnnotations()[var15_46];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = parameterTypes[var15_46];
                    Type fieldType = genericParameterTypes[var15_46];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    JavaBeanInfo.addField(fieldList, fieldInfo, fieldOnly);
                    ++var15_46;
                }
                Object[] objectArray = new FieldInfo[fieldList.size()];
                fieldList.toArray(objectArray);
                Object[] sortedFields = new FieldInfo[objectArray.length];
                System.arraycopy(objectArray, 0, sortedFields, 0, objectArray.length);
                Arrays.sort(sortedFields);
                if (Arrays.equals(objectArray, sortedFields)) {
                    sortedFields = objectArray;
                }
                JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
                JavaBeanInfo beanInfo = new JavaBeanInfo(clazz, null, null, (Method)var12_20, (FieldInfo[])objectArray, (FieldInfo[])sortedFields, jsonType);
                return beanInfo;
            }
            throw new JSONException("default constructor not found. " + clazz);
        }
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(clazz, defaultConstructor, classModifiers);
        }
        if (!fieldOnly) {
            Method[] methodArray = methods;
            int parameterTypes = methodArray.length;
            for (int genericParameterTypes = 0; genericParameterTypes < parameterTypes; ++genericParameterTypes) {
                String propertyName;
                JSONField annotation;
                Class<?> returnType;
                Method method = methodArray[genericParameterTypes];
                int ordinal = 0;
                int serialzeFeatures = 0;
                String methodName = method.getName();
                if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || (returnType = method.getReturnType()) != Void.TYPE && returnType != clazz || method.getParameterTypes().length != 1 || method.getDeclaringClass() == Object.class) continue;
                JSONField jSONField = annotation = jsonFieldSupport ? method.getAnnotation(JSONField.class) : null;
                if (annotation == null && jsonFieldSupport) {
                    annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
                }
                if (annotation != null) {
                    if (!annotation.deserialize()) continue;
                    ordinal = annotation.ordinal();
                    serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                    if (annotation.name().length() != 0) {
                        String propertyName2 = annotation.name();
                        JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName2, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null, fieldGenericSupport), fieldOnly);
                        TypeUtils.setAccessible(clazz, method, classModifiers);
                        continue;
                    }
                }
                if (!methodName.startsWith("set")) continue;
                char c3 = methodName.charAt(3);
                if (Character.isUpperCase(c3)) {
                    propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                } else if (c3 == '_') {
                    propertyName = methodName.substring(4);
                } else if (c3 == 'f') {
                    propertyName = methodName.substring(3);
                } else {
                    if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                    propertyName = TypeUtils.decapitalize(methodName.substring(3));
                }
                Field field = TypeUtils.getField(clazz, propertyName, declaredFields);
                if (field == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                    String isFieldName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                    field = TypeUtils.getField(clazz, isFieldName, declaredFields);
                }
                if (field != null) {
                    JSONField fieldAnnotation;
                    JSONField jSONField2 = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
                    if (fieldAnnotation != null) {
                        ordinal = fieldAnnotation.ordinal();
                        serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                        if (fieldAnnotation.name().length() != 0) {
                            propertyName = fieldAnnotation.name();
                            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, field, clazz, type, ordinal, serialzeFeatures, annotation, fieldAnnotation, fieldGenericSupport), fieldOnly);
                            continue;
                        }
                    }
                }
                JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null, fieldGenericSupport), fieldOnly);
                TypeUtils.setAccessible(clazz, method, classModifiers);
            }
        }
        for (Field field : clazz.getFields()) {
            JSONField fieldAnnotation;
            String fieldName = field.getName();
            boolean contains = false;
            int size = fieldList.size();
            for (int i = 0; i < size; ++i) {
                FieldInfo item = (FieldInfo)fieldList.get(i);
                if (!item.name.equals(fieldName)) continue;
                contains = true;
            }
            if (contains) continue;
            int ordinal = 0;
            int serialzeFeatures = 0;
            String propertyName = fieldName;
            JSONField jSONField = fieldAnnotation = jsonFieldSupport ? field.getAnnotation(JSONField.class) : null;
            if (fieldAnnotation != null) {
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
            }
            TypeUtils.setAccessible(clazz, field, classModifiers);
            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, null, field, clazz, type, ordinal, serialzeFeatures, null, fieldAnnotation, fieldGenericSupport), fieldOnly);
        }
        if (!fieldOnly) {
            for (Method method : clazz.getMethods()) {
                String annotationName;
                Class<?> methodReturnType;
                String methodName = method.getName();
                if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || !methodName.startsWith("get") || !Character.isUpperCase(methodName.charAt(3)) || method.getParameterTypes().length != 0 || !Collection.class.isAssignableFrom(methodReturnType = method.getReturnType()) && !Map.class.isAssignableFrom(methodReturnType)) continue;
                JSONField annotation = jsonFieldSupport ? method.getAnnotation(JSONField.class) : null;
                String propertyName = annotation != null && (annotationName = annotation.name()).length() > 0 ? annotationName : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
                JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, null, clazz, type, 0, 0, annotation, null, fieldGenericSupport), fieldOnly);
                TypeUtils.setAccessible(clazz, method, classModifiers);
            }
        }
        FieldInfo[] fieldInfoArray = new FieldInfo[fieldList.size()];
        fieldList.toArray(fieldInfoArray);
        Object[] sortedFields = new FieldInfo[fieldInfoArray.length];
        System.arraycopy(fieldInfoArray, 0, sortedFields, 0, fieldInfoArray.length);
        Arrays.sort(sortedFields);
        JSONType jsonType = jsonTypeSupport ? clazz.getAnnotation(JSONType.class) : null;
        return new JavaBeanInfo(clazz, defaultConstructor, null, null, fieldInfoArray, (FieldInfo[])sortedFields, jsonType);
    }
}

