/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.ParseContext;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.FieldInfo;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListTypeFieldDeserializer
extends FieldDeserializer {
    private final Type itemType;
    private ObjectDeserializer deserializer;
    private final boolean array;

    public ListTypeFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo, 14);
        Type fieldType = fieldInfo.fieldType;
        Class<?> fieldClass = fieldInfo.fieldClass;
        if (fieldType instanceof ParameterizedType) {
            this.itemType = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
            this.array = false;
        } else if (fieldClass.isArray()) {
            this.itemType = fieldClass.getComponentType();
            this.array = true;
        } else {
            this.itemType = Object.class;
            this.array = false;
        }
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Type objectType, Map<String, Object> fieldValues) {
        List fieldValue;
        List list;
        if (parser.lexer.token == 8) {
            this.setValue(object, null);
            return;
        }
        JSONArray jsonArray = null;
        if (this.array) {
            jsonArray = new JSONArray();
            list = jsonArray;
            jsonArray.setComponentType(this.itemType);
        } else {
            list = new ArrayList();
        }
        ParseContext context = parser.contex;
        parser.setContext(context, object, this.fieldInfo.name);
        this.parseArray(parser, objectType, list);
        parser.setContext(context);
        if (this.array) {
            Object[] arrayValue = (Object[])Array.newInstance((Class)this.itemType, list.size());
            fieldValue = list.toArray(arrayValue);
            jsonArray.setRelatedArray(fieldValue);
        } else {
            fieldValue = list;
        }
        if (object == null) {
            fieldValues.put(this.fieldInfo.name, fieldValue);
        } else {
            this.setValue(object, fieldValue);
        }
    }

    final void parseArray(DefaultJSONParser parser, Type objectType, Collection array) {
        Type itemType = this.itemType;
        ObjectDeserializer itemTypeDeser = this.deserializer;
        if (itemType instanceof TypeVariable && objectType instanceof ParameterizedType) {
            TypeVariable typeVar = (TypeVariable)itemType;
            ParameterizedType paramType = (ParameterizedType)objectType;
            Class objectClass = null;
            if (paramType.getRawType() instanceof Class) {
                objectClass = (Class)paramType.getRawType();
            }
            int paramIndex = -1;
            if (objectClass != null) {
                int size = objectClass.getTypeParameters().length;
                for (int i = 0; i < size; ++i) {
                    TypeVariable item = objectClass.getTypeParameters()[i];
                    if (!item.getName().equals(typeVar.getName())) continue;
                    paramIndex = i;
                    break;
                }
            }
            if (paramIndex != -1 && !(itemType = paramType.getActualTypeArguments()[paramIndex]).equals(this.itemType)) {
                itemTypeDeser = parser.config.getDeserializer(itemType);
            }
        }
        JSONLexer lexer = parser.lexer;
        if (lexer.token != 14) {
            String errorMessage = "exepct '[', but " + JSONToken.name(lexer.token);
            if (objectType != null) {
                errorMessage = errorMessage + ", type : " + objectType;
            }
            throw new JSONException(errorMessage);
        }
        if (itemTypeDeser == null) {
            itemTypeDeser = this.deserializer = parser.config.getDeserializer(itemType);
        }
        lexer.nextToken();
        boolean allowArbitraryCommas = (lexer.features & Feature.AllowArbitraryCommas.mask) != 0;
        int i = 0;
        while (true) {
            if (allowArbitraryCommas) {
                while (lexer.token == 16) {
                    lexer.nextToken();
                }
            }
            if (lexer.token == 15) break;
            Object val = itemTypeDeser.deserialze(parser, itemType, i);
            array.add(val);
            parser.checkListResolve(array);
            if (lexer.token == 16) {
                lexer.nextToken();
            }
            ++i;
        }
        lexer.nextToken(16);
    }
}

