/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.annotation.JSONCreator;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavaBeanInfo {
    final Constructor<?> defaultConstructor;
    final int defaultConstructorParameterSize;
    final Constructor<?> creatorConstructor;
    final Method factoryMethod;
    final FieldInfo[] fields;
    final FieldInfo[] sortedFields;
    final JSONType jsonType;

    JavaBeanInfo(Class<?> clazz, Constructor<?> defaultConstructor, Constructor<?> creatorConstructor, Method factoryMethod, FieldInfo[] fields, FieldInfo[] sortedFields) {
        this.defaultConstructor = defaultConstructor;
        this.creatorConstructor = creatorConstructor;
        this.factoryMethod = factoryMethod;
        this.fields = fields;
        this.sortedFields = Arrays.equals(fields, sortedFields) ? fields : sortedFields;
        this.jsonType = clazz.getAnnotation(JSONType.class);
        this.defaultConstructorParameterSize = defaultConstructor != null ? defaultConstructor.getParameterTypes().length : 0;
    }

    static boolean addField(List<FieldInfo> fields, FieldInfo field) {
        for (FieldInfo item : fields) {
            if (!item.name.equals(field.name) || item.getOnly && !field.getOnly) continue;
            return false;
        }
        fields.add(field);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static JavaBeanInfo build(Class<?> clazz, Type type) {
        ArrayList<FieldInfo> fieldList = new ArrayList<FieldInfo>();
        Constructor<?> defaultConstructor = JavaBeanInfo.getDefaultConstructor(clazz);
        Constructor<?> creatorConstructor = null;
        Method[] methods = clazz.getMethods();
        Field[] declaredFields = clazz.getDeclaredFields();
        int modifiers = clazz.getModifiers();
        if (defaultConstructor == null && !clazz.isInterface() && (modifiers & 0x400) == 0) {
            creatorConstructor = JavaBeanInfo.getCreatorConstructor(clazz);
            if (creatorConstructor != null) {
                TypeUtils.setAccessible(clazz, creatorConstructor, modifiers);
                Class<?>[] parameterTypes = creatorConstructor.getParameterTypes();
                Type[] getGenericParameterTypes = creatorConstructor.getGenericParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Annotation[] annotationArray = creatorConstructor.getParameterAnnotations()[i];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : annotationArray) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = parameterTypes[i];
                    Type fieldType = getGenericParameterTypes[i];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                    if (field != null) {
                        TypeUtils.setAccessible(clazz, field, modifiers);
                    }
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    JavaBeanInfo.addField(fieldList, fieldInfo);
                }
                FieldInfo[] fields = new FieldInfo[fieldList.size()];
                fieldList.toArray(fields);
                Object[] objectArray = new FieldInfo[fields.length];
                System.arraycopy(fields, 0, objectArray, 0, fields.length);
                Arrays.sort(objectArray);
                return new JavaBeanInfo(clazz, null, creatorConstructor, null, fields, (FieldInfo[])objectArray);
            }
            Method factoryMethod = JavaBeanInfo.getFactoryMethod(clazz, methods);
            if (factoryMethod != null) {
                void var11_22;
                TypeUtils.setAccessible(clazz, factoryMethod, modifiers);
                Class<?>[] parameterTypes = factoryMethod.getParameterTypes();
                Type[] genericParameterTypes = factoryMethod.getGenericParameterTypes();
                boolean bl = false;
                while (var11_22 < parameterTypes.length) {
                    Annotation[] paramAnnotations = factoryMethod.getParameterAnnotations()[var11_22];
                    JSONField fieldAnnotation = null;
                    for (Annotation paramAnnotation : paramAnnotations) {
                        if (!(paramAnnotation instanceof JSONField)) continue;
                        fieldAnnotation = (JSONField)paramAnnotation;
                        break;
                    }
                    if (fieldAnnotation == null) {
                        throw new JSONException("illegal json creator");
                    }
                    Class<?> fieldClass = parameterTypes[var11_22];
                    Type fieldType = genericParameterTypes[var11_22];
                    Field field = TypeUtils.getField(clazz, fieldAnnotation.name(), declaredFields);
                    int ordinal = fieldAnnotation.ordinal();
                    int serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                    FieldInfo fieldInfo = new FieldInfo(fieldAnnotation.name(), clazz, fieldClass, fieldType, field, ordinal, serialzeFeatures);
                    JavaBeanInfo.addField(fieldList, fieldInfo);
                    ++var11_22;
                }
                Object[] objectArray = new FieldInfo[fieldList.size()];
                fieldList.toArray(objectArray);
                Object[] sortedFields = new FieldInfo[objectArray.length];
                System.arraycopy(objectArray, 0, sortedFields, 0, objectArray.length);
                Arrays.sort(sortedFields);
                if (Arrays.equals(objectArray, sortedFields)) {
                    sortedFields = objectArray;
                }
                JavaBeanInfo beanInfo = new JavaBeanInfo(clazz, null, null, factoryMethod, (FieldInfo[])objectArray, (FieldInfo[])sortedFields);
                return beanInfo;
            }
            throw new JSONException("default constructor not found. " + clazz);
        }
        if (defaultConstructor != null) {
            TypeUtils.setAccessible(clazz, defaultConstructor, modifiers);
        }
        for (Method method : methods) {
            JSONField fieldAnnotation;
            String propertyName;
            Class<?> returnType;
            int ordinal = 0;
            int serialzeFeatures = 0;
            String methodName = method.getName();
            if (methodName.length() < 4 || Modifier.isStatic(method.getModifiers()) || (returnType = method.getReturnType()) != Void.TYPE && returnType != clazz || method.getParameterTypes().length != 1 || method.getDeclaringClass() == Object.class) continue;
            JSONField annotation = method.getAnnotation(JSONField.class);
            if (annotation == null) {
                annotation = TypeUtils.getSupperMethodAnnotation(clazz, method);
            }
            if (annotation != null) {
                if (!annotation.deserialize()) continue;
                ordinal = annotation.ordinal();
                serialzeFeatures = SerializerFeature.of(annotation.serialzeFeatures());
                if (annotation.name().length() != 0) {
                    String propertyName2 = annotation.name();
                    JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName2, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null));
                    TypeUtils.setAccessible(clazz, method, modifiers);
                    continue;
                }
            }
            if (!methodName.startsWith("set")) continue;
            char c3 = methodName.charAt(3);
            if (Character.isUpperCase(c3)) {
                propertyName = TypeUtils.compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            } else if (c3 == '_') {
                propertyName = methodName.substring(4);
            } else if (c3 == 'f') {
                propertyName = methodName.substring(3);
            } else {
                if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) continue;
                propertyName = TypeUtils.decapitalize(methodName.substring(3));
            }
            Field field = TypeUtils.getField(clazz, propertyName, declaredFields);
            if (field == null && method.getParameterTypes()[0] == Boolean.TYPE) {
                String isFieldName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                field = TypeUtils.getField(clazz, isFieldName, declaredFields);
            }
            if (field != null && (fieldAnnotation = field.getAnnotation(JSONField.class)) != null) {
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                    JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, field, clazz, type, ordinal, serialzeFeatures, annotation, fieldAnnotation));
                    continue;
                }
            }
            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, method, null, clazz, type, ordinal, serialzeFeatures, annotation, null));
            TypeUtils.setAccessible(clazz, method, modifiers);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            String fieldName = ((Field)accessibleObject).getName();
            boolean contains = false;
            for (FieldInfo item : fieldList) {
                if (!item.name.equals(fieldName)) continue;
                contains = true;
            }
            if (contains) continue;
            int ordinal = 0;
            int serialzeFeatures = 0;
            String propertyName = fieldName;
            JSONField fieldAnnotation = ((Field)accessibleObject).getAnnotation(JSONField.class);
            if (fieldAnnotation != null) {
                ordinal = fieldAnnotation.ordinal();
                serialzeFeatures = SerializerFeature.of(fieldAnnotation.serialzeFeatures());
                if (fieldAnnotation.name().length() != 0) {
                    propertyName = fieldAnnotation.name();
                }
            }
            TypeUtils.setAccessible(clazz, (Member)((Object)accessibleObject), modifiers);
            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, null, (Field)accessibleObject, clazz, type, ordinal, serialzeFeatures, null, fieldAnnotation));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            String annotationName;
            Class<?> methodReturnType;
            String methodName = ((Method)accessibleObject).getName();
            if (methodName.length() < 4 || Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !methodName.startsWith("get") || !Character.isUpperCase(methodName.charAt(3)) || ((Method)accessibleObject).getParameterTypes().length != 0 || !Collection.class.isAssignableFrom(methodReturnType = ((Method)accessibleObject).getReturnType()) && !Map.class.isAssignableFrom(methodReturnType)) continue;
            JSONField annotation = ((Method)accessibleObject).getAnnotation(JSONField.class);
            String propertyName = annotation != null && (annotationName = annotation.name()).length() > 0 ? annotationName : Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            JavaBeanInfo.addField(fieldList, new FieldInfo(propertyName, (Method)accessibleObject, null, clazz, type, 0, 0, annotation, null));
            TypeUtils.setAccessible(clazz, (Member)((Object)accessibleObject), modifiers);
        }
        FieldInfo[] fields = new FieldInfo[fieldList.size()];
        fieldList.toArray(fields);
        Object[] sortedFields = new FieldInfo[fields.length];
        System.arraycopy(fields, 0, sortedFields, 0, fields.length);
        Arrays.sort(sortedFields);
        return new JavaBeanInfo(clazz, defaultConstructor, null, null, fields, (FieldInfo[])sortedFields);
    }

    private static Constructor<?> getDefaultConstructor(Class<?> clazz) {
        int classModifiers = clazz.getModifiers();
        if ((classModifiers & 0x400) != 0) {
            return null;
        }
        Constructor<?> defaultConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            defaultConstructor = constructor;
            break;
        }
        if (defaultConstructor == null && clazz.isMemberClass() && (classModifiers & 8) == 0) {
            for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 1 || !parameterTypes[0].equals(clazz.getDeclaringClass())) continue;
                defaultConstructor = constructor;
                break;
            }
        }
        return defaultConstructor;
    }

    public static Constructor<?> getCreatorConstructor(Class<?> clazz) {
        Constructor<?> creatorConstructor = null;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            JSONCreator annotation = constructor.getAnnotation(JSONCreator.class);
            if (annotation == null) continue;
            if (creatorConstructor != null) {
                throw new JSONException("multi-json creator");
            }
            creatorConstructor = constructor;
            break;
        }
        return creatorConstructor;
    }

    private static Method getFactoryMethod(Class<?> clazz, Method[] methods) {
        Method factoryMethod = null;
        for (Method method : methods) {
            JSONCreator annotation;
            if (!Modifier.isStatic(method.getModifiers()) || !clazz.isAssignableFrom(method.getReturnType()) || (annotation = method.getAnnotation(JSONCreator.class)) == null) continue;
            if (factoryMethod != null) {
                throw new JSONException("multi-json creator");
            }
            factoryMethod = method;
            break;
        }
        return factoryMethod;
    }
}

