/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.JSONToken;
import com.alibaba.fastjson.parser.JavaBeanInfo;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.util.FieldInfo;
import com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanDeserializer
implements ObjectDeserializer {
    private final FieldDeserializer[] fieldDeserializers;
    private final FieldDeserializer[] sortedFieldDeserializers;
    private final Class<?> clazz;
    private final JavaBeanInfo beanInfo;

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz) {
        this(config, clazz, clazz);
    }

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz, Type type) {
        FieldDeserializer fieldDeserializer;
        this.clazz = clazz;
        this.beanInfo = JavaBeanInfo.build(clazz, type);
        this.sortedFieldDeserializers = new FieldDeserializer[this.beanInfo.sortedFields.length];
        for (FieldInfo fieldInfo : this.beanInfo.sortedFields) {
            this.sortedFieldDeserializers[i] = fieldDeserializer = config.createFieldDeserializer(config, clazz, fieldInfo);
        }
        this.fieldDeserializers = new FieldDeserializer[this.beanInfo.fields.length];
        for (FieldInfo fieldInfo : this.beanInfo.fields) {
            this.fieldDeserializers[i] = fieldDeserializer = this.getFieldDeserializer(fieldInfo.name);
        }
    }

    public Object createInstance(DefaultJSONParser parser, Type type) {
        Object object;
        if (type instanceof Class && this.clazz.isInterface()) {
            Class clazz = (Class)type;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            JSONObject obj = new JSONObject();
            Object proxy = Proxy.newProxyInstance(loader, new Class[]{clazz}, (InvocationHandler)obj);
            return proxy;
        }
        if (this.beanInfo.defaultConstructor == null) {
            return null;
        }
        try {
            Constructor<?> constructor = this.beanInfo.defaultConstructor;
            object = this.beanInfo.defaultConstructorParameterSize == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(parser.getContext().object);
        }
        catch (Exception e) {
            throw new JSONException("create instance error, class " + this.clazz.getName(), e);
        }
        if ((parser.lexer.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
            for (FieldInfo fieldInfo : this.beanInfo.fields) {
                if (fieldInfo.fieldClass != String.class) continue;
                try {
                    fieldInfo.set(object, "");
                }
                catch (Exception e) {
                    throw new JSONException("create instance error, class " + this.clazz.getName(), e);
                }
            }
        }
        return object;
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        return this.deserialze(parser, type, fieldName, null);
    }

    public <T> T deserialzeArrayMapping(DefaultJSONParser parser, Type type, Object fieldName, Object object) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token != 14) {
            throw new JSONException("error");
        }
        object = this.createInstance(parser, type);
        int size = this.sortedFieldDeserializers.length;
        for (int i = 0; i < size; ++i) {
            char seperator = i == size - 1 ? (char)']' : ',';
            FieldDeserializer fieldDeser = this.sortedFieldDeserializers[i];
            Class<?> fieldClass = fieldDeser.fieldInfo.fieldClass;
            if (fieldClass == Integer.TYPE) {
                int value = lexer.scanInt(seperator);
                fieldDeser.setValue(object, (Object)value);
                continue;
            }
            if (fieldClass == String.class) {
                String value = lexer.scanString(seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass == Long.TYPE) {
                long value = lexer.scanLong(seperator);
                fieldDeser.setValue(object, (Object)value);
                continue;
            }
            if (fieldClass.isEnum()) {
                Enum<?> value = lexer.scanEnum(fieldClass, parser.symbolTable, seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            lexer.nextToken(14);
            Object value = parser.parseObject(fieldDeser.fieldInfo.fieldType);
            fieldDeser.setValue(object, value);
            if (seperator == ']') {
                if (lexer.token != 15) {
                    throw new JSONException("syntax error");
                }
                lexer.nextToken(16);
                continue;
            }
            if (seperator != 44 || lexer.token == 16) continue;
            throw new JSONException("syntax error");
        }
        lexer.nextToken(16);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, Object object) {
        if (type == JSON.class || type == JSONObject.class) {
            return (T)parser.parse();
        }
        lexer = parser.lexer;
        token = lexer.token;
        if (token == 8) {
            lexer.nextToken(16);
            return null;
        }
        context = parser.getContext();
        if (object != null && context != null) {
            context = context.parent;
        }
        childContext = null;
        try {
            fieldValues = null;
            if (token == 13) {
                lexer.nextToken(16);
                if (object == null) {
                    object = this.createInstance(parser, type);
                }
                var10_10 = object;
                return (T)var10_10;
            }
            if (token == 14) {
                beanFeatures = 0;
                if (this.beanInfo.jsonType != null) {
                    for (Feature feature : this.beanInfo.jsonType.parseFeatures()) {
                        beanFeatures |= feature.mask;
                    }
                }
                v0 = isSupportArrayToBean = (beanFeatures & Feature.SupportArrayToBean.mask) != 0 || (lexer.features & Feature.SupportArrayToBean.mask) != 0;
                if (isSupportArrayToBean) {
                    var12_19 = this.deserialzeArrayMapping(parser, type, fieldName, object);
                    return var12_19;
                }
            }
            if (token != 12 && token != 16) {
                buf = new StringBuffer().append("syntax error, expect {, actual ").append(lexer.tokenName()).append(", pos ").append(lexer.pos());
                if (fieldName instanceof String) {
                    buf.append(", fieldName ").append(fieldName);
                }
                throw new JSONException(buf.toString());
            }
            if (parser.resolveStatus == 2) {
                parser.resolveStatus = 0;
            }
            fieldIndex = 0;
            size = this.sortedFieldDeserializers.length;
            while (true) {
                block92: {
                    block109: {
                        block105: {
                            block107: {
                                block108: {
                                    block106: {
                                        block89: {
                                            block103: {
                                                block104: {
                                                    block101: {
                                                        block102: {
                                                            block99: {
                                                                block100: {
                                                                    block97: {
                                                                        block98: {
                                                                            block95: {
                                                                                block96: {
                                                                                    block93: {
                                                                                        block94: {
                                                                                            block90: {
                                                                                                block91: {
                                                                                                    key = null;
                                                                                                    fieldDeser = null;
                                                                                                    fieldInfo = null;
                                                                                                    fieldClass = null;
                                                                                                    if (fieldIndex < size) {
                                                                                                        fieldDeser = this.sortedFieldDeserializers[fieldIndex];
                                                                                                        fieldInfo = fieldDeser.fieldInfo;
                                                                                                        fieldClass = fieldInfo.fieldClass;
                                                                                                    }
                                                                                                    matchField = false;
                                                                                                    valueParsed = false;
                                                                                                    fieldValue = null;
                                                                                                    fieldValueInt = 0;
                                                                                                    fieldValueLong = 0L;
                                                                                                    fieldValueFloat = 0.0f;
                                                                                                    fieldValueDouble = 0.0;
                                                                                                    if (fieldDeser == null) break block89;
                                                                                                    name_chars = fieldInfo.name_chars;
                                                                                                    if (fieldClass != Integer.TYPE && fieldClass != Integer.class) break block90;
                                                                                                    fieldValueInt = lexer.scanFieldInt(name_chars);
                                                                                                    if (lexer.matchStat <= 0) break block91;
                                                                                                    matchField = true;
                                                                                                    valueParsed = true;
                                                                                                    break block89;
                                                                                                }
                                                                                                if (lexer.matchStat != -2) break block89;
                                                                                                break block92;
                                                                                            }
                                                                                            if (fieldClass != Long.TYPE && fieldClass != Long.class) break block93;
                                                                                            fieldValueLong = lexer.scanFieldLong(name_chars);
                                                                                            if (lexer.matchStat <= 0) break block94;
                                                                                            matchField = true;
                                                                                            valueParsed = true;
                                                                                            break block89;
                                                                                        }
                                                                                        if (lexer.matchStat != -2) break block89;
                                                                                        break block92;
                                                                                    }
                                                                                    if (fieldClass != String.class) break block95;
                                                                                    fieldValue = lexer.scanFieldString(name_chars);
                                                                                    if (lexer.matchStat <= 0) break block96;
                                                                                    matchField = true;
                                                                                    valueParsed = true;
                                                                                    break block89;
                                                                                }
                                                                                if (lexer.matchStat != -2) break block89;
                                                                                break block92;
                                                                            }
                                                                            if (fieldClass != Boolean.TYPE && fieldClass != Boolean.class) break block97;
                                                                            fieldValue = lexer.scanFieldBoolean(name_chars);
                                                                            if (lexer.matchStat <= 0) break block98;
                                                                            matchField = true;
                                                                            valueParsed = true;
                                                                            break block89;
                                                                        }
                                                                        if (lexer.matchStat != -2) break block89;
                                                                        break block92;
                                                                    }
                                                                    if (fieldClass != Float.TYPE && fieldClass != Float.class) break block99;
                                                                    fieldValueFloat = lexer.scanFieldFloat(name_chars);
                                                                    if (lexer.matchStat <= 0) break block100;
                                                                    matchField = true;
                                                                    valueParsed = true;
                                                                    break block89;
                                                                }
                                                                if (lexer.matchStat != -2) break block89;
                                                                break block92;
                                                            }
                                                            if (fieldClass != Double.TYPE && fieldClass != Double.class) break block101;
                                                            fieldValueDouble = lexer.scanFieldDouble(name_chars);
                                                            if (lexer.matchStat <= 0) break block102;
                                                            matchField = true;
                                                            valueParsed = true;
                                                            break block89;
                                                        }
                                                        if (lexer.matchStat != -2) break block89;
                                                        break block92;
                                                    }
                                                    if (!fieldInfo.isEnum) break block103;
                                                    enumName = lexer.scanFieldSymbol(name_chars, parser.symbolTable);
                                                    if (lexer.matchStat <= 0) break block104;
                                                    matchField = true;
                                                    valueParsed = true;
                                                    fieldValue = Enum.valueOf(fieldClass, enumName);
                                                    break block89;
                                                }
                                                if (lexer.matchStat != -2) break block89;
                                                break block92;
                                            }
                                            if (!lexer.matchField(name_chars)) break block92;
                                            matchField = true;
                                        }
                                        if (matchField) break block105;
                                        key = lexer.scanSymbol(parser.symbolTable);
                                        if (key != null) break block106;
                                        token = lexer.token;
                                        if (token == 13) {
                                            lexer.nextToken(16);
                                            break;
                                        }
                                        if (token == 16 && (lexer.features & Feature.AllowArbitraryCommas.mask) != 0) break block92;
                                    }
                                    if ("$ref" == key) {
                                        lexer.nextTokenWithChar(':');
                                        token = lexer.token;
                                        if (token == 4) {
                                            ref = lexer.stringVal();
                                            if ("@".equals(ref)) {
                                                object = context.object;
                                            } else if ("..".equals(ref)) {
                                                parentContext = context.parent;
                                                if (parentContext.object != null) {
                                                    object = parentContext.object;
                                                } else {
                                                    parser.addResolveTask(new DefaultJSONParser.ResolveTask(parentContext, (String)ref));
                                                    parser.resolveStatus = 1;
                                                }
                                            } else if ("$".equals(ref)) {
                                                rootContext = context;
                                                while (rootContext.parent != null) {
                                                    rootContext = rootContext.parent;
                                                }
                                                if (rootContext.object != null) {
                                                    object = rootContext.object;
                                                } else {
                                                    parser.addResolveTask(new DefaultJSONParser.ResolveTask(rootContext, (String)ref));
                                                    parser.resolveStatus = 1;
                                                }
                                            } else {
                                                parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                                                parser.resolveStatus = 1;
                                            }
                                        } else {
                                            throw new JSONException("illegal ref, " + JSONToken.name(token));
                                        }
                                        lexer.nextToken(13);
                                        if (lexer.token != 13) {
                                            throw new JSONException("illegal ref");
                                        }
                                        lexer.nextToken(16);
                                        parser.setContext(context, object, fieldName);
                                        ref = object;
                                        return (T)ref;
                                    }
                                    if ("@type" != key) break block105;
                                    lexer.nextTokenWithChar(':');
                                    if (lexer.token != 4) break block107;
                                    typeName = lexer.stringVal();
                                    lexer.nextToken(16);
                                    if (!(type instanceof Class) || !typeName.equals(((Class)type).getName())) break block108;
                                    if (lexer.token == 13) {
                                        lexer.nextToken();
                                        break;
                                    }
                                    break block92;
                                }
                                userType = TypeUtils.loadClass(typeName, parser.config.defaultClassLoader);
                                deserizer = parser.config.getDeserializer(userType);
                                var28_39 = deserizer.deserialze(parser, userType, fieldName);
                                return var28_39;
                            }
                            throw new JSONException("syntax error");
                        }
                        if (object == null && fieldValues == null) {
                            object = this.createInstance(parser, type);
                            if (object == null) {
                                fieldValues = new HashMap<String, Integer>(this.fieldDeserializers.length);
                            }
                            childContext = parser.setContext(context, object, fieldName);
                        }
                        if (!matchField) break block109;
                        if (!valueParsed) {
                            fieldDeser.parseField(parser, object, type, fieldValues);
                        } else {
                            if (object == null) {
                                if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
                                    fieldValue = fieldValueInt;
                                } else if (fieldClass == Long.TYPE || fieldClass == Long.class) {
                                    fieldValue = fieldValueLong;
                                } else if (fieldClass == Float.TYPE || fieldClass == Float.class) {
                                    fieldValue = new Float(fieldValueFloat);
                                } else if (fieldClass == Double.TYPE || fieldClass == Double.class) {
                                    fieldValue = new Double(fieldValueDouble);
                                }
                                fieldValues.put(fieldInfo.name, (Integer)fieldValue);
                            } else if (fieldValue == null) {
                                if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
                                    if (fieldInfo.fieldAccess) {
                                        fieldDeser.setValue(object, fieldValueInt);
                                    } else {
                                        fieldDeser.setValue(object, (Object)fieldValueInt);
                                    }
                                } else if (fieldClass == Long.TYPE || fieldClass == Long.class) {
                                    if (fieldInfo.fieldAccess) {
                                        fieldDeser.setValue(object, fieldValueLong);
                                    } else {
                                        fieldDeser.setValue(object, (Object)fieldValueLong);
                                    }
                                } else if (fieldClass == Float.TYPE || fieldClass == Float.class) {
                                    if (fieldInfo.fieldAccess) {
                                        fieldDeser.setValue(object, fieldValueFloat);
                                    } else {
                                        fieldDeser.setValue(object, new Float(fieldValueFloat));
                                    }
                                } else if (fieldClass == Double.TYPE || fieldClass == Double.class) {
                                    if (fieldInfo.fieldAccess) {
                                        fieldDeser.setValue(object, fieldValueDouble);
                                    } else {
                                        fieldDeser.setValue(object, new Double(fieldValueDouble));
                                    }
                                } else if (fieldClass != Float.TYPE && fieldClass != Double.TYPE && fieldClass != Boolean.TYPE) {
                                    fieldDeser.setValue(object, fieldValue);
                                }
                            } else {
                                fieldDeser.setValue(object, fieldValue);
                            }
                            if (lexer.matchStat == 4) {
                                break;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    match = this.parseField(parser, key, object, type, fieldValues);
                    if (!match) {
                        if (lexer.token == 13) {
                            lexer.nextToken();
                            break;
                        }
                    } else if (lexer.token != 16) {
                        if (lexer.token == 13) {
                            lexer.nextToken(16);
                            break;
                        }
                        if (lexer.token == 18 || lexer.token == 1) {
                            throw new JSONException("syntax error, unexpect token " + JSONToken.name(lexer.token));
                        }
                    }
                }
                ++fieldIndex;
            }
            if (object == null) {
                if (fieldValues == null) {
                    object = this.createInstance(parser, type);
                    if (childContext == null) {
                        childContext = parser.setContext(context, object, fieldName);
                    }
                    fieldIndex = object;
                    return (T)fieldIndex;
                }
                size = this.fieldDeserializers.length;
                params = new Object[size];
                for (i = 0; i < size; ++i) {
                    fieldInfo = this.fieldDeserializers[i].fieldInfo;
                    params[i] = fieldValues.get(fieldInfo.name);
                }
                if (this.beanInfo.creatorConstructor != null) {
                    try {
                        object = this.beanInfo.creatorConstructor.newInstance(params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create instance error, " + this.beanInfo.creatorConstructor.toGenericString(), e);
                    }
                }
                if (this.beanInfo.factoryMethod != null) {
                    try {
                        object = this.beanInfo.factoryMethod.invoke(null, params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create factory method error, " + this.beanInfo.factoryMethod.toString(), e);
                    }
                }
            }
            var10_14 = object;
            return (T)var10_14;
        }
        finally {
            if (childContext != null) {
                childContext.object = object;
            }
            parser.setContext(context);
        }
    }

    public FieldDeserializer getFieldDeserializer(String key) {
        if (key == null) {
            return null;
        }
        int low = 0;
        int high = this.sortedFieldDeserializers.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            String fieldName = this.sortedFieldDeserializers[mid].fieldInfo.name;
            int cmp = fieldName.compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return this.sortedFieldDeserializers[mid];
        }
        return null;
    }

    public boolean parseField(DefaultJSONParser parser, String key, Object object, Type objectType, Map<String, Object> fieldValues) {
        JSONLexer lexer = parser.lexer;
        FieldDeserializer fieldDeserializer = this.getFieldDeserializer(key);
        if (fieldDeserializer == null) {
            for (FieldDeserializer fieldDeser : this.sortedFieldDeserializers) {
                if (!fieldDeser.fieldInfo.name.equalsIgnoreCase(key)) continue;
                fieldDeserializer = fieldDeser;
                break;
            }
        }
        if (fieldDeserializer == null) {
            this.parseExtra(parser, object, key);
            return false;
        }
        lexer.nextTokenWithChar(':');
        fieldDeserializer.parseField(parser, object, objectType, fieldValues);
        return true;
    }

    void parseExtra(DefaultJSONParser parser, Object object, String key) {
        JSONLexer lexer = parser.lexer;
        if ((parser.lexer.features & Feature.IgnoreNotMatch.mask) == 0) {
            throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + key);
        }
        lexer.nextTokenWithChar(':');
        Type type = DefaultJSONParser.getExtratype(parser, object, key);
        Object value = type == null ? parser.parse() : parser.parseObject(type);
        DefaultJSONParser.processExtra(parser, object, key, value);
    }
}

