/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.JSONLexer;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static IntegerCodec instance = new IntegerCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.out;
        Number value = (Number)object;
        if (value == null) {
            if ((out.features & SerializerFeature.WriteNullNumberAsZero.mask) != 0) {
                out.write('0');
            } else {
                out.writeNull();
            }
            return;
        }
        if (fieldType == Long.TYPE) {
            out.writeLong(value.longValue());
        } else {
            out.writeInt(value.intValue());
        }
        if ((out.features & SerializerFeature.WriteClassName.mask) != 0) {
            long longValue;
            Class<?> clazz = value.getClass();
            if (clazz == Byte.class) {
                out.write('B');
            } else if (clazz == Short.class) {
                out.write('S');
            } else if (clazz == Long.class && (longValue = value.longValue()) <= Integer.MAX_VALUE && longValue >= Integer.MIN_VALUE && fieldType != Long.class) {
                out.write('L');
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Number intObj;
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
        }
        if (lexer.token() == 2) {
            if (clazz == Long.TYPE || clazz == Long.class) {
                long longValue = lexer.longValue();
                intObj = longValue;
            } else {
                int val = lexer.intValue();
                intObj = val;
            }
            lexer.nextToken(16);
        } else if (lexer.token() == 3) {
            BigDecimal decimalValue = lexer.decimalValue();
            lexer.nextToken(16);
            intObj = clazz == Long.TYPE || clazz == Long.class ? (Number)decimalValue.longValue() : (Number)decimalValue.intValue();
        } else {
            Object value = parser.parse();
            intObj = clazz == Long.TYPE || clazz == Long.class ? (Number)TypeUtils.castToLong(value) : (Number)TypeUtils.castToInt(value);
        }
        return (T)intObj;
    }
}

