/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.converters;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.bigdecimal.BigDecimalBooleanConverter;
import com.alibaba.excel.converters.bigdecimal.BigDecimalNumberConverter;
import com.alibaba.excel.converters.bigdecimal.BigDecimalStringConverter;
import com.alibaba.excel.converters.biginteger.BigIntegerBooleanConverter;
import com.alibaba.excel.converters.biginteger.BigIntegerNumberConverter;
import com.alibaba.excel.converters.biginteger.BigIntegerStringConverter;
import com.alibaba.excel.converters.booleanconverter.BooleanBooleanConverter;
import com.alibaba.excel.converters.booleanconverter.BooleanNumberConverter;
import com.alibaba.excel.converters.booleanconverter.BooleanStringConverter;
import com.alibaba.excel.converters.bytearray.BoxingByteArrayImageConverter;
import com.alibaba.excel.converters.bytearray.ByteArrayImageConverter;
import com.alibaba.excel.converters.byteconverter.ByteBooleanConverter;
import com.alibaba.excel.converters.byteconverter.ByteNumberConverter;
import com.alibaba.excel.converters.byteconverter.ByteStringConverter;
import com.alibaba.excel.converters.date.DateDateConverter;
import com.alibaba.excel.converters.date.DateNumberConverter;
import com.alibaba.excel.converters.date.DateStringConverter;
import com.alibaba.excel.converters.doubleconverter.DoubleBooleanConverter;
import com.alibaba.excel.converters.doubleconverter.DoubleNumberConverter;
import com.alibaba.excel.converters.doubleconverter.DoubleStringConverter;
import com.alibaba.excel.converters.file.FileImageConverter;
import com.alibaba.excel.converters.floatconverter.FloatBooleanConverter;
import com.alibaba.excel.converters.floatconverter.FloatNumberConverter;
import com.alibaba.excel.converters.floatconverter.FloatStringConverter;
import com.alibaba.excel.converters.inputstream.InputStreamImageConverter;
import com.alibaba.excel.converters.integer.IntegerBooleanConverter;
import com.alibaba.excel.converters.integer.IntegerNumberConverter;
import com.alibaba.excel.converters.integer.IntegerStringConverter;
import com.alibaba.excel.converters.localdatetime.LocalDateNumberConverter;
import com.alibaba.excel.converters.localdatetime.LocalDateTimeDateConverter;
import com.alibaba.excel.converters.localdatetime.LocalDateTimeStringConverter;
import com.alibaba.excel.converters.longconverter.LongBooleanConverter;
import com.alibaba.excel.converters.longconverter.LongNumberConverter;
import com.alibaba.excel.converters.longconverter.LongStringConverter;
import com.alibaba.excel.converters.shortconverter.ShortBooleanConverter;
import com.alibaba.excel.converters.shortconverter.ShortNumberConverter;
import com.alibaba.excel.converters.shortconverter.ShortStringConverter;
import com.alibaba.excel.converters.string.StringBooleanConverter;
import com.alibaba.excel.converters.string.StringErrorConverter;
import com.alibaba.excel.converters.string.StringNumberConverter;
import com.alibaba.excel.converters.string.StringStringConverter;
import com.alibaba.excel.converters.url.UrlImageConverter;
import com.alibaba.excel.util.MapUtils;
import java.util.Map;

public class DefaultConverterLoader {
    private static Map<ConverterKeyBuild.ConverterKey, Converter<?>> defaultWriteConverter;
    private static Map<ConverterKeyBuild.ConverterKey, Converter<?>> allConverter;

    private static void initAllConverter() {
        allConverter = MapUtils.newHashMapWithExpectedSize(40);
        DefaultConverterLoader.putAllConverter(new BigDecimalBooleanConverter());
        DefaultConverterLoader.putAllConverter(new BigDecimalNumberConverter());
        DefaultConverterLoader.putAllConverter(new BigDecimalStringConverter());
        DefaultConverterLoader.putAllConverter(new BigIntegerBooleanConverter());
        DefaultConverterLoader.putAllConverter(new BigIntegerNumberConverter());
        DefaultConverterLoader.putAllConverter(new BigIntegerStringConverter());
        DefaultConverterLoader.putAllConverter(new BooleanBooleanConverter());
        DefaultConverterLoader.putAllConverter(new BooleanNumberConverter());
        DefaultConverterLoader.putAllConverter(new BooleanStringConverter());
        DefaultConverterLoader.putAllConverter(new ByteBooleanConverter());
        DefaultConverterLoader.putAllConverter(new ByteNumberConverter());
        DefaultConverterLoader.putAllConverter(new ByteStringConverter());
        DefaultConverterLoader.putAllConverter(new DateNumberConverter());
        DefaultConverterLoader.putAllConverter(new DateStringConverter());
        DefaultConverterLoader.putAllConverter(new LocalDateNumberConverter());
        DefaultConverterLoader.putAllConverter(new LocalDateTimeStringConverter());
        DefaultConverterLoader.putAllConverter(new DoubleBooleanConverter());
        DefaultConverterLoader.putAllConverter(new DoubleNumberConverter());
        DefaultConverterLoader.putAllConverter(new DoubleStringConverter());
        DefaultConverterLoader.putAllConverter(new FloatBooleanConverter());
        DefaultConverterLoader.putAllConverter(new FloatNumberConverter());
        DefaultConverterLoader.putAllConverter(new FloatStringConverter());
        DefaultConverterLoader.putAllConverter(new IntegerBooleanConverter());
        DefaultConverterLoader.putAllConverter(new IntegerNumberConverter());
        DefaultConverterLoader.putAllConverter(new IntegerStringConverter());
        DefaultConverterLoader.putAllConverter(new LongBooleanConverter());
        DefaultConverterLoader.putAllConverter(new LongNumberConverter());
        DefaultConverterLoader.putAllConverter(new LongStringConverter());
        DefaultConverterLoader.putAllConverter(new ShortBooleanConverter());
        DefaultConverterLoader.putAllConverter(new ShortNumberConverter());
        DefaultConverterLoader.putAllConverter(new ShortStringConverter());
        DefaultConverterLoader.putAllConverter(new StringBooleanConverter());
        DefaultConverterLoader.putAllConverter(new StringNumberConverter());
        DefaultConverterLoader.putAllConverter(new StringStringConverter());
        DefaultConverterLoader.putAllConverter(new StringErrorConverter());
        DefaultConverterLoader.putAllConverter(new BigIntegerStringConverter());
    }

    private static void initDefaultWriteConverter() {
        defaultWriteConverter = MapUtils.newHashMapWithExpectedSize(40);
        DefaultConverterLoader.putWriteConverter(new BigDecimalNumberConverter());
        DefaultConverterLoader.putWriteConverter(new BigIntegerNumberConverter());
        DefaultConverterLoader.putWriteConverter(new BooleanBooleanConverter());
        DefaultConverterLoader.putWriteConverter(new ByteNumberConverter());
        DefaultConverterLoader.putWriteConverter(new DateDateConverter());
        DefaultConverterLoader.putWriteConverter(new LocalDateTimeDateConverter());
        DefaultConverterLoader.putWriteConverter(new DoubleNumberConverter());
        DefaultConverterLoader.putWriteConverter(new FloatNumberConverter());
        DefaultConverterLoader.putWriteConverter(new IntegerNumberConverter());
        DefaultConverterLoader.putWriteConverter(new LongNumberConverter());
        DefaultConverterLoader.putWriteConverter(new ShortNumberConverter());
        DefaultConverterLoader.putWriteConverter(new StringStringConverter());
        DefaultConverterLoader.putWriteConverter(new FileImageConverter());
        DefaultConverterLoader.putWriteConverter(new InputStreamImageConverter());
        DefaultConverterLoader.putWriteConverter(new ByteArrayImageConverter());
        DefaultConverterLoader.putWriteConverter(new BoxingByteArrayImageConverter());
        DefaultConverterLoader.putWriteConverter(new UrlImageConverter());
        DefaultConverterLoader.putWriteStringConverter(new BigDecimalStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new BigIntegerStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new BooleanStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new ByteStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new DateStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new LocalDateTimeStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new DoubleStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new FloatStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new IntegerStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new LongStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new ShortStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new StringStringConverter());
        DefaultConverterLoader.putWriteStringConverter(new BigIntegerStringConverter());
    }

    public static Map<ConverterKeyBuild.ConverterKey, Converter<?>> loadDefaultWriteConverter() {
        return defaultWriteConverter;
    }

    private static void putWriteConverter(Converter<?> converter) {
        defaultWriteConverter.put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey()), converter);
    }

    private static void putWriteStringConverter(Converter<?> converter) {
        defaultWriteConverter.put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey(), converter.supportExcelTypeKey()), converter);
    }

    public static Map<ConverterKeyBuild.ConverterKey, Converter<?>> loadDefaultReadConverter() {
        return DefaultConverterLoader.loadAllConverter();
    }

    public static Map<ConverterKeyBuild.ConverterKey, Converter<?>> loadAllConverter() {
        return allConverter;
    }

    private static void putAllConverter(Converter<?> converter) {
        allConverter.put(ConverterKeyBuild.buildKey(converter.supportJavaTypeKey(), converter.supportExcelTypeKey()), converter);
    }

    static {
        DefaultConverterLoader.initDefaultWriteConverter();
        DefaultConverterLoader.initAllConverter();
    }
}

