/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis.csv;

import com.alibaba.excel.analysis.ExcelReadExecutor;
import com.alibaba.excel.context.csv.CsvReadContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.enums.RowTypeEnum;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.metadata.Cell;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.holder.ReadRowHolder;
import com.alibaba.excel.read.metadata.holder.csv.CsvReadWorkbookHolder;
import com.alibaba.excel.util.SheetUtils;
import com.alibaba.excel.util.StringUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvExcelReadExecutor
implements ExcelReadExecutor {
    private static final Logger log = LoggerFactory.getLogger(CsvExcelReadExecutor.class);
    private final List<ReadSheet> sheetList;
    private final CsvReadContext csvReadContext;

    public CsvExcelReadExecutor(CsvReadContext csvReadContext) {
        this.csvReadContext = csvReadContext;
        this.sheetList = new ArrayList<ReadSheet>();
        ReadSheet readSheet = new ReadSheet();
        this.sheetList.add(readSheet);
        readSheet.setSheetNo(0);
    }

    @Override
    public List<ReadSheet> sheetList() {
        return this.sheetList;
    }

    @Override
    public void execute() {
        CSVParser csvParser;
        try {
            csvParser = this.csvParser();
            this.csvReadContext.csvReadWorkbookHolder().setCsvParser(csvParser);
        }
        catch (IOException e) {
            throw new ExcelAnalysisException(e);
        }
        for (ReadSheet readSheet : this.sheetList) {
            if ((readSheet = SheetUtils.match(readSheet, this.csvReadContext)) == null) continue;
            this.csvReadContext.currentSheet(readSheet);
            int rowIndex = 0;
            for (CSVRecord record : csvParser) {
                this.dealRecord(record, rowIndex++);
            }
            this.csvReadContext.analysisEventProcessor().endSheet(this.csvReadContext);
        }
    }

    private CSVParser csvParser() throws IOException {
        CsvReadWorkbookHolder csvReadWorkbookHolder = this.csvReadContext.csvReadWorkbookHolder();
        CSVFormat csvFormat = csvReadWorkbookHolder.getCsvFormat();
        if (csvReadWorkbookHolder.getMandatoryUseInputStream().booleanValue()) {
            return csvFormat.parse((Reader)new InputStreamReader(csvReadWorkbookHolder.getInputStream(), csvReadWorkbookHolder.getCharset()));
        }
        if (csvReadWorkbookHolder.getFile() != null) {
            return csvFormat.parse((Reader)new InputStreamReader(Files.newInputStream(csvReadWorkbookHolder.getFile().toPath(), new OpenOption[0]), csvReadWorkbookHolder.getCharset()));
        }
        return csvFormat.parse((Reader)new InputStreamReader(csvReadWorkbookHolder.getInputStream(), csvReadWorkbookHolder.getCharset()));
    }

    private void dealRecord(CSVRecord record, int rowIndex) {
        LinkedHashMap<Integer, Cell> cellMap = new LinkedHashMap<Integer, Cell>();
        Iterator cellIterator = record.iterator();
        int columnIndex = 0;
        Boolean autoTrim = this.csvReadContext.currentReadHolder().globalConfiguration().getAutoTrim();
        while (cellIterator.hasNext()) {
            String cellString = (String)cellIterator.next();
            ReadCellData readCellData = new ReadCellData();
            readCellData.setRowIndex(rowIndex);
            readCellData.setColumnIndex(columnIndex);
            if (StringUtils.isNotBlank(cellString)) {
                readCellData.setType(CellDataTypeEnum.STRING);
                readCellData.setStringValue(autoTrim != false ? cellString.trim() : cellString);
            } else {
                readCellData.setType(CellDataTypeEnum.EMPTY);
            }
            cellMap.put(columnIndex++, readCellData);
        }
        RowTypeEnum rowType = MapUtils.isEmpty(cellMap) ? RowTypeEnum.EMPTY : RowTypeEnum.DATA;
        ReadRowHolder readRowHolder = new ReadRowHolder(rowIndex, rowType, this.csvReadContext.readWorkbookHolder().getGlobalConfiguration(), cellMap);
        this.csvReadContext.readRowHolder(readRowHolder);
        this.csvReadContext.csvReadSheetHolder().setCellMap(cellMap);
        this.csvReadContext.csvReadSheetHolder().setRowIndex(rowIndex);
        this.csvReadContext.analysisEventProcessor().endRow(this.csvReadContext);
    }
}

