/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.analysis;

import com.alibaba.excel.analysis.ExcelAnalyser;
import com.alibaba.excel.analysis.ExcelReadExecutor;
import com.alibaba.excel.analysis.csv.CsvExcelReadExecutor;
import com.alibaba.excel.analysis.v03.XlsSaxAnalyser;
import com.alibaba.excel.analysis.v07.XlsxSaxAnalyser;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.context.csv.DefaultCsvReadContext;
import com.alibaba.excel.context.xls.DefaultXlsReadContext;
import com.alibaba.excel.context.xlsx.DefaultXlsxReadContext;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.exception.ExcelAnalysisStopException;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.read.metadata.ReadWorkbook;
import com.alibaba.excel.read.metadata.holder.ReadWorkbookHolder;
import com.alibaba.excel.read.metadata.holder.csv.CsvReadWorkbookHolder;
import com.alibaba.excel.read.metadata.holder.xls.XlsReadWorkbookHolder;
import com.alibaba.excel.read.metadata.holder.xlsx.XlsxReadWorkbookHolder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.util.DateUtils;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.util.NumberDataFormatterUtils;
import com.alibaba.excel.util.StringUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelAnalyserImpl
implements ExcelAnalyser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelAnalyserImpl.class);
    private AnalysisContext analysisContext;
    private ExcelReadExecutor excelReadExecutor;
    private boolean finished = false;

    public ExcelAnalyserImpl(ReadWorkbook readWorkbook) {
        try {
            this.choiceExcelExecutor(readWorkbook);
        }
        catch (RuntimeException e) {
            this.finish();
            throw e;
        }
        catch (Throwable e) {
            this.finish();
            throw new ExcelAnalysisException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void choiceExcelExecutor(ReadWorkbook readWorkbook) throws Exception {
        ExcelTypeEnum excelType = ExcelTypeEnum.valueOf(readWorkbook);
        switch (excelType) {
            case XLS: {
                POIFSFileSystem poifsFileSystem = readWorkbook.getFile() != null ? new POIFSFileSystem(readWorkbook.getFile()) : new POIFSFileSystem(readWorkbook.getInputStream());
                if (poifsFileSystem.getRoot().hasEntry("EncryptedPackage")) {
                    InputStream decryptedStream = null;
                    try {
                        decryptedStream = DocumentFactoryHelper.getDecryptedStream((POIFSFileSystem)poifsFileSystem.getRoot().getFileSystem(), (String)readWorkbook.getPassword());
                        DefaultXlsxReadContext xlsxReadContext = new DefaultXlsxReadContext(readWorkbook, ExcelTypeEnum.XLSX);
                        this.analysisContext = xlsxReadContext;
                        this.excelReadExecutor = new XlsxSaxAnalyser(xlsxReadContext, decryptedStream);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(decryptedStream);
                        poifsFileSystem.close();
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Closeable)decryptedStream);
                    poifsFileSystem.close();
                    return;
                }
                if (readWorkbook.getPassword() != null) {
                    Biff8EncryptionKey.setCurrentUserPassword((String)readWorkbook.getPassword());
                }
                DefaultXlsReadContext xlsReadContext = new DefaultXlsReadContext(readWorkbook, ExcelTypeEnum.XLS);
                xlsReadContext.xlsReadWorkbookHolder().setPoifsFileSystem(poifsFileSystem);
                this.analysisContext = xlsReadContext;
                this.excelReadExecutor = new XlsSaxAnalyser(xlsReadContext);
                break;
            }
            case XLSX: {
                DefaultXlsxReadContext xlsxReadContext = new DefaultXlsxReadContext(readWorkbook, ExcelTypeEnum.XLSX);
                this.analysisContext = xlsxReadContext;
                this.excelReadExecutor = new XlsxSaxAnalyser(xlsxReadContext, null);
                break;
            }
            case CSV: {
                DefaultCsvReadContext csvReadContext = new DefaultCsvReadContext(readWorkbook, ExcelTypeEnum.CSV);
                this.analysisContext = csvReadContext;
                this.excelReadExecutor = new CsvExcelReadExecutor(csvReadContext);
                break;
            }
        }
    }

    @Override
    public void analysis(List<ReadSheet> readSheetList, Boolean readAll) {
        try {
            if (!readAll.booleanValue() && CollectionUtils.isEmpty(readSheetList)) {
                throw new IllegalArgumentException("Specify at least one read sheet.");
            }
            this.analysisContext.readWorkbookHolder().setParameterSheetDataList(readSheetList);
            this.analysisContext.readWorkbookHolder().setReadAll(readAll);
            try {
                this.excelReadExecutor.execute();
            }
            catch (ExcelAnalysisStopException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Custom stop!");
                }
            }
        }
        catch (RuntimeException e) {
            this.finish();
            throw e;
        }
        catch (Throwable e) {
            this.finish();
            throw new ExcelAnalysisException(e);
        }
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.analysisContext == null || this.analysisContext.readWorkbookHolder() == null) {
            return;
        }
        ReadWorkbookHolder readWorkbookHolder = this.analysisContext.readWorkbookHolder();
        Throwable throwable = null;
        try {
            if (readWorkbookHolder.getReadCache() != null) {
                readWorkbookHolder.getReadCache().destroy();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (readWorkbookHolder instanceof XlsxReadWorkbookHolder && ((XlsxReadWorkbookHolder)readWorkbookHolder).getOpcPackage() != null) {
                ((XlsxReadWorkbookHolder)readWorkbookHolder).getOpcPackage().revert();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (readWorkbookHolder instanceof XlsReadWorkbookHolder && ((XlsReadWorkbookHolder)readWorkbookHolder).getPoifsFileSystem() != null) {
                ((XlsReadWorkbookHolder)readWorkbookHolder).getPoifsFileSystem().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (readWorkbookHolder instanceof CsvReadWorkbookHolder && ((CsvReadWorkbookHolder)readWorkbookHolder).getCsvParser() != null) {
                ((CsvReadWorkbookHolder)readWorkbookHolder).getCsvParser().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (this.analysisContext.readWorkbookHolder().getAutoCloseStream().booleanValue() && readWorkbookHolder.getInputStream() != null) {
                readWorkbookHolder.getInputStream().close();
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        try {
            if (readWorkbookHolder.getTempFile() != null) {
                FileUtils.delete(readWorkbookHolder.getTempFile());
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        this.clearEncrypt03();
        this.removeThreadLocalCache();
        if (throwable != null) {
            throw new ExcelAnalysisException("Can not close IO.", throwable);
        }
    }

    private void removeThreadLocalCache() {
        NumberDataFormatterUtils.removeThreadLocalCache();
        DateUtils.removeThreadLocalCache();
    }

    private void clearEncrypt03() {
        if (StringUtils.isEmpty(this.analysisContext.readWorkbookHolder().getPassword()) || !ExcelTypeEnum.XLS.equals((Object)this.analysisContext.readWorkbookHolder().getExcelType())) {
            return;
        }
        Biff8EncryptionKey.setCurrentUserPassword(null);
    }

    @Override
    public ExcelReadExecutor excelExecutor() {
        return this.excelReadExecutor;
    }

    @Override
    public AnalysisContext analysisContext() {
        return this.analysisContext;
    }
}

