/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import java.util.regex.Pattern;

public class PositionUtils {
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("(\\$?[A-Z]+)?(\\$?[0-9]+)?", 2);
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char REDUNDANT_CHARACTERS = '$';

    private PositionUtils() {
    }

    public static int getRowByRowTagt(String rowTagt, Integer before) {
        if (rowTagt != null) {
            int row = Integer.parseInt(rowTagt) - 1;
            return row;
        }
        if (before == null) {
            before = -1;
        }
        return before + 1;
    }

    public static int getRow(String currentCellIndex) {
        char c;
        int firstNumber;
        if (currentCellIndex == null) {
            return -1;
        }
        for (firstNumber = currentCellIndex.length() - 1; firstNumber >= 0 && (c = currentCellIndex.charAt(firstNumber)) >= '0' && c <= '9'; --firstNumber) {
        }
        return Integer.parseUnsignedInt(currentCellIndex.substring(firstNumber + 1)) - 1;
    }

    public static int getCol(String currentCellIndex, Integer before) {
        if (currentCellIndex == null) {
            if (before == null) {
                before = -1;
            }
            return before + 1;
        }
        int col = 0;
        for (int firstNumber = currentCellIndex.charAt(0) == '$' ? 1 : 0; firstNumber < currentCellIndex.length(); ++firstNumber) {
            boolean isNotLetter;
            char c = currentCellIndex.charAt(firstNumber);
            boolean bl = isNotLetter = c == '$' || c >= '0' && c <= '9';
            if (isNotLetter) break;
            col = col * 26 + Character.toUpperCase(c) - 65 + 1;
        }
        return col - 1;
    }
}

