/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.util;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.ConverterKeyBuild;
import com.alibaba.excel.converters.NullableObjectConverter;
import com.alibaba.excel.converters.ReadConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.alibaba.excel.read.metadata.holder.ReadSheetHolder;
import com.alibaba.excel.util.MapUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class ConverterUtils {
    public static Class<?> defaultClassGeneric = String.class;

    private ConverterUtils() {
    }

    public static Map<Integer, String> convertToStringMap(Map<Integer, ReadCellData<?>> cellDataMap, AnalysisContext context) {
        HashMap<Integer, String> stringMap = MapUtils.newHashMapWithExpectedSize(cellDataMap.size());
        ReadSheetHolder readSheetHolder = context.readSheetHolder();
        int index = 0;
        for (Map.Entry<Integer, ReadCellData<?>> entry : cellDataMap.entrySet()) {
            Integer key = entry.getKey();
            ReadCellData<?> cellData = entry.getValue();
            while (index < key) {
                stringMap.put(index, null);
                ++index;
            }
            ++index;
            if (cellData.getType() == CellDataTypeEnum.EMPTY) {
                stringMap.put(key, null);
                continue;
            }
            Converter<?> converter = readSheetHolder.converterMap().get(ConverterKeyBuild.buildKey(String.class, cellData.getType()));
            if (converter == null) {
                throw new ExcelDataConvertException(context.readRowHolder().getRowIndex(), key, cellData, null, "Converter not found, convert " + (Object)((Object)cellData.getType()) + " to String");
            }
            try {
                stringMap.put(key, (String)converter.convertToJavaData(new ReadConverterContext(cellData, null, context)));
            }
            catch (Exception e) {
                throw new ExcelDataConvertException(context.readRowHolder().getRowIndex(), key, cellData, null, "Convert data " + cellData + " to String error ", e);
            }
        }
        return stringMap;
    }

    public static Object convertToJavaObject(ReadCellData<?> cellData, Field field, ExcelContentProperty contentProperty, Map<ConverterKeyBuild.ConverterKey, Converter<?>> converterMap, AnalysisContext context, Integer rowIndex, Integer columnIndex) {
        Class clazz = field == null ? String.class : field.getType();
        if (clazz == CellData.class || clazz == ReadCellData.class) {
            Class<?> classGeneric = ConverterUtils.getClassGeneric(field.getGenericType());
            Object cellDataReturn = cellData.clone();
            ((CellData)cellDataReturn).setData(ConverterUtils.doConvertToJavaObject(cellData, classGeneric, contentProperty, converterMap, context, rowIndex, columnIndex));
            return cellDataReturn;
        }
        return ConverterUtils.doConvertToJavaObject(cellData, clazz, contentProperty, converterMap, context, rowIndex, columnIndex);
    }

    private static Class<?> getClassGeneric(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return defaultClassGeneric;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] types = parameterizedType.getActualTypeArguments();
        if (types == null || types.length == 0) {
            return defaultClassGeneric;
        }
        Type actualType = types[0];
        if (!(actualType instanceof Class)) {
            return defaultClassGeneric;
        }
        return (Class)actualType;
    }

    private static Object doConvertToJavaObject(ReadCellData<?> cellData, Class<?> clazz, ExcelContentProperty contentProperty, Map<ConverterKeyBuild.ConverterKey, Converter<?>> converterMap, AnalysisContext context, Integer rowIndex, Integer columnIndex) {
        boolean canNotConverterEmpty;
        Converter<?> converter = null;
        if (contentProperty != null) {
            converter = contentProperty.getConverter();
        }
        boolean bl = canNotConverterEmpty = cellData.getType() == CellDataTypeEnum.EMPTY && !(converter instanceof NullableObjectConverter);
        if (canNotConverterEmpty) {
            return null;
        }
        if (converter == null) {
            converter = converterMap.get(ConverterKeyBuild.buildKey(clazz, cellData.getType()));
        }
        if (converter == null) {
            throw new ExcelDataConvertException(rowIndex, columnIndex, cellData, contentProperty, "Converter not found, convert " + (Object)((Object)cellData.getType()) + " to " + clazz.getName());
        }
        try {
            return converter.convertToJavaData(new ReadConverterContext(cellData, contentProperty, context));
        }
        catch (Exception e) {
            throw new ExcelDataConvertException(rowIndex, columnIndex, cellData, contentProperty, "Convert data " + cellData + " to " + clazz + " error ", e);
        }
    }
}

