/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.nlp.understanding;

import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.nlp.understanding.UnderstandingOutput;
import com.alibaba.dashscope.nlp.understanding.UnderstandingUsage;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnderstandingResult {
    private static final Logger log = LoggerFactory.getLogger(UnderstandingResult.class);
    private String requestId;
    private UnderstandingUsage usage;
    private UnderstandingOutput output;

    private UnderstandingResult() {
    }

    public static UnderstandingResult fromDashScopeResult(DashScopeResult dashScopeResult) {
        UnderstandingResult result = new UnderstandingResult();
        result.setRequestId(dashScopeResult.getRequestId());
        if (dashScopeResult.getUsage() != null) {
            result.setUsage(JsonUtils.fromJsonObject((JsonElement)dashScopeResult.getUsage().getAsJsonObject(), UnderstandingUsage.class));
        }
        if (dashScopeResult.getOutput() != null) {
            result.setOutput(JsonUtils.fromJsonObject((JsonElement)((JsonObject)dashScopeResult.getOutput()), UnderstandingOutput.class));
        } else {
            log.error(String.format("Result no output: %s", dashScopeResult));
        }
        return result;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public UnderstandingUsage getUsage() {
        return this.usage;
    }

    public UnderstandingOutput getOutput() {
        return this.output;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setUsage(UnderstandingUsage usage) {
        this.usage = usage;
    }

    public void setOutput(UnderstandingOutput output) {
        this.output = output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnderstandingResult)) {
            return false;
        }
        UnderstandingResult other = (UnderstandingResult)o;
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        UnderstandingUsage this$usage = this.getUsage();
        UnderstandingUsage other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage)) {
            return false;
        }
        UnderstandingOutput this$output = this.getOutput();
        UnderstandingOutput other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        UnderstandingUsage $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        UnderstandingOutput $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        return result;
    }

    public String toString() {
        return "UnderstandingResult(requestId=" + this.getRequestId() + ", usage=" + this.getUsage() + ", output=" + this.getOutput() + ")";
    }
}

