/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.binding;

import com.alibaba.bytekit.asm.binding.Binding;
import com.alibaba.bytekit.asm.binding.BindingContext;
import com.alibaba.bytekit.asm.location.Location;
import com.alibaba.bytekit.utils.AsmOpUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.deps.org.objectweb.asm.tree.LocalVariableNode;

public class InvokeArgsBinding
extends Binding {
    @Override
    public boolean fromStack() {
        return true;
    }

    @Override
    public void pushOntoStack(InsnList instructions, BindingContext bindingContext) {
        Location location = bindingContext.getLocation();
        if (location instanceof Location.InvokeLocation) {
            Location.InvokeLocation invokeLocation = (Location.InvokeLocation)location;
            if (invokeLocation.isWhenComplete()) {
                throw new IllegalArgumentException("InvokeArgsBinding can not work on InvokeLocation whenComplete is true.");
            }
        } else {
            throw new IllegalArgumentException("current location is not invoke location. location: " + location);
        }
        LocalVariableNode invokeArgsVariableNode = bindingContext.getMethodProcessor().initInvokeArgsVariableNode();
        AsmOpUtils.loadVar(instructions, AsmOpUtils.OBJECT_ARRAY_TYPE, invokeArgsVariableNode.index);
    }

    @Override
    public Type getType(BindingContext bindingContext) {
        return AsmOpUtils.OBJECT_ARRAY_TYPE;
    }
}

