/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.interceptor.annotation;

import com.alibaba.bytekit.asm.binding.Binding;
import com.alibaba.bytekit.asm.interceptor.InterceptorMethodConfig;
import com.alibaba.bytekit.asm.interceptor.InterceptorProcessor;
import com.alibaba.bytekit.asm.interceptor.annotation.BindingParserUtils;
import com.alibaba.bytekit.asm.interceptor.annotation.ExceptionHandlerUtils;
import com.alibaba.bytekit.asm.location.LocationMatcher;
import com.alibaba.deps.org.objectweb.asm.Type;
import java.lang.reflect.Method;
import java.util.List;

public class InterceptorParserUtils {
    public static InterceptorProcessor createInterceptorProcessor(Method method, LocationMatcher locationMatcher) {
        return InterceptorParserUtils.createInterceptorProcessor(method, locationMatcher, true);
    }

    public static InterceptorProcessor createInterceptorProcessor(Method method, LocationMatcher locationMatcher, boolean inline) {
        return InterceptorParserUtils.createInterceptorProcessor(method, locationMatcher, inline, null, null);
    }

    public static InterceptorProcessor createInterceptorProcessor(Method method, LocationMatcher locationMatcher, boolean inline, Class<? extends Throwable> suppress, Class<?> suppressHandler) {
        InterceptorMethodConfig errorHandlerMethodConfig;
        InterceptorProcessor interceptorProcessor = new InterceptorProcessor(method.getDeclaringClass().getClassLoader());
        interceptorProcessor.setLocationMatcher(locationMatcher);
        InterceptorMethodConfig interceptorMethodConfig = new InterceptorMethodConfig();
        interceptorProcessor.setInterceptorMethodConfig(interceptorMethodConfig);
        interceptorMethodConfig.setOwner(Type.getInternalName(method.getDeclaringClass()));
        interceptorMethodConfig.setMethodName(method.getName());
        interceptorMethodConfig.setMethodDesc(Type.getMethodDescriptor((Method)method));
        interceptorMethodConfig.setInline(inline);
        List<Binding> bindings = BindingParserUtils.parseBindings(method);
        interceptorMethodConfig.setBindings(bindings);
        if (suppress != null && (errorHandlerMethodConfig = ExceptionHandlerUtils.errorHandlerMethodConfig(suppress, suppressHandler)) != null) {
            interceptorProcessor.setExceptionHandlerConfig(errorHandlerMethodConfig);
        }
        return interceptorProcessor;
    }
}

