/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.interceptor.parser;

import com.alibaba.bytekit.asm.interceptor.InterceptorProcessor;
import com.alibaba.bytekit.asm.interceptor.annotation.InterceptorParserHander;
import com.alibaba.bytekit.asm.interceptor.parser.InterceptorClassParser;
import com.alibaba.bytekit.asm.interceptor.parser.InterceptorProcessorParser;
import com.alibaba.bytekit.utils.InstanceUtils;
import com.alibaba.bytekit.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class DefaultInterceptorClassParser
implements InterceptorClassParser {
    @Override
    public List<InterceptorProcessor> parse(Class<?> clazz) {
        final ArrayList<InterceptorProcessor> result = new ArrayList<InterceptorProcessor>();
        ReflectionUtils.MethodCallback methodCallback = new ReflectionUtils.MethodCallback(){

            @Override
            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                for (Annotation onMethodAnnotation : method.getAnnotations()) {
                    for (Annotation onAnnotation : onMethodAnnotation.annotationType().getAnnotations()) {
                        if (!InterceptorParserHander.class.isAssignableFrom(onAnnotation.annotationType())) continue;
                        if (!Modifier.isStatic(method.getModifiers())) {
                            throw new IllegalArgumentException("method must be static. method: " + method);
                        }
                        InterceptorParserHander handler = (InterceptorParserHander)onAnnotation;
                        InterceptorProcessorParser interceptorProcessorParser = InstanceUtils.newInstance(handler.parserHander());
                        InterceptorProcessor interceptorProcessor = interceptorProcessorParser.parse(method, onMethodAnnotation);
                        result.add(interceptorProcessor);
                    }
                }
            }
        };
        ReflectionUtils.doWithMethods(clazz, methodCallback);
        return result;
    }
}

