/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.bytekit.asm.interceptor;

import com.alibaba.bytekit.asm.MethodProcessor;
import com.alibaba.bytekit.asm.TryCatchBlock;
import com.alibaba.bytekit.asm.binding.Binding;
import com.alibaba.bytekit.asm.binding.BindingContext;
import com.alibaba.bytekit.asm.binding.StackSaver;
import com.alibaba.bytekit.asm.interceptor.InterceptorMethodConfig;
import com.alibaba.bytekit.asm.location.Location;
import com.alibaba.bytekit.asm.location.LocationMatcher;
import com.alibaba.bytekit.utils.AsmOpUtils;
import com.alibaba.bytekit.utils.AsmUtils;
import com.alibaba.deps.org.objectweb.asm.Type;
import com.alibaba.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.deps.org.objectweb.asm.tree.JumpInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.LabelNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.alibaba.deps.org.objectweb.asm.tree.MethodNode;
import java.util.List;

public class InterceptorProcessor {
    private LocationMatcher locationMatcher;
    private InterceptorMethodConfig interceptorMethodConfig;
    private InterceptorMethodConfig exceptionHandlerConfig;
    private ClassLoader classLoader;

    public InterceptorProcessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<Location> process(MethodProcessor methodProcessor) throws Exception {
        List<Location> locations = this.locationMatcher.match(methodProcessor);
        List<Binding> interceptorBindings = this.interceptorMethodConfig.getBindings();
        for (Location location : locations) {
            MethodNode toInlineMethodNode;
            Class<?> forName;
            InsnList toInsert = new InsnList();
            InsnList stackSaveInsnList = new InsnList();
            InsnList stackLoadInsnList = new InsnList();
            StackSaver stackSaver = null;
            if (location.isStackNeedSave()) {
                stackSaver = location.getStackSaver();
            }
            BindingContext bindingContext = new BindingContext(location, methodProcessor, stackSaver);
            if (stackSaver != null) {
                stackSaver.store(stackSaveInsnList, bindingContext);
                stackSaver.load(stackLoadInsnList, bindingContext);
            }
            Type methodType = Type.getMethodType((String)this.interceptorMethodConfig.getMethodDesc());
            Type[] argumentTypes = methodType.getArgumentTypes();
            if (interceptorBindings.size() != argumentTypes.length) {
                throw new IllegalArgumentException("interceptorBindings size no equals with interceptorMethod args size.");
            }
            int fromStackBindingCount = 0;
            for (Binding binding : interceptorBindings) {
                if (!binding.fromStack()) continue;
                ++fromStackBindingCount;
            }
            if (fromStackBindingCount > 1) {
                throw new IllegalArgumentException("interceptorBindings have more than one from stack Binding.");
            }
            for (int i = 0; i < argumentTypes.length; ++i) {
                Binding binding;
                binding = interceptorBindings.get(i);
                binding.pushOntoStack(toInsert, bindingContext);
                Type bindingType = binding.getType(bindingContext);
                if (bindingType.equals((Object)argumentTypes[i]) || !AsmOpUtils.needBox(bindingType)) continue;
                AsmOpUtils.box(toInsert, binding.getType(bindingContext));
            }
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, this.interceptorMethodConfig.getOwner(), this.interceptorMethodConfig.getMethodName(), this.interceptorMethodConfig.getMethodDesc(), false));
            if (!methodType.getReturnType().equals((Object)Type.VOID_TYPE)) {
                if (location.canChangeByReturn()) {
                    Type stackSaverType;
                    Type returnType = methodType.getReturnType();
                    if (!returnType.equals((Object)(stackSaverType = stackSaver.getType(bindingContext)))) {
                        AsmOpUtils.unbox(toInsert, stackSaverType);
                    }
                    stackSaver.store(toInsert, bindingContext);
                } else {
                    int size = methodType.getReturnType().getSize();
                    if (size == 1) {
                        AsmOpUtils.pop(toInsert);
                    } else if (size == 2) {
                        AsmOpUtils.pop2(toInsert);
                    }
                }
            }
            TryCatchBlock errorHandlerTryCatchBlock = null;
            if (this.exceptionHandlerConfig != null) {
                LabelNode gotoDest = new LabelNode();
                errorHandlerTryCatchBlock = new TryCatchBlock(methodProcessor.getMethodNode(), this.exceptionHandlerConfig.getSuppress());
                toInsert.insertBefore(toInsert.getFirst(), (AbstractInsnNode)errorHandlerTryCatchBlock.getStartLabelNode());
                toInsert.add((AbstractInsnNode)new JumpInsnNode(167, gotoDest));
                toInsert.add((AbstractInsnNode)errorHandlerTryCatchBlock.getEndLabelNode());
                this.errorHandler(methodProcessor, toInsert);
                toInsert.add((AbstractInsnNode)gotoDest);
            }
            stackSaveInsnList.add(toInsert);
            stackSaveInsnList.add(stackLoadInsnList);
            if (location.isWhenComplete()) {
                methodProcessor.getMethodNode().instructions.insert(location.getInsnNode(), stackSaveInsnList);
            } else {
                methodProcessor.getMethodNode().instructions.insertBefore(location.getInsnNode(), stackSaveInsnList);
            }
            if (this.exceptionHandlerConfig != null) {
                errorHandlerTryCatchBlock.sort();
            }
            if (this.interceptorMethodConfig.isInline()) {
                forName = this.classLoader.loadClass(Type.getObjectType((String)this.interceptorMethodConfig.getOwner()).getClassName());
                toInlineMethodNode = AsmUtils.findMethod(AsmUtils.loadClass(forName).methods, this.interceptorMethodConfig.getMethodName(), this.interceptorMethodConfig.getMethodDesc());
                methodProcessor.inline(this.interceptorMethodConfig.getOwner(), toInlineMethodNode);
            }
            if (this.exceptionHandlerConfig == null || !this.exceptionHandlerConfig.isInline()) continue;
            forName = this.classLoader.loadClass(Type.getObjectType((String)this.exceptionHandlerConfig.getOwner()).getClassName());
            toInlineMethodNode = AsmUtils.findMethod(AsmUtils.loadClass(forName).methods, this.exceptionHandlerConfig.getMethodName(), this.exceptionHandlerConfig.getMethodDesc());
            methodProcessor.inline(this.exceptionHandlerConfig.getOwner(), toInlineMethodNode);
        }
        return locations;
    }

    private void errorHandler(MethodProcessor methodProcessor, InsnList insnList) {
        BindingContext bindingContext = new BindingContext(null, methodProcessor, null);
        Type methodType = Type.getMethodType((String)this.exceptionHandlerConfig.getMethodDesc());
        Type[] argumentTypes = methodType.getArgumentTypes();
        List<Binding> bindings = this.exceptionHandlerConfig.getBindings();
        if (bindings.size() + 1 != argumentTypes.length) {
            throw new IllegalArgumentException("errorHandler bindings size do not match error method args size.");
        }
        if (!argumentTypes[0].equals((Object)Type.getType(Throwable.class))) {
            throw new IllegalArgumentException("errorHandler method first arg type must be Throwable.");
        }
        for (Binding binding : bindings) {
            if (binding.fromStack()) {
                throw new IllegalArgumentException("errorHandler binding can not load value from stack!");
            }
            binding.pushOntoStack(insnList, bindingContext);
            if (!AsmOpUtils.needBox(binding.getType(bindingContext))) continue;
            AsmOpUtils.box(insnList, binding.getType(bindingContext));
        }
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, this.exceptionHandlerConfig.getOwner(), this.exceptionHandlerConfig.getMethodName(), this.exceptionHandlerConfig.getMethodDesc(), false));
        int size = methodType.getReturnType().getSize();
        if (size == 1) {
            AsmOpUtils.pop(insnList);
        } else if (size == 2) {
            AsmOpUtils.pop2(insnList);
        }
    }

    public LocationMatcher getLocationMatcher() {
        return this.locationMatcher;
    }

    public void setLocationMatcher(LocationMatcher locationMatcher) {
        this.locationMatcher = locationMatcher;
    }

    public InterceptorMethodConfig getInterceptorMethodConfig() {
        return this.interceptorMethodConfig;
    }

    public void setInterceptorMethodConfig(InterceptorMethodConfig interceptorMethodConfig) {
        this.interceptorMethodConfig = interceptorMethodConfig;
    }

    public InterceptorMethodConfig getExceptionHandlerConfig() {
        return this.exceptionHandlerConfig;
    }

    public void setExceptionHandlerConfig(InterceptorMethodConfig exceptionHandlerConfig) {
        this.exceptionHandlerConfig = exceptionHandlerConfig;
    }
}

