/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.bytekit.asm.location;

import com.alibaba.arthas.deps.org.objectweb.asm.Type;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.InsnList;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.JumpInsnNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.LabelNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.alibaba.arthas.deps.org.objectweb.asm.tree.MethodNode;
import com.taobao.arthas.bytekit.asm.MethodProcessor;
import com.taobao.arthas.bytekit.asm.TryCatchBlock;
import com.taobao.arthas.bytekit.asm.location.Location;
import com.taobao.arthas.bytekit.asm.location.LocationMatcher;
import com.taobao.arthas.bytekit.asm.location.LocationType;
import com.taobao.arthas.bytekit.asm.location.filter.LocationFilter;
import com.taobao.arthas.bytekit.utils.AsmOpUtils;
import com.taobao.arthas.bytekit.utils.MatchUtils;
import java.util.ArrayList;
import java.util.List;

public class InvokeLocationMatcher
implements LocationMatcher {
    private String methodName;
    private String owner;
    private String desc;
    private int count;
    private boolean whenComplete;
    private List<String> excludes = new ArrayList<String>();
    private boolean atInvokeExcpetionExit = false;

    public InvokeLocationMatcher(String owner, String methodName, String desc, int count, boolean whenComplete, List<String> excludes, boolean atInvokeExcpetionExit) {
        this.owner = owner;
        this.methodName = methodName;
        this.desc = desc;
        this.count = count;
        this.whenComplete = whenComplete;
        this.excludes = excludes;
        this.atInvokeExcpetionExit = atInvokeExcpetionExit;
    }

    public InvokeLocationMatcher(String owner, String methodName, String desc, int count, boolean whenComplete, List<String> excludes) {
        this(owner, methodName, desc, count, whenComplete, excludes, false);
    }

    public InvokeLocationMatcher(String owner, String methodName, String desc, int count, boolean whenComplete) {
        this(owner, methodName, desc, count, whenComplete, new ArrayList<String>());
    }

    @Override
    public List<Location> match(MethodProcessor methodProcessor) {
        if (this.atInvokeExcpetionExit) {
            return this.matchForException(methodProcessor);
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        LocationFilter locationFilter = methodProcessor.getLocationFilter();
        LocationType locationType = this.whenComplete ? LocationType.INVOKE_COMPLETED : LocationType.INVOKE;
        int matchedCount = 0;
        for (AbstractInsnNode insnNode = methodProcessor.getEnterInsnNode(); insnNode != null; insnNode = insnNode.getNext()) {
            MethodInsnNode methodInsnNode;
            if (!(insnNode instanceof MethodInsnNode) || !this.matchCall(methodInsnNode = (MethodInsnNode)insnNode) || !locationFilter.allow((AbstractInsnNode)methodInsnNode, locationType, this.whenComplete) || this.count > 0 && this.count != ++matchedCount) continue;
            Location.InvokeLocation invokeLocation = new Location.InvokeLocation(methodInsnNode, this.count, this.whenComplete);
            locations.add(invokeLocation);
        }
        return locations;
    }

    public List<Location> matchForException(MethodProcessor methodProcessor) {
        ArrayList<Location> locations = new ArrayList<Location>();
        MethodNode methodNode = methodProcessor.getMethodNode();
        ArrayList<MethodInsnNode> methodInsnNodes = new ArrayList<MethodInsnNode>();
        LocationFilter locationFilter = methodProcessor.getLocationFilter();
        LocationType locationType = LocationType.INVOKE_EXCEPTION_EXIT;
        int matchedCount = 0;
        for (AbstractInsnNode insnNode = methodProcessor.getEnterInsnNode(); insnNode != null; insnNode = insnNode.getNext()) {
            MethodInsnNode methodInsnNode;
            if (!(insnNode instanceof MethodInsnNode) || !this.matchCall(methodInsnNode = (MethodInsnNode)insnNode) || !locationFilter.allow((AbstractInsnNode)methodInsnNode, locationType, this.whenComplete) || this.count > 0 && this.count != ++matchedCount) continue;
            methodInsnNodes.add(methodInsnNode);
        }
        for (MethodInsnNode methodInsnNode : methodInsnNodes) {
            TryCatchBlock tryCatchBlock = new TryCatchBlock(methodNode);
            InsnList toInsert = new InsnList();
            LabelNode gotoDest = new LabelNode();
            LabelNode startLabelNode = tryCatchBlock.getStartLabelNode();
            LabelNode endLabelNode = tryCatchBlock.getEndLabelNode();
            toInsert.add((AbstractInsnNode)new JumpInsnNode(167, gotoDest));
            toInsert.add((AbstractInsnNode)endLabelNode);
            AsmOpUtils.throwException(toInsert);
            locations.add(new Location.InvokeExceptionExitLocation(methodInsnNode, (AbstractInsnNode)endLabelNode));
            toInsert.add((AbstractInsnNode)gotoDest);
            methodNode.instructions.insertBefore((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)startLabelNode);
            methodNode.instructions.insert((AbstractInsnNode)methodInsnNode, toInsert);
            tryCatchBlock.sort();
        }
        return locations;
    }

    private boolean matchCall(MethodInsnNode methodInsnNode) {
        if (this.methodName != null && !this.methodName.isEmpty() && !this.methodName.equals(methodInsnNode.name)) {
            return false;
        }
        if (!this.excludes.isEmpty()) {
            String ownerClassName = Type.getObjectType((String)methodInsnNode.owner).getClassName();
            for (String exclude : this.excludes) {
                if (!MatchUtils.wildcardMatch(ownerClassName, exclude)) continue;
                return false;
            }
        }
        if (this.owner != null && !this.owner.equals(methodInsnNode.owner)) {
            return false;
        }
        return this.desc == null || this.desc.equals(methodInsnNode.desc);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean isWhenComplete() {
        return this.whenComplete;
    }

    public void setWhenComplete(boolean whenComplete) {
        this.whenComplete = whenComplete;
    }
}

