/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.bytekit.asm.interceptor.annotation;

import com.alibaba.arthas.deps.org.objectweb.asm.Type;
import com.taobao.arthas.bytekit.asm.interceptor.InterceptorProcessor;
import com.taobao.arthas.bytekit.asm.interceptor.annotation.InterceptorParserHander;
import com.taobao.arthas.bytekit.asm.interceptor.annotation.InterceptorParserUtils;
import com.taobao.arthas.bytekit.asm.interceptor.annotation.None;
import com.taobao.arthas.bytekit.asm.interceptor.parser.InterceptorProcessorParser;
import com.taobao.arthas.bytekit.asm.location.InvokeLocationMatcher;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@InterceptorParserHander(parserHander=InvokeInterceptorProcessorParser.class)
public @interface AtInvoke {
    public boolean inline() default true;

    public Class<? extends Throwable> suppress() default None.class;

    public Class<?> suppressHandler() default Void.class;

    public Class<?> owner() default Void.class;

    public String name();

    public String desc() default "";

    public int count() default -1;

    public boolean whenComplete() default false;

    public String[] excludes() default {};

    public static class InvokeInterceptorProcessorParser
    implements InterceptorProcessorParser {
        @Override
        public InterceptorProcessor parse(Method method, Annotation annotationOnMethod) {
            AtInvoke atInvoke = (AtInvoke)annotationOnMethod;
            String owner = null;
            String desc = null;
            if (!atInvoke.owner().equals(Void.class)) {
                owner = Type.getType(atInvoke.owner()).getInternalName();
            }
            if (atInvoke.desc().isEmpty()) {
                desc = null;
            }
            ArrayList<String> excludes = new ArrayList<String>();
            for (String exclude : atInvoke.excludes()) {
                excludes.add(exclude);
            }
            InvokeLocationMatcher locationMatcher = new InvokeLocationMatcher(owner, atInvoke.name(), desc, atInvoke.count(), atInvoke.whenComplete(), excludes);
            return InterceptorParserUtils.createInterceptorProcessor(method, locationMatcher, atInvoke.inline(), atInvoke.suppress(), atInvoke.suppressHandler());
        }
    }
}

