/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import com.alibaba.android.arouter.launcher.ARouter;

public class PackageUtils {
    private static String NEW_VERSION_NAME;
    private static int NEW_VERSION_CODE;

    public static boolean isNewVersion(Context context) {
        PackageInfo packageInfo = PackageUtils.getPackageInfo(context);
        if (null != packageInfo) {
            String versionName = packageInfo.versionName;
            int versionCode = packageInfo.versionCode;
            SharedPreferences sp = context.getSharedPreferences("SP_AROUTER_CACHE", 0);
            if (!versionName.equals(sp.getString("LAST_VERSION_NAME", null)) || versionCode != sp.getInt("LAST_VERSION_CODE", -1)) {
                NEW_VERSION_NAME = versionName;
                NEW_VERSION_CODE = versionCode;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void updateVersion(Context context) {
        if (!TextUtils.isEmpty((CharSequence)NEW_VERSION_NAME) && NEW_VERSION_CODE != 0) {
            SharedPreferences sp = context.getSharedPreferences("SP_AROUTER_CACHE", 0);
            sp.edit().putString("LAST_VERSION_NAME", NEW_VERSION_NAME).putInt("LAST_VERSION_CODE", NEW_VERSION_CODE).apply();
        }
    }

    private static PackageInfo getPackageInfo(Context context) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 16384);
        }
        catch (Exception ex) {
            ARouter.logger.error("ARouter::", "Get package info error.");
        }
        return packageInfo;
    }
}

