/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassUtils {
    private static final String EXTRACTED_NAME_EXT = ".classes";
    private static final String EXTRACTED_SUFFIX = ".zip";
    private static final String SECONDARY_FOLDER_NAME = "code_cache" + File.separator + "secondary-dexes";
    private static final String PREFS_FILE = "multidex.version";
    private static final String KEY_DEX_NUMBER = "dex.number";
    private static final int VM_WITH_MULTIDEX_VERSION_MAJOR = 2;
    private static final int VM_WITH_MULTIDEX_VERSION_MINOR = 1;

    private static SharedPreferences getMultiDexPreferences(Context context) {
        return context.getSharedPreferences(PREFS_FILE, Build.VERSION.SDK_INT < 11 ? 0 : 4);
    }

    public static List<String> getFileNameByPackageName(Context context, String packageName) throws PackageManager.NameNotFoundException, IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        for (String path : ClassUtils.getSourcePaths(context)) {
            DexFile dexfile = path.endsWith(EXTRACTED_SUFFIX) ? DexFile.loadDex((String)path, (String)(path + ".tmp"), (int)0) : new DexFile(path);
            Enumeration dexEntries = dexfile.entries();
            while (dexEntries.hasMoreElements()) {
                String className = (String)dexEntries.nextElement();
                if (!className.contains(packageName)) continue;
                classNames.add(className);
            }
        }
        Log.d((String)"galaxy", (String)("Filter " + classNames.size() + " classes by packageName <" + packageName + ">"));
        return classNames;
    }

    public static List<String> getSourcePaths(Context context) throws PackageManager.NameNotFoundException, IOException {
        ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
        File sourceApk = new File(applicationInfo.sourceDir);
        ArrayList<String> sourcePaths = new ArrayList<String>();
        sourcePaths.add(applicationInfo.sourceDir);
        String extractedFilePrefix = sourceApk.getName() + EXTRACTED_NAME_EXT;
        if (!ClassUtils.isVMMultidexCapable()) {
            int totalDexNumber = ClassUtils.getMultiDexPreferences(context).getInt(KEY_DEX_NUMBER, 1);
            File dexDir = new File(applicationInfo.dataDir, SECONDARY_FOLDER_NAME);
            for (int secondaryNumber = 2; secondaryNumber <= totalDexNumber; ++secondaryNumber) {
                String fileName = extractedFilePrefix + secondaryNumber + EXTRACTED_SUFFIX;
                File extractedFile = new File(dexDir, fileName);
                if (!extractedFile.isFile()) {
                    throw new IOException("Missing extracted secondary dex file '" + extractedFile.getPath() + "'");
                }
                sourcePaths.add(extractedFile.getAbsolutePath());
            }
        }
        return sourcePaths;
    }

    private static boolean isVMMultidexCapable() {
        boolean isMultidexCapable = false;
        String vmName = null;
        try {
            if (ClassUtils.isYunOS()) {
                vmName = "'YunOS'";
                isMultidexCapable = Integer.valueOf(System.getProperty("ro.build.version.sdk")) >= 21;
            } else {
                Matcher matcher;
                vmName = "'Android'";
                String versionString = System.getProperty("java.vm.version");
                if (versionString != null && (matcher = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?").matcher(versionString)).matches()) {
                    try {
                        int major = Integer.parseInt(matcher.group(1));
                        int minor = Integer.parseInt(matcher.group(2));
                        isMultidexCapable = major > 2 || major == 2 && minor >= 1;
                    }
                    catch (NumberFormatException ignore) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.i((String)"galaxy", (String)("VM with name " + vmName + (isMultidexCapable ? " has multidex support" : " does not have multidex support")));
        return isMultidexCapable;
    }

    private static boolean isYunOS() {
        try {
            String version = System.getProperty("ro.yunos.version");
            String vmName = System.getProperty("java.vm.name");
            return vmName != null && vmName.toLowerCase().contains("lemur") || version != null && version.trim().length() > 0;
        }
        catch (Exception ignore) {
            return false;
        }
    }
}

