/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.layout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewPropertyAnimator;
import com.alibaba.android.vlayout.LayoutManagerHelper;
import com.alibaba.android.vlayout.OrientationHelperEx;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.FixAreaLayoutHelper;
import com.alibaba.android.vlayout.layout.LayoutChunkResult;

public class FixLayoutHelper
extends FixAreaLayoutHelper {
    private static final String TAG = "FixLayoutHelper";
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private int mPos = -1;
    private int mAlignType = 0;
    protected int mX = 0;
    protected int mY = 0;
    private boolean mSketchMeasure = false;
    protected View mFixView = null;
    protected boolean mDoNormalHandle = false;
    private boolean mShouldDrawn = true;
    private boolean isAddFixViewImmediately = false;
    private boolean isRemoveFixViewImmediately = true;
    private FixViewAppearAnimatorListener mFixViewAppearAnimatorListener = new FixViewAppearAnimatorListener();
    private FixViewDisappearAnimatorListener mFixViewDisappearAnimatorListener = new FixViewDisappearAnimatorListener();

    public FixLayoutHelper(int x, int y) {
        this(0, x, y);
    }

    public FixLayoutHelper(int alignType, int x, int y) {
        this.mAlignType = alignType;
        this.mX = x;
        this.mY = y;
        this.setItemCount(1);
    }

    @Override
    public void setItemCount(int itemCount) {
        if (itemCount > 0) {
            super.setItemCount(1);
        } else {
            super.setItemCount(0);
        }
    }

    @Override
    public void setMargin(int leftMargin, int topMargin, int rightMargin, int bottomMargin) {
    }

    public void setX(int x) {
        this.mX = x;
    }

    public void setY(int y) {
        this.mY = y;
    }

    public void setAlignType(int alignType) {
        this.mAlignType = alignType;
    }

    public void setSketchMeasure(boolean sketchMeasure) {
        this.mSketchMeasure = sketchMeasure;
    }

    @Override
    public void onRangeChange(int start, int end) {
        this.mPos = start;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutState, LayoutChunkResult result, LayoutManagerHelper helper) {
        if (this.isOutOfRange(layoutState.getCurrentPosition())) {
            return;
        }
        if (!this.mShouldDrawn) {
            layoutState.skipCurrentPosition();
            return;
        }
        View view = this.mFixView;
        if (view == null) {
            view = layoutState.next(recycler);
        } else {
            layoutState.skipCurrentPosition();
        }
        if (view == null) {
            result.mFinished = true;
            return;
        }
        this.mDoNormalHandle = state.isPreLayout();
        if (this.mDoNormalHandle) {
            helper.addChildView(layoutState, view);
        }
        this.mFixView = view;
        this.doMeasureAndLayout(view, helper);
        result.mConsumed = 0;
        result.mIgnoreConsumed = true;
        this.handleStateOnResult(result, view);
    }

    @Override
    public boolean requireLayoutView() {
        return false;
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper helper) {
        super.beforeLayout(recycler, state, helper);
        if (this.mFixView != null && helper.isViewHolderUpdated(this.mFixView)) {
            helper.removeChildView(this.mFixView);
            recycler.recycleView(this.mFixView);
            this.mFixView = null;
            this.isAddFixViewImmediately = true;
        }
        this.mDoNormalHandle = false;
    }

    @Override
    public void afterLayout(final RecyclerView.Recycler recycler, RecyclerView.State state, int startPosition, int endPosition, int scrolled, final LayoutManagerHelper helper) {
        super.afterLayout(recycler, state, startPosition, endPosition, scrolled, helper);
        if (this.mPos < 0) {
            return;
        }
        if (this.mDoNormalHandle && state.isPreLayout()) {
            if (this.mFixView != null) {
                helper.removeChildView(this.mFixView);
                recycler.recycleView(this.mFixView);
                this.isAddFixViewImmediately = false;
            }
            this.mFixView = null;
            return;
        }
        if (this.shouldBeDraw(helper, startPosition, endPosition, scrolled)) {
            this.mShouldDrawn = true;
            if (this.mFixView != null) {
                if (this.mFixView.getParent() == null) {
                    this.addFixViewWithAnimator(helper, this.mFixView);
                } else {
                    helper.addFixedView(this.mFixView);
                    this.isRemoveFixViewImmediately = false;
                }
            } else {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        FixLayoutHelper.this.mFixView = recycler.getViewForPosition(FixLayoutHelper.this.mPos);
                        FixLayoutHelper.this.doMeasureAndLayout(FixLayoutHelper.this.mFixView, helper);
                        if (FixLayoutHelper.this.isAddFixViewImmediately) {
                            helper.addFixedView(FixLayoutHelper.this.mFixView);
                            FixLayoutHelper.this.isRemoveFixViewImmediately = false;
                        } else {
                            FixLayoutHelper.this.addFixViewWithAnimator(helper, FixLayoutHelper.this.mFixView);
                        }
                    }
                };
                if (this.mFixViewDisappearAnimatorListener.isAnimating()) {
                    this.mFixViewDisappearAnimatorListener.withEndAction(action);
                } else {
                    action.run();
                }
            }
        } else {
            this.mShouldDrawn = false;
            if (this.mFixView != null) {
                this.removeFixViewWithAnimator(recycler, helper, this.mFixView);
                this.mFixView = null;
            }
        }
    }

    private void addFixViewWithAnimator(LayoutManagerHelper layoutManagerHelper, View fixView) {
        if (this.mFixViewAnimatorHelper != null) {
            ViewPropertyAnimator animator = this.mFixViewAnimatorHelper.onGetFixViewAppearAnimator(fixView);
            if (animator != null) {
                fixView.setVisibility(4);
                layoutManagerHelper.addFixedView(fixView);
                this.mFixViewAppearAnimatorListener.bindAction(layoutManagerHelper, fixView);
                animator.setListener((Animator.AnimatorListener)this.mFixViewAppearAnimatorListener).start();
            } else {
                layoutManagerHelper.addFixedView(fixView);
            }
        } else {
            layoutManagerHelper.addFixedView(fixView);
        }
        this.isRemoveFixViewImmediately = false;
    }

    private void removeFixViewWithAnimator(RecyclerView.Recycler recycler, LayoutManagerHelper layoutManagerHelper, View fixView) {
        if (!this.isRemoveFixViewImmediately && this.mFixViewAnimatorHelper != null) {
            ViewPropertyAnimator animator = this.mFixViewAnimatorHelper.onGetFixViewDisappearAnimator(fixView);
            if (animator != null) {
                this.mFixViewDisappearAnimatorListener.bindAction(recycler, layoutManagerHelper, fixView);
                animator.setListener((Animator.AnimatorListener)this.mFixViewDisappearAnimatorListener).start();
                this.isAddFixViewImmediately = false;
            } else {
                layoutManagerHelper.removeChildView(fixView);
                recycler.recycleView(fixView);
                this.isAddFixViewImmediately = false;
            }
        } else {
            layoutManagerHelper.removeChildView(fixView);
            recycler.recycleView(fixView);
            this.isAddFixViewImmediately = false;
        }
    }

    protected boolean shouldBeDraw(LayoutManagerHelper helper, int startPosition, int endPosition, int scrolled) {
        return true;
    }

    @Override
    public View getFixedView() {
        return this.mFixView;
    }

    @Override
    public void onClear(LayoutManagerHelper helper) {
        super.onClear(helper);
        if (this.mFixView != null) {
            helper.removeChildView(this.mFixView);
            helper.recycleView(this.mFixView);
            this.mFixView.animate().cancel();
            this.mFixView = null;
            this.isAddFixViewImmediately = false;
        }
    }

    private void doMeasureAndLayout(View view, LayoutManagerHelper helper) {
        int bottom;
        int left;
        int right;
        int top;
        boolean layoutInVertical;
        if (view == null || helper == null) {
            return;
        }
        VirtualLayoutManager.LayoutParams params = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
        OrientationHelperEx orientationHelper = helper.getMainOrientationHelper();
        boolean bl = layoutInVertical = helper.getOrientation() == 1;
        if (layoutInVertical) {
            int widthSpec = helper.getChildMeasureSpec(helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight(), params.width >= 0 ? params.width : (this.mSketchMeasure && layoutInVertical ? -1 : -2), false);
            int heightSpec = !Float.isNaN(params.mAspectRatio) && params.mAspectRatio > 0.0f ? helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), (int)((float)View.MeasureSpec.getSize((int)widthSpec) / params.mAspectRatio + 0.5f), false) : (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f ? helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), (int)((float)View.MeasureSpec.getSize((int)widthSpec) / this.mAspectRatio + 0.5f), false) : helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), params.height >= 0 ? params.height : (this.mSketchMeasure && !layoutInVertical ? -1 : -2), false));
            helper.measureChildWithMargins(view, widthSpec, heightSpec);
        } else {
            int heightSpec = helper.getChildMeasureSpec(helper.getContentHeight() - helper.getPaddingTop() - helper.getPaddingBottom(), params.height >= 0 ? params.height : (this.mSketchMeasure && !layoutInVertical ? -1 : -2), false);
            int widthSpec = !Float.isNaN(params.mAspectRatio) && params.mAspectRatio > 0.0f ? helper.getChildMeasureSpec(helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight(), (int)((float)View.MeasureSpec.getSize((int)heightSpec) * params.mAspectRatio + 0.5f), false) : (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f ? helper.getChildMeasureSpec(helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight(), (int)((float)View.MeasureSpec.getSize((int)heightSpec) * this.mAspectRatio + 0.5f), false) : helper.getChildMeasureSpec(helper.getContentWidth() - helper.getPaddingLeft() - helper.getPaddingRight(), params.width >= 0 ? params.width : (this.mSketchMeasure && layoutInVertical ? -1 : -2), false));
            helper.measureChildWithMargins(view, widthSpec, heightSpec);
        }
        if (this.mAlignType == 1) {
            top = helper.getPaddingTop() + this.mY + this.mAdjuster.top;
            right = helper.getContentWidth() - helper.getPaddingRight() - this.mX - this.mAdjuster.right;
            left = right - params.leftMargin - params.rightMargin - view.getMeasuredWidth();
            bottom = top + params.topMargin + params.bottomMargin + view.getMeasuredHeight();
        } else if (this.mAlignType == 2) {
            left = helper.getPaddingLeft() + this.mX + this.mAdjuster.left;
            bottom = helper.getContentHeight() - helper.getPaddingBottom() - this.mY - this.mAdjuster.bottom;
            right = left + params.leftMargin + params.rightMargin + view.getMeasuredWidth();
            top = bottom - view.getMeasuredHeight() - params.topMargin - params.bottomMargin;
        } else if (this.mAlignType == 3) {
            right = helper.getContentWidth() - helper.getPaddingRight() - this.mX - this.mAdjuster.right;
            bottom = helper.getContentHeight() - helper.getPaddingBottom() - this.mY - this.mAdjuster.bottom;
            left = right - params.leftMargin - params.rightMargin - view.getMeasuredWidth();
            top = bottom - view.getMeasuredHeight() - params.topMargin - params.bottomMargin;
        } else {
            left = helper.getPaddingLeft() + this.mX + this.mAdjuster.left;
            top = helper.getPaddingTop() + this.mY + this.mAdjuster.top;
            right = left + (layoutInVertical ? orientationHelper.getDecoratedMeasurementInOther(view) : orientationHelper.getDecoratedMeasurement(view));
            bottom = top + (layoutInVertical ? orientationHelper.getDecoratedMeasurement(view) : orientationHelper.getDecoratedMeasurementInOther(view));
        }
        this.layoutChildWithMargin(view, left, top, right, bottom, helper);
    }

    private static class FixViewDisappearAnimatorListener
    extends AnimatorListenerAdapter {
        private boolean isAnimating;
        private RecyclerView.Recycler mRecycler;
        private LayoutManagerHelper mLayoutManagerHelper;
        private View mFixView;
        private Runnable mEndAction;

        private FixViewDisappearAnimatorListener() {
        }

        public void bindAction(RecyclerView.Recycler recycler, LayoutManagerHelper layoutManagerHelper, View fixView) {
            this.isAnimating = true;
            this.mRecycler = recycler;
            this.mLayoutManagerHelper = layoutManagerHelper;
            this.mFixView = fixView;
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            this.mLayoutManagerHelper.removeChildView(this.mFixView);
            this.mRecycler.recycleView(this.mFixView);
            this.isAnimating = false;
            if (this.mEndAction != null) {
                this.mEndAction.run();
                this.mEndAction = null;
            }
        }

        public boolean isAnimating() {
            return this.isAnimating;
        }

        public void withEndAction(Runnable action) {
            this.mEndAction = action;
        }
    }

    private static class FixViewAppearAnimatorListener
    extends AnimatorListenerAdapter {
        private LayoutManagerHelper mLayoutManagerHelper;
        private View mFixView;

        private FixViewAppearAnimatorListener() {
        }

        public void bindAction(LayoutManagerHelper layoutManagerHelper, View fixView) {
            this.mLayoutManagerHelper = layoutManagerHelper;
            this.mFixView = fixView;
        }

        public void onAnimationStart(Animator animation) {
            this.mFixView.setVisibility(0);
        }

        public void onAnimationEnd(Animator animation) {
        }
    }
}

