/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout.extend;

import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import java.io.Closeable;

public final class InnerRecycledViewPool
extends RecyclerView.RecycledViewPool {
    private static final String TAG = "InnerRecycledViewPool";
    private static int DEFAULT_MAX_SIZE = 20;
    private RecyclerView.RecycledViewPool mInnerPool;
    private SparseIntArray mScrapLength = new SparseIntArray();
    private SparseIntArray mMaxScrap = new SparseIntArray();

    public InnerRecycledViewPool(RecyclerView.RecycledViewPool pool) {
        this.mInnerPool = pool;
    }

    public InnerRecycledViewPool() {
        this(new RecyclerView.RecycledViewPool());
    }

    public void clear() {
        int size = this.mScrapLength.size();
        for (int i = 0; i < size; ++i) {
            int viewType = this.mScrapLength.keyAt(i);
            RecyclerView.ViewHolder holder = this.mInnerPool.getRecycledView(viewType);
            while (holder != null) {
                this.destroyViewHolder(holder);
                holder = this.mInnerPool.getRecycledView(viewType);
            }
        }
        this.mScrapLength.clear();
        super.clear();
    }

    public void setMaxRecycledViews(int viewType, int max) {
        RecyclerView.ViewHolder holder = this.mInnerPool.getRecycledView(viewType);
        while (holder != null) {
            this.destroyViewHolder(holder);
            holder = this.mInnerPool.getRecycledView(viewType);
        }
        this.mMaxScrap.put(viewType, max);
        this.mScrapLength.put(viewType, 0);
        this.mInnerPool.setMaxRecycledViews(viewType, max);
    }

    public RecyclerView.ViewHolder getRecycledView(int viewType) {
        RecyclerView.ViewHolder holder = this.mInnerPool.getRecycledView(viewType);
        if (holder != null) {
            int scrapHeapSize;
            int n = scrapHeapSize = this.mScrapLength.indexOfKey(viewType) >= 0 ? this.mScrapLength.get(viewType) : 0;
            if (scrapHeapSize > 0) {
                this.mScrapLength.put(viewType, scrapHeapSize - 1);
            }
        }
        return holder;
    }

    public int size() {
        int count = 0;
        int size = this.mScrapLength.size();
        for (int i = 0; i < size; ++i) {
            int val = this.mScrapLength.valueAt(i);
            count += val;
        }
        return count;
    }

    public void putRecycledView(RecyclerView.ViewHolder scrap) {
        int scrapHeapSize;
        int viewType = scrap.getItemViewType();
        if (this.mMaxScrap.indexOfKey(viewType) < 0) {
            this.mMaxScrap.put(viewType, DEFAULT_MAX_SIZE);
            this.setMaxRecycledViews(viewType, DEFAULT_MAX_SIZE);
        }
        int n = scrapHeapSize = this.mScrapLength.indexOfKey(viewType) >= 0 ? this.mScrapLength.get(viewType) : 0;
        if (this.mMaxScrap.get(viewType) > scrapHeapSize) {
            this.mInnerPool.putRecycledView(scrap);
            this.mScrapLength.put(viewType, scrapHeapSize + 1);
        } else {
            this.destroyViewHolder(scrap);
        }
    }

    private void destroyViewHolder(RecyclerView.ViewHolder holder) {
        View view = holder.itemView;
        if (view instanceof Closeable) {
            try {
                ((Closeable)view).close();
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)Log.getStackTraceString((Throwable)e), (Throwable)e);
            }
        }
        if (holder instanceof Closeable) {
            try {
                ((Closeable)holder).close();
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)Log.getStackTraceString((Throwable)e), (Throwable)e);
            }
        }
    }

    public void setDefaultMaxSize(int maxSize) {
        DEFAULT_MAX_SIZE = maxSize;
    }
}

