/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout;

import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.android.vlayout.extend.InnerRecycledViewPool;

public abstract class RecyclablePagerAdapter<VH extends RecyclerView.ViewHolder>
extends PagerAdapter {
    private RecyclerView.Adapter<VH> mAdapter;
    private InnerRecycledViewPool mRecycledViewPool;

    public RecyclablePagerAdapter(RecyclerView.Adapter<VH> adapter, RecyclerView.RecycledViewPool pool) {
        this.mAdapter = adapter;
        this.mRecycledViewPool = pool instanceof InnerRecycledViewPool ? (InnerRecycledViewPool)pool : new InnerRecycledViewPool(pool);
    }

    public abstract int getCount();

    public boolean isViewFromObject(View view, Object o) {
        return o instanceof RecyclerView.ViewHolder && ((RecyclerView.ViewHolder)o).itemView == view;
    }

    public Object instantiateItem(ViewGroup container, int position) {
        int itemViewType = this.getItemViewType(position);
        RecyclerView.ViewHolder holder = this.mRecycledViewPool.getRecycledView(itemViewType);
        if (holder == null) {
            holder = this.mAdapter.createViewHolder(container, itemViewType);
        }
        this.onBindViewHolder(holder, position);
        container.addView(holder.itemView, (ViewGroup.LayoutParams)new ViewPager.LayoutParams());
        return holder;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        if (object instanceof RecyclerView.ViewHolder) {
            RecyclerView.ViewHolder holder = (RecyclerView.ViewHolder)object;
            container.removeView(holder.itemView);
            this.mRecycledViewPool.putRecycledView(holder);
        }
    }

    public abstract void onBindViewHolder(VH var1, int var2);

    public abstract int getItemViewType(int var1);
}

