/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.vlayout;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.android.vlayout.Cantor;
import com.alibaba.android.vlayout.LayoutHelper;
import com.alibaba.android.vlayout.VirtualLayoutAdapter;
import com.alibaba.android.vlayout.VirtualLayoutManager;
import com.alibaba.android.vlayout.layout.SingleLayoutHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DelegateAdapter
extends VirtualLayoutAdapter<RecyclerView.ViewHolder> {
    @Nullable
    private AtomicInteger mIndexGen;
    private int mIndex = 0;
    private final boolean mHasConsistItemType;
    private SparseArray<Adapter> mItemTypeAry = new SparseArray();
    @NonNull
    private final List<Pair<AdapterDataObserver, Adapter>> mAdapters = new ArrayList<Pair<AdapterDataObserver, Adapter>>();
    private int mTotal = 0;
    private final SparseArray<Pair<AdapterDataObserver, Adapter>> mIndexAry = new SparseArray();
    private long[] cantorReverse = new long[2];

    public DelegateAdapter(VirtualLayoutManager layoutManager) {
        this(layoutManager, false, false);
    }

    public DelegateAdapter(VirtualLayoutManager layoutManager, boolean hasConsistItemType) {
        this(layoutManager, hasConsistItemType, false);
    }

    DelegateAdapter(VirtualLayoutManager layoutManager, boolean hasConsistItemType, boolean threadSafe) {
        super(layoutManager);
        if (threadSafe) {
            this.mIndexGen = new AtomicInteger(0);
        }
        this.mHasConsistItemType = hasConsistItemType;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (this.mHasConsistItemType) {
            Adapter adapter = (Adapter)((Object)this.mItemTypeAry.get(viewType));
            if (adapter != null) {
                return adapter.onCreateViewHolder(parent, viewType);
            }
            return null;
        }
        Cantor.reverseCantor(viewType, this.cantorReverse);
        int index = (int)this.cantorReverse[1];
        int subItemType = (int)this.cantorReverse[0];
        Adapter adapter = this.findAdapterByIndex(index);
        if (adapter == null) {
            return null;
        }
        return adapter.onCreateViewHolder(parent, subItemType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        Pair<AdapterDataObserver, Adapter> pair = this.findAdapterByPosition(position);
        if (pair == null) {
            return;
        }
        ((Adapter)((Object)pair.second)).onBindViewHolder(holder, position - ((AdapterDataObserver)((Object)pair.first)).mStartPosition);
        ((Adapter)((Object)pair.second)).onBindViewHolderWithOffset(holder, position - ((AdapterDataObserver)((Object)pair.first)).mStartPosition, position);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        Pair<AdapterDataObserver, Adapter> pair = this.findAdapterByPosition(position);
        if (pair == null) {
            return;
        }
        ((Adapter)((Object)pair.second)).onBindViewHolder(holder, position - ((AdapterDataObserver)((Object)pair.first)).mStartPosition, payloads);
        ((Adapter)((Object)pair.second)).onBindViewHolderWithOffset(holder, position - ((AdapterDataObserver)((Object)pair.first)).mStartPosition, position, payloads);
    }

    public int getItemCount() {
        return this.mTotal;
    }

    public int getItemViewType(int position) {
        Pair<AdapterDataObserver, Adapter> p = this.findAdapterByPosition(position);
        if (p == null) {
            return -1;
        }
        int subItemType = ((Adapter)((Object)p.second)).getItemViewType(position - ((AdapterDataObserver)((Object)p.first)).mStartPosition);
        if (subItemType < 0) {
            return subItemType;
        }
        if (this.mHasConsistItemType) {
            this.mItemTypeAry.put(subItemType, p.second);
            return subItemType;
        }
        int index = ((AdapterDataObserver)((Object)p.first)).mIndex;
        return (int)Cantor.getCantor(subItemType, index);
    }

    public long getItemId(int position) {
        Pair<AdapterDataObserver, Adapter> p = this.findAdapterByPosition(position);
        if (p == null) {
            return -1L;
        }
        long itemId = ((Adapter)((Object)p.second)).getItemId(position - ((AdapterDataObserver)((Object)p.first)).mStartPosition);
        if (itemId < 0L) {
            return -1L;
        }
        int index = ((AdapterDataObserver)((Object)p.first)).mIndex;
        return Cantor.getCantor(index, itemId);
    }

    public void setHasStableIds(boolean hasStableIds) {
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        Pair<AdapterDataObserver, Adapter> pair;
        super.onViewRecycled(holder);
        int position = holder.getPosition();
        if (position >= 0 && (pair = this.findAdapterByPosition(position)) != null) {
            ((Adapter)((Object)pair.second)).onViewRecycled(holder);
        }
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        Pair<AdapterDataObserver, Adapter> pair;
        super.onViewAttachedToWindow(holder);
        int position = holder.getPosition();
        if (position >= 0 && (pair = this.findAdapterByPosition(position)) != null) {
            ((Adapter)((Object)pair.second)).onViewAttachedToWindow(holder);
        }
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        Pair<AdapterDataObserver, Adapter> pair;
        super.onViewDetachedFromWindow(holder);
        int position = holder.getPosition();
        if (position >= 0 && (pair = this.findAdapterByPosition(position)) != null) {
            ((Adapter)((Object)pair.second)).onViewDetachedFromWindow(holder);
        }
    }

    @Override
    @Deprecated
    public void setLayoutHelpers(List<LayoutHelper> helpers) {
        throw new UnsupportedOperationException("DelegateAdapter doesn't support setLayoutHelpers directly");
    }

    public void setAdapters(@Nullable List<Adapter> adapters) {
        this.clear();
        if (adapters == null) {
            adapters = Collections.emptyList();
        }
        LinkedList<LayoutHelper> helpers = new LinkedList<LayoutHelper>();
        boolean hasStableIds = true;
        this.mTotal = 0;
        for (Adapter<Object> adapter : adapters) {
            int n;
            if (this.mIndexGen == null) {
                int n2 = this.mIndex;
                n = n2;
                this.mIndex = n2 + 1;
            } else {
                n = this.mIndexGen.incrementAndGet();
            }
            AdapterDataObserver observer = new AdapterDataObserver(this.mTotal, n);
            adapter.registerAdapterDataObserver(observer);
            hasStableIds = hasStableIds && adapter.hasStableIds();
            LayoutHelper helper = adapter.onCreateLayoutHelper();
            helper.setItemCount(adapter.getItemCount());
            this.mTotal += helper.getItemCount();
            helpers.add(helper);
            Pair pair = Pair.create((Object)((Object)observer), adapter);
            this.mIndexAry.put(observer.mIndex, (Object)pair);
            this.mAdapters.add((Pair<AdapterDataObserver, Adapter>)pair);
        }
        if (!this.hasObservers()) {
            super.setHasStableIds(hasStableIds);
        }
        super.setLayoutHelpers(helpers);
    }

    public void addAdapters(int position, @Nullable List<Adapter> adapters) {
        if (adapters == null || adapters.size() == 0) {
            return;
        }
        if (position < 0) {
            position = 0;
        }
        if (position > this.mAdapters.size()) {
            position = this.mAdapters.size();
        }
        ArrayList<Adapter> newAdapter = new ArrayList<Adapter>();
        for (Pair<AdapterDataObserver, Adapter> pair : this.mAdapters) {
            Adapter theOrigin = (Adapter)((Object)pair.second);
            newAdapter.add(theOrigin);
        }
        for (Adapter adapter : adapters) {
            newAdapter.add(position, adapter);
            ++position;
        }
        this.setAdapters(newAdapter);
    }

    public void addAdapters(@Nullable List<Adapter> adapters) {
        this.addAdapters(this.mAdapters.size(), adapters);
    }

    public void addAdapter(int position, @Nullable Adapter adapter) {
        this.addAdapters(position, Collections.singletonList(adapter));
    }

    public void addAdapter(@Nullable Adapter adapter) {
        this.addAdapters(Collections.singletonList(adapter));
    }

    public void removeFirstAdapter() {
        if (this.mAdapters != null && !this.mAdapters.isEmpty()) {
            Adapter targetAdatper = (Adapter)((Object)this.mAdapters.get((int)0).second);
            this.removeAdapter(targetAdatper);
        }
    }

    public void removeLastAdapter() {
        if (this.mAdapters != null && !this.mAdapters.isEmpty()) {
            Adapter targetAdatper = (Adapter)((Object)this.mAdapters.get((int)(this.mAdapters.size() - 1)).second);
            this.removeAdapter(targetAdatper);
        }
    }

    public void removeAdapter(int adapterIndex) {
        if (adapterIndex >= 0 && adapterIndex < this.mAdapters.size()) {
            Adapter targetAdatper = (Adapter)((Object)this.mAdapters.get((int)adapterIndex).second);
            this.removeAdapter(targetAdatper);
        }
    }

    public void removeAdapter(@Nullable Adapter targetAdapter) {
        if (targetAdapter == null) {
            return;
        }
        this.removeAdapters(Collections.singletonList(targetAdapter));
    }

    public void removeAdapters(@Nullable List<Adapter> targetAdapters) {
        if (targetAdapters == null || targetAdapters.isEmpty()) {
            return;
        }
        LinkedList<LayoutHelper> helpers = new LinkedList<LayoutHelper>(super.getLayoutHelpers());
        int size = targetAdapters.size();
        block0: for (int i = 0; i < size; ++i) {
            Adapter one = targetAdapters.get(i);
            Iterator<Pair<AdapterDataObserver, Adapter>> itr = this.mAdapters.iterator();
            while (itr.hasNext()) {
                Pair<AdapterDataObserver, Adapter> pair = itr.next();
                Adapter theOther = (Adapter)((Object)pair.second);
                if (!((Object)((Object)theOther)).equals((Object)one)) continue;
                theOther.unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)pair.first);
                int position = this.findAdapterPositionByIndex(((AdapterDataObserver)((Object)pair.first)).mIndex);
                if (position >= 0 && position < helpers.size()) {
                    helpers.remove(position);
                }
                itr.remove();
                continue block0;
            }
        }
        ArrayList<Adapter> newAdapter = new ArrayList<Adapter>();
        Iterator<Pair<AdapterDataObserver, Adapter>> itr = this.mAdapters.iterator();
        while (itr.hasNext()) {
            newAdapter.add((Adapter)((Object)itr.next().second));
        }
        this.setAdapters(newAdapter);
    }

    public void clear() {
        this.mTotal = 0;
        this.mIndex = 0;
        if (this.mIndexGen != null) {
            this.mIndexGen.set(0);
        }
        this.mLayoutManager.setLayoutHelpers(null);
        for (Pair<AdapterDataObserver, Adapter> p : this.mAdapters) {
            ((Adapter)((Object)p.second)).unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)p.first);
        }
        this.mItemTypeAry.clear();
        this.mAdapters.clear();
        this.mIndexAry.clear();
    }

    public int getAdaptersCount() {
        return this.mAdapters == null ? 0 : this.mAdapters.size();
    }

    public int findOffsetPosition(int absoultePosition) {
        Pair<AdapterDataObserver, Adapter> p = this.findAdapterByPosition(absoultePosition);
        if (p == null) {
            return -1;
        }
        int subAdapterPosition = absoultePosition - ((AdapterDataObserver)((Object)p.first)).mStartPosition;
        return subAdapterPosition;
    }

    @Nullable
    public Pair<AdapterDataObserver, Adapter> findAdapterByPosition(int position) {
        int count = this.mAdapters.size();
        if (count == 0) {
            return null;
        }
        int s = 0;
        int e = count - 1;
        Pair<AdapterDataObserver, Adapter> rs = null;
        while (s <= e) {
            int m = (s + e) / 2;
            rs = this.mAdapters.get(m);
            int endPosition = ((AdapterDataObserver)((Object)rs.first)).mStartPosition + ((Adapter)((Object)rs.second)).getItemCount() - 1;
            if (((AdapterDataObserver)((Object)rs.first)).mStartPosition > position) {
                e = m - 1;
            } else if (endPosition < position) {
                s = m + 1;
            } else if (((AdapterDataObserver)((Object)rs.first)).mStartPosition <= position && endPosition >= position) break;
            rs = null;
        }
        return rs;
    }

    public int findAdapterPositionByIndex(int index) {
        Pair rs = (Pair)this.mIndexAry.get(index);
        return rs == null ? -1 : this.mAdapters.indexOf(rs);
    }

    public Adapter findAdapterByIndex(int index) {
        Pair rs = (Pair)this.mIndexAry.get(index);
        return (Adapter)((Object)rs.second);
    }

    public static Adapter<? extends RecyclerView.ViewHolder> simpleAdapter(@NonNull View view) {
        return new SimpleViewAdapter(view);
    }

    public static Adapter<? extends RecyclerView.ViewHolder> simpleAdapter(@NonNull View view, @NonNull LayoutHelper layoutHelper) {
        return new SimpleViewAdapter(view, layoutHelper);
    }

    public static abstract class Adapter<VH extends RecyclerView.ViewHolder>
    extends RecyclerView.Adapter<VH> {
        public abstract LayoutHelper onCreateLayoutHelper();

        protected void onBindViewHolderWithOffset(VH holder, int position, int offsetTotal) {
        }

        protected void onBindViewHolderWithOffset(VH holder, int position, int offsetTotal, List<Object> payloads) {
            this.onBindViewHolderWithOffset(holder, position, offsetTotal);
        }
    }

    static class SimpleViewAdapter
    extends Adapter<RecyclerView.ViewHolder> {
        private View mView;
        private LayoutHelper mLayoutHelper;

        public SimpleViewAdapter(@NonNull View view, @NonNull LayoutHelper layoutHelper) {
            this.mView = view;
            this.mLayoutHelper = layoutHelper;
        }

        public SimpleViewAdapter(@NonNull View view) {
            this(view, new SingleLayoutHelper());
        }

        @Override
        public LayoutHelper onCreateLayoutHelper() {
            return this.mLayoutHelper;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new SimpleViewHolder(this.mView);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        }

        public int getItemCount() {
            return 1;
        }
    }

    static class SimpleViewHolder
    extends RecyclerView.ViewHolder {
        public SimpleViewHolder(View view) {
            super(view);
        }
    }

    protected class AdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        int mStartPosition;
        int mIndex = -1;

        public AdapterDataObserver(int startPosition, int index) {
            this.mStartPosition = startPosition;
            this.mIndex = index;
        }

        public void updateStartPositionAndIndex(int startPosition, int index) {
            this.mStartPosition = startPosition;
            this.mIndex = index;
        }

        public int getStartPosition() {
            return this.mStartPosition;
        }

        public int getIndex() {
            return this.mIndex;
        }

        private boolean updateLayoutHelper() {
            if (this.mIndex < 0) {
                return false;
            }
            int idx = DelegateAdapter.this.findAdapterPositionByIndex(this.mIndex);
            if (idx < 0) {
                return false;
            }
            Pair p = (Pair)DelegateAdapter.this.mAdapters.get(idx);
            LinkedList<LayoutHelper> helpers = new LinkedList<LayoutHelper>(DelegateAdapter.this.getLayoutHelpers());
            LayoutHelper helper = (LayoutHelper)helpers.get(idx);
            if (helper.getItemCount() != ((Adapter)((Object)p.second)).getItemCount()) {
                helper.setItemCount(((Adapter)((Object)p.second)).getItemCount());
                DelegateAdapter.this.mTotal = this.mStartPosition + ((Adapter)((Object)p.second)).getItemCount();
                for (int i = idx + 1; i < DelegateAdapter.this.mAdapters.size(); ++i) {
                    Pair pair = (Pair)DelegateAdapter.this.mAdapters.get(i);
                    ((AdapterDataObserver)((Object)pair.first)).mStartPosition = DelegateAdapter.this.mTotal;
                    DelegateAdapter.this.mTotal = DelegateAdapter.this.mTotal + ((Adapter)((Object)pair.second)).getItemCount();
                }
                DelegateAdapter.super.setLayoutHelpers(helpers);
            }
            return true;
        }

        public void onChanged() {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyItemRangeRemoved(this.mStartPosition + positionStart, itemCount);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyItemRangeInserted(this.mStartPosition + positionStart, itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyItemMoved(this.mStartPosition + fromPosition, this.mStartPosition + toPosition);
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyItemRangeChanged(this.mStartPosition + positionStart, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyItemRangeChanged(this.mStartPosition + positionStart, itemCount, payload);
        }
    }
}

