/*
 * Decompiled with CFR 0.152.
 */
package com.preference.ui.debug;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;
import com.preference.R;
import com.preference.model.PreferenceItem;
import com.preference.model.PreferenceType;
import com.thoughtbot.expandablerecyclerview.MultiTypeExpandableRecyclerViewAdapter;
import com.thoughtbot.expandablerecyclerview.models.ExpandableGroup;
import com.thoughtbot.expandablerecyclerview.viewholders.ChildViewHolder;
import com.thoughtbot.expandablerecyclerview.viewholders.GroupViewHolder;
import java.util.List;

public class DebugAdapter
extends MultiTypeExpandableRecyclerViewAdapter<TitleViewHolder, ChildViewHolder>
implements View.OnClickListener {
    private final PrefsListener listener;
    private static final int DEFAULT_VIEW_TYPE = 3;
    private static final int BOOLEAN_VIEW_TYPE = 4;
    private final boolean editable;

    public DebugAdapter(List<? extends ExpandableGroup> groups, PrefsListener listener, boolean editable) {
        super(groups);
        this.listener = listener;
        this.editable = editable;
    }

    public TitleViewHolder onCreateGroupViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.row_preference_title, parent, false);
        return new TitleViewHolder(view);
    }

    public ChildViewHolder onCreateChildViewHolder(ViewGroup parent, int viewType) {
        ChildViewHolder viewHolder = null;
        switch (viewType) {
            case 3: {
                View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.row_preference_default, parent, false);
                viewHolder = new StringChildViewHolder(view);
                break;
            }
            case 4: {
                View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.row_preference_boolean, parent, false);
                viewHolder = new BooleanChildViewHolder(view);
            }
        }
        return viewHolder;
    }

    public void onBindGroupViewHolder(TitleViewHolder holder, int flatPosition, ExpandableGroup group) {
        holder.setPrefsTitle(group);
    }

    public void onBindChildViewHolder(ChildViewHolder holder, int flatPosition, ExpandableGroup group, int childIndex) {
        PreferenceItem item = (PreferenceItem)group.getItems().get(childIndex);
        if (item.type == PreferenceType.Boolean) {
            BooleanChildViewHolder booleanHolder = (BooleanChildViewHolder)holder;
            booleanHolder.keyText.setText((CharSequence)item.key);
            booleanHolder.checkBox.setChecked(((Boolean)item.value).booleanValue());
            if (this.editable) {
                booleanHolder.checkBox.setClickable(true);
                booleanHolder.checkBox.setTag((Object)item);
                booleanHolder.checkBox.setOnClickListener((View.OnClickListener)this);
            } else {
                booleanHolder.checkBox.setClickable(false);
            }
        } else {
            StringChildViewHolder stringHolder = (StringChildViewHolder)holder;
            stringHolder.keyText.setText((CharSequence)item.key);
            stringHolder.valueText.setText((CharSequence)(item.value + ""));
            if (this.editable) {
                stringHolder.valueText.setTextColor(-1);
                holder.itemView.setTag((Object)item);
                holder.itemView.setOnClickListener((View.OnClickListener)this);
            }
        }
    }

    public int getChildViewType(int position, ExpandableGroup group, int childIndex) {
        PreferenceItem item = (PreferenceItem)group.getItems().get(childIndex);
        return item.type == PreferenceType.Boolean ? 4 : 3;
    }

    public boolean isChild(int viewType) {
        return viewType == 3 || viewType == 4;
    }

    public void onClick(View v) {
        PreferenceItem item = (PreferenceItem)v.getTag();
        switch (item.type) {
            case Boolean: {
                CheckBox view = (CheckBox)v;
                if (this.listener == null) break;
                this.listener.onBooleanPreferenceClicked(item, view.isChecked());
                break;
            }
            default: {
                if (this.listener == null) break;
                this.listener.onDefaultPreferenceClicked(item);
            }
        }
    }

    public void expandAll() {
        for (int i = this.getGroups().size() - 1; i >= 0; --i) {
            if (this.isGroupExpanded(i)) {
                return;
            }
            this.toggleGroup(i);
        }
        this.notifyDataSetChanged();
    }

    public void collapseAll() {
        for (ExpandableGroup group : this.getGroups()) {
            if (!this.isGroupExpanded(group)) continue;
            this.toggleGroup(group);
        }
    }

    public static class PreferenceGroup
    extends ExpandableGroup<PreferenceItem> {
        public PreferenceGroup(String title, List<PreferenceItem> items) {
            super(title, items);
        }
    }

    public static class BooleanChildViewHolder
    extends ChildViewHolder {
        TextView keyText;
        CheckBox checkBox;

        public BooleanChildViewHolder(View itemView) {
            super(itemView);
            this.keyText = (TextView)itemView.findViewById(R.id.key);
            this.checkBox = (CheckBox)itemView.findViewById(R.id.value);
        }
    }

    public static class StringChildViewHolder
    extends ChildViewHolder {
        TextView keyText;
        TextView valueText;

        public StringChildViewHolder(View itemView) {
            super(itemView);
            this.keyText = (TextView)itemView.findViewById(R.id.key);
            this.valueText = (TextView)itemView.findViewById(R.id.value);
        }
    }

    public static class TitleViewHolder
    extends GroupViewHolder {
        private TextView prefsTitle;

        public TitleViewHolder(View itemView) {
            super(itemView);
            this.prefsTitle = (TextView)itemView.findViewById(R.id.prefs_title);
        }

        public void expand() {
            super.expand();
        }

        public void setPrefsTitle(ExpandableGroup group) {
            this.prefsTitle.setText((CharSequence)group.getTitle());
        }
    }

    public static interface PrefsListener {
        public void onDefaultPreferenceClicked(PreferenceItem var1);

        public void onBooleanPreferenceClicked(PreferenceItem var1, boolean var2);
    }
}

