/*
 * Decompiled with CFR 0.152.
 */
package com.preference.ui.debug;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.RecyclerView;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Toast;
import com.preference.R;
import com.preference.model.PreferenceItem;
import com.preference.ui.debug.DebugAdapter;
import com.preference.ui.debug.DebugContract;
import com.preference.ui.debug.DebugPresenter;
import com.preference.ui.util.DialogUtils;
import java.util.List;

public class DebugActivity
extends AppCompatActivity
implements DebugContract.View,
DebugAdapter.PrefsListener,
DialogUtils.OnSaveClicked {
    private RecyclerView recyclerView;
    private DebugAdapter adapter;
    private DebugPresenter presenter;

    protected void onCreate(Bundle savedInstanceState) {
        this.setTheme(R.style.PreferenceTheme);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_preference);
        this.setTitle("Debug");
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerView);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.presenter = new DebugPresenter(this);
        this.presenter.getExtras(this.getIntent().getExtras());
        this.presenter.getData();
    }

    @Override
    public void updateView(List<DebugAdapter.PreferenceGroup> list, boolean editable) {
        this.adapter = new DebugAdapter(list, this, editable);
        this.adapter.expandAll();
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    @Override
    public void refreshView() {
        this.adapter.notifyDataSetChanged();
    }

    @Override
    public void showEditValueDialog(PreferenceItem item) {
        DialogUtils.showEditValueDialog((Context)this, item);
    }

    @Override
    public void onDefaultPreferenceClicked(PreferenceItem item) {
        this.presenter.onDefaultPreferenceClicked(item);
    }

    @Override
    public void onBooleanPreferenceClicked(PreferenceItem item, boolean isChecked) {
        this.presenter.onBooleanPreferenceClicked(item, isChecked);
    }

    @Override
    public void onSavePreferenceClicked(PreferenceItem item, String newValue) {
        try {
            this.presenter.onSavePreferenceClicked(item, newValue);
        }
        catch (NumberFormatException e) {
            Toast.makeText((Context)this, (CharSequence)"you have entered an incorrect value", (int)0).show();
        }
    }

    @Override
    public void onExpandClicked(MenuItem item) {
        item.setTitle((CharSequence)"collapse");
        this.adapter.expandAll();
    }

    @Override
    public void onCollapseClicked(MenuItem item) {
        item.setTitle((CharSequence)"expand");
        this.adapter.collapseAll();
    }

    @Override
    public void onBackButtonClicked() {
        this.finish();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.preference_menu, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.presenter.onBackButtonClicked();
        } else if (id2 == R.id.expand_collapse) {
            if (item.getTitle().toString().equalsIgnoreCase("expand")) {
                this.presenter.onExpandClicked(item);
            } else {
                this.presenter.onCollapseClicked(item);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public static void start(Context context, boolean editable) {
        Intent starter = new Intent(context, DebugActivity.class);
        starter.setFlags(0x10000000);
        starter.putExtra("editable", editable);
        context.startActivity(starter);
    }
}

