/*
 * Decompiled with CFR 0.152.
 */
package com.preference;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.preference.PreferenceCreator;
import com.preference.model.PreferenceFile;
import com.preference.model.PreferenceItem;
import com.preference.model.PreferenceType;
import com.preference.provider.PreferenceProvider;
import com.preference.ui.debug.DebugActivity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PreferenceManager {
    private static PreferenceManager singleton;
    private final Context context;
    private Map<String, Object> defaults;

    private PreferenceManager(Context context, Map<String, Object> defaults) {
        this.context = context;
        this.defaults = defaults;
    }

    static synchronized void init(Context context) {
        singleton = new PreferenceManager(context, new HashMap<String, Object>());
    }

    static synchronized PreferenceManager getInstance() {
        if (singleton == null) {
            if (PreferenceProvider.context == null) {
                throw new IllegalStateException("context == null");
            }
            singleton = new PreferenceManager(PreferenceProvider.context, new HashMap<String, Object>());
        }
        return singleton;
    }

    void showPreferenceScreen(boolean editable) {
        DebugActivity.start(this.context, editable);
    }

    PreferenceCreator getPreferenceByName(String name) {
        return new PreferenceCreator(name, this.context, this.defaults);
    }

    PreferenceCreator getDefaultPreference() {
        return new PreferenceCreator(this.context, this.defaults);
    }

    List<PreferenceFile> getData() {
        HashMap<SharedPreferences, String> nameHelper = new HashMap<SharedPreferences, String>();
        ArrayList<PreferenceFile> items = new ArrayList<PreferenceFile>();
        List<SharedPreferences> allFiles = this.getFiles(nameHelper);
        for (SharedPreferences sp : allFiles) {
            Map map = sp.getAll();
            if (map.size() <= 0) continue;
            ArrayList<PreferenceItem> prefsItems = new ArrayList<PreferenceItem>();
            for (Map.Entry obj : map.entrySet()) {
                PreferenceType type = this.getValueType(obj.getValue());
                prefsItems.add(new PreferenceItem((String)obj.getKey(), obj.getValue(), (String)nameHelper.get(sp), type));
            }
            items.add(new PreferenceFile(sp, (String)nameHelper.get(sp), prefsItems));
        }
        return items;
    }

    ArrayList<String> getFilesName() {
        ArrayList<String> filesName = new ArrayList<String>();
        String[] files = new File(PreferenceManager.getInstance().context.getApplicationInfo().dataDir + "/shared_prefs").list();
        if (files != null) {
            for (String fileName : files) {
                String fileNameWithoutExtension = fileName.substring(0, TextUtils.indexOf((CharSequence)fileName, (CharSequence)".xml"));
                filesName.add(fileNameWithoutExtension);
            }
        }
        return filesName;
    }

    private PreferenceType getValueType(Object value) {
        if (value instanceof Boolean) {
            return PreferenceType.Boolean;
        }
        if (value instanceof String) {
            return PreferenceType.String;
        }
        if (value instanceof Integer) {
            return PreferenceType.Integer;
        }
        if (value instanceof Float) {
            return PreferenceType.Float;
        }
        if (value instanceof Long) {
            return PreferenceType.Long;
        }
        return PreferenceType.String;
    }

    private List<SharedPreferences> getFiles(Map<SharedPreferences, String> prefsNameHelper) {
        ArrayList<SharedPreferences> preferencesList = new ArrayList<SharedPreferences>();
        for (String fileName : this.getFilesName()) {
            SharedPreferences sp = this.context.getSharedPreferences(fileName, 0);
            prefsNameHelper.put(sp, fileName);
            preferencesList.add(sp);
        }
        return preferencesList;
    }
}

