/*
 * Decompiled with CFR 0.152.
 */
package com.preference;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.XmlResourceParser;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.XmlRes;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.preference.MapStructure;
import com.preference.Preference;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

class PreferenceCreator
implements Preference {
    private static String TAG = "PowerPreference";
    private String name;
    private Context context;
    private SharedPreferences sharedPreferences;
    private Map<String, Object> defaults;

    public PreferenceCreator(Context context, Map<String, Object> defaults) {
        this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.context = context;
        this.defaults = defaults;
        this.name = "default";
    }

    public PreferenceCreator(String name, Context context, Map<String, Object> defaults) {
        this.sharedPreferences = context.getSharedPreferences(name, 0);
        this.context = context;
        this.defaults = defaults;
        this.name = name;
    }

    @Override
    public PreferenceCreator putInt(String key, int value) {
        this.sharedPreferences.edit().putInt(key, value).apply();
        return this;
    }

    @Override
    public PreferenceCreator putLong(String key, long value) {
        this.sharedPreferences.edit().putLong(key, value).apply();
        return this;
    }

    @Override
    public PreferenceCreator putFloat(String key, float value) {
        this.sharedPreferences.edit().putFloat(key, value).apply();
        return this;
    }

    @Override
    public PreferenceCreator putDouble(String key, double value) {
        this.sharedPreferences.edit().putString(key, String.valueOf(value)).apply();
        return this;
    }

    @Override
    public PreferenceCreator putBoolean(String key, boolean value) {
        this.sharedPreferences.edit().putBoolean(key, value).apply();
        return this;
    }

    @Override
    public PreferenceCreator putString(String key, String value) {
        this.sharedPreferences.edit().putString(key, value).apply();
        return this;
    }

    @Override
    public PreferenceCreator putObject(String key, Object value) {
        String json = new Gson().toJson(value);
        this.sharedPreferences.edit().putString(key, json).apply();
        return this;
    }

    @Override
    public Preference putMap(String key, Map value) {
        this.putObject(key, value);
        return this;
    }

    @Override
    public boolean setInt(String key, int value) {
        return this.sharedPreferences.edit().putInt(key, value).commit();
    }

    @Override
    public boolean setLong(String key, long value) {
        return this.sharedPreferences.edit().putLong(key, value).commit();
    }

    @Override
    public boolean setFloat(String key, float value) {
        return this.sharedPreferences.edit().putFloat(key, value).commit();
    }

    @Override
    public boolean setDouble(String key, double value) {
        return this.sharedPreferences.edit().putString(key, String.valueOf(value)).commit();
    }

    @Override
    public boolean setBoolean(String key, boolean value) {
        return this.sharedPreferences.edit().putBoolean(key, value).commit();
    }

    @Override
    public boolean setString(String key, String value) {
        return this.sharedPreferences.edit().putString(key, value).commit();
    }

    @Override
    public boolean setObject(String key, Object value) {
        String json = new Gson().toJson(value);
        return this.sharedPreferences.edit().putString(key, json).commit();
    }

    @Override
    public boolean setMap(String key, Map value) {
        return this.setObject(key, value);
    }

    @Override
    public boolean contains(String key) {
        return this.sharedPreferences.contains(key);
    }

    @Override
    public boolean remove(String key) {
        return this.sharedPreferences.edit().remove(key).commit();
    }

    @Override
    public void removeAsync(String key) {
        this.sharedPreferences.edit().remove(key).apply();
    }

    @Override
    public boolean clear() {
        return this.sharedPreferences.edit().clear().commit();
    }

    @Override
    public void clearAsync() {
        this.sharedPreferences.edit().clear().apply();
    }

    @Override
    public Map<String, ?> getData() {
        return this.sharedPreferences.getAll();
    }

    @Override
    @NonNull
    public String getString(String key) {
        Object value = this.getDefaultValue(key);
        String defaultValue = value != null ? String.valueOf(value) : "";
        return this.getString(key, defaultValue);
    }

    @Override
    public String getString(String key, String defValue) {
        try {
            return this.sharedPreferences.getString(key, defValue);
        }
        catch (ClassCastException e) {
            this.logClassCastException(key, "String", e);
            return defValue;
        }
    }

    @Override
    public int getInt(String key) {
        Object value = this.getDefaultValue(key);
        int defaultValue = 0;
        if (value != null) {
            if (value instanceof Integer) {
                defaultValue = (Integer)value;
            } else if (value instanceof String) {
                try {
                    defaultValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    this.logWrongValueException(key, "Integer", e);
                }
            } else {
                this.logWrongValueException(key, "Integer", new WrongValueException(value));
            }
        }
        return this.getInt(key, defaultValue);
    }

    @Override
    public int getInt(String key, int defValue) {
        try {
            return this.sharedPreferences.getInt(key, defValue);
        }
        catch (ClassCastException e) {
            this.logClassCastException(key, "Int", e);
            return defValue;
        }
    }

    @Override
    public long getLong(String key) {
        Object value = this.getDefaultValue(key);
        long defaultValue = 0L;
        if (value != null) {
            if (value instanceof Long) {
                defaultValue = (Long)value;
            } else if (value instanceof String) {
                try {
                    defaultValue = Long.parseLong((String)value);
                }
                catch (NumberFormatException e) {
                    this.logWrongValueException(key, "Long", e);
                }
            } else {
                this.logWrongValueException(key, "Long", new WrongValueException(value));
            }
        }
        return this.getLong(key, defaultValue);
    }

    @Override
    public long getLong(String key, long defValue) {
        try {
            return this.sharedPreferences.getLong(key, defValue);
        }
        catch (ClassCastException e) {
            this.logClassCastException(key, "Long", e);
            return defValue;
        }
    }

    @Override
    public boolean getBoolean(String key) {
        Object value = this.getDefaultValue(key);
        boolean defaultValue = false;
        if (value != null) {
            if (value instanceof Boolean) {
                defaultValue = (Boolean)value;
            } else if (value instanceof String) {
                defaultValue = Boolean.parseBoolean((String)value);
            } else {
                this.logWrongValueException(key, "Boolean", new WrongValueException(value));
            }
        }
        return this.getBoolean(key, defaultValue);
    }

    @Override
    public boolean getBoolean(String key, boolean defValue) {
        try {
            return this.sharedPreferences.getBoolean(key, defValue);
        }
        catch (ClassCastException e) {
            this.logClassCastException(key, "Boolean", e);
            return defValue;
        }
    }

    @Override
    public float getFloat(String key) {
        Object value = this.getDefaultValue(key);
        float defaultValue = 0.0f;
        if (value != null) {
            if (value instanceof Float) {
                defaultValue = ((Float)value).floatValue();
            } else if (value instanceof String) {
                try {
                    defaultValue = Float.parseFloat((String)value);
                }
                catch (NumberFormatException e) {
                    this.logWrongValueException(key, "Float", e);
                }
            } else {
                this.logWrongValueException(key, "Float", new WrongValueException(value));
            }
        }
        return this.getFloat(key, defaultValue);
    }

    @Override
    public float getFloat(String key, float defValue) {
        try {
            return this.sharedPreferences.getFloat(key, defValue);
        }
        catch (ClassCastException e) {
            this.logClassCastException(key, "Float", e);
            return defValue;
        }
    }

    @Override
    @Nullable
    public <T> T getObject(String key, Class classType) {
        String json = this.getString(key, "");
        Object value = new Gson().fromJson(json, classType);
        if (value == null) {
            return (T)this.getDefaultValue(key);
        }
        return (T)value;
    }

    @Override
    public <T> T getObject(String key, Class classType, T defValue) {
        String json = this.getString(key, "");
        Object value = new Gson().fromJson(json, classType);
        if (value == null) {
            return defValue;
        }
        return (T)value;
    }

    @Override
    @Nullable
    public <T extends AbstractMap> T getMap(String key, Class<T> mapType, Class keyType, Class valueType) {
        String json = this.getString(key, "");
        AbstractMap value = null;
        try {
            value = (AbstractMap)new Gson().fromJson(json, TypeToken.getParameterized(mapType, (Type[])new Type[]{keyType, valueType}).getType());
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"something went wrong!!", (Throwable)e);
        }
        if (value == null) {
            return (T)((AbstractMap)this.getDefaultValue(key));
        }
        return (T)value;
    }

    @Override
    @Nullable
    public <T extends AbstractMap> T getMap(String key, MapStructure structure) {
        String json = this.getString(key, "");
        AbstractMap value = null;
        try {
            Type type = TypeToken.getParameterized((Type)structure.getType(), (Type[])new Type[]{structure.getKey(), structure.getValue()}).getType();
            value = (AbstractMap)new Gson().fromJson(json, type);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"something went wrong!!", (Throwable)e);
        }
        if (value == null) {
            return (T)((AbstractMap)this.getDefaultValue(key));
        }
        return (T)value;
    }

    @Override
    public double getDouble(String key) {
        double value;
        String string = this.getString(key, "");
        double defaultDouble = 0.0;
        try {
            value = Double.valueOf(string);
        }
        catch (NumberFormatException exp) {
            Object defaultValue = this.getDefaultValue(key);
            if (defaultValue == null) {
                return 0.0;
            }
            if (defaultValue instanceof Double) {
                defaultDouble = (Double)defaultValue;
            } else if (defaultValue instanceof String) {
                try {
                    defaultDouble = Double.parseDouble((String)defaultValue);
                }
                catch (NumberFormatException e) {
                    this.logWrongValueException(key, "Double", e);
                }
            } else {
                this.logWrongValueException(key, "Double", new WrongValueException(defaultValue));
            }
            return defaultDouble;
        }
        return value;
    }

    @Override
    public double getDouble(String key, double defValue) {
        String json = this.getString(key, "");
        Object value = new Gson().fromJson(json, Double.TYPE);
        if (value == null) {
            return defValue;
        }
        return (Double)value;
    }

    @Override
    public void setDefaults(Map<String, Object> defaultValues) {
        if (defaultValues == null) {
            return;
        }
        this.defaults.put(this.name, defaultValues);
    }

    @Override
    public void setDefaults(@XmlRes int xml) {
        try {
            String KEY = "key";
            String VALUE = "value";
            String ENTRY = "entry";
            XmlResourceParser parser = this.context.getResources().getXml(xml);
            int eventType = parser.getEventType();
            String tagName = null;
            String key = null;
            String value = null;
            HashMap<String, String> defaultValues = new HashMap<String, String>();
            while (eventType != 1) {
                block1 : switch (eventType) {
                    case 2: {
                        tagName = parser.getName();
                        break;
                    }
                    case 4: {
                        if (tagName == null) break;
                        switch (tagName) {
                            case "key": {
                                key = parser.getText();
                                break block1;
                            }
                            case "value": {
                                value = parser.getText();
                                break block1;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("entry")) break;
                        defaultValues.put(key, value);
                        key = null;
                        value = null;
                    }
                }
                eventType = parser.next();
            }
            this.defaults.put(this.name, defaultValues);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"Caught exception while parsing XML resource. Skipping setDefaults.", (Throwable)e);
        }
    }

    @Nullable
    private Object getDefaultValue(String key) {
        Map defaultValues = (Map)this.defaults.get(this.name);
        if (defaultValues != null) {
            if (defaultValues.containsKey(key)) {
                return defaultValues.get(key);
            }
            return null;
        }
        return null;
    }

    private void logWrongValueException(String key, String type, Throwable th) {
        Log.e((String)TAG, (String)("you to must have a {" + type + "} default value! for the key => {" + key + "}"), (Throwable)th);
    }

    private void logClassCastException(String key, String type, Throwable th) {
        Log.e((String)TAG, (String)("The value of {" + key + "} key is not a " + type + "."), (Throwable)th);
    }

    private static class WrongValueException
    extends IllegalArgumentException {
        WrongValueException(Object value) {
            super("value => {" + value + "}");
        }
    }
}

