/*
 * Decompiled with CFR 0.152.
 */
package com.preference;

import android.content.Context;
import com.preference.Preference;
import com.preference.PreferenceManager;
import com.preference.model.PreferenceFile;
import java.util.List;

public class PowerPreference {
    public static void init(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        PreferenceManager.init(context.getApplicationContext());
    }

    public static Preference getDefaultFile() {
        return PreferenceManager.getInstance().getDefaultPreference();
    }

    public static Preference getFileByName(String name) {
        return PreferenceManager.getInstance().getPreferenceByName(name);
    }

    public static List<PreferenceFile> getAllData() {
        return PreferenceManager.getInstance().getData();
    }

    public static void clearAllData() {
        PowerPreference.getDefaultFile().clear();
        for (String filename : PreferenceManager.getInstance().getFilesName()) {
            PowerPreference.getFileByName(filename).clear();
        }
    }

    public static void clearAllDataAsync() {
        PowerPreference.getDefaultFile().clearAsync();
        for (String filename : PreferenceManager.getInstance().getFilesName()) {
            PowerPreference.getFileByName(filename).clearAsync();
        }
    }

    public static void showDebugScreen(boolean editable) {
        PreferenceManager.getInstance().showPreferenceScreen(editable);
    }
}

