/*
 * Decompiled with CFR 0.152.
 */
package com.preference;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.preference.model.PreferenceItem;
import com.preference.model.PreferenceObject;
import com.preference.model.PreferenceType;
import com.preference.provider.PreferenceProvider;
import com.preference.ui.activity.preference.PreferenceActivity;
import com.preference.utils.PreferenceCreator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PreferenceManager {
    private static PreferenceManager singleton;
    private final Context context;
    private Map<String, Object> defaults;

    private PreferenceManager(Context context, Map<String, Object> defaults) {
        this.context = context;
        this.defaults = defaults;
    }

    public static void setSingletonInstance(PreferenceManager singleton) {
        PreferenceManager.singleton = singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static PreferenceManager get() {
        if (singleton != null) return singleton;
        Class<PreferenceManager> clazz = PreferenceManager.class;
        synchronized (PreferenceManager.class) {
            if (singleton != null) return singleton;
            if (PreferenceProvider.context == null) {
                throw new IllegalStateException("context == null");
            }
            singleton = new Builder(PreferenceProvider.context).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    void showPreferenceScreen(boolean editable) {
        Intent intent = new Intent(this.context, PreferenceActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra("editable", editable);
        this.context.startActivity(intent);
    }

    PreferenceCreator getPreferenceByName(String name) {
        return new PreferenceCreator(name, this.context, this.defaults);
    }

    PreferenceCreator getDefaultPreference() {
        return new PreferenceCreator(this.context, this.defaults);
    }

    List<PreferenceObject> getData() {
        HashMap<SharedPreferences, String> nameHelper = new HashMap<SharedPreferences, String>();
        ArrayList<PreferenceObject> items = new ArrayList<PreferenceObject>();
        List<SharedPreferences> allFiles = this.getFiles(nameHelper);
        for (SharedPreferences sp : allFiles) {
            Map map = sp.getAll();
            if (map.size() <= 0) continue;
            ArrayList<PreferenceItem> prefsItems = new ArrayList<PreferenceItem>();
            for (Map.Entry obj : map.entrySet()) {
                PreferenceType type = this.getValueType(obj.getValue());
                prefsItems.add(new PreferenceItem((String)obj.getKey(), obj.getValue(), (String)nameHelper.get(sp), type));
            }
            items.add(new PreferenceObject(sp, (String)nameHelper.get(sp), prefsItems));
        }
        return items;
    }

    ArrayList<String> getFilesName() {
        ArrayList<String> filesName = new ArrayList<String>();
        String[] files = new File(PreferenceManager.get().context.getApplicationInfo().dataDir + "/shared_prefs").list();
        if (files != null) {
            for (String fileName : files) {
                String fileNameWithoutExtension = fileName.substring(0, TextUtils.indexOf((CharSequence)fileName, (CharSequence)".xml"));
                filesName.add(fileNameWithoutExtension);
            }
        }
        return filesName;
    }

    private PreferenceType getValueType(Object value) {
        if (value instanceof Boolean) {
            return PreferenceType.Boolean;
        }
        if (value instanceof String) {
            return PreferenceType.String;
        }
        if (value instanceof Integer) {
            return PreferenceType.Integer;
        }
        if (value instanceof Float) {
            return PreferenceType.Float;
        }
        if (value instanceof Long) {
            return PreferenceType.Long;
        }
        return PreferenceType.String;
    }

    private List<SharedPreferences> getFiles(Map<SharedPreferences, String> prefsNameHelper) {
        ArrayList<SharedPreferences> preferencesList = new ArrayList<SharedPreferences>();
        for (String fileName : this.getFilesName()) {
            SharedPreferences sp = this.context.getSharedPreferences(fileName, 0);
            prefsNameHelper.put(sp, fileName);
            preferencesList.add(sp);
        }
        return preferencesList;
    }

    public static class Builder {
        private final Context context;

        public Builder(Context context) {
            this.context = context;
        }

        public PreferenceManager build() {
            return new PreferenceManager(this.context, new HashMap());
        }
    }
}

