/*
 * Decompiled with CFR 0.152.
 */
package com.algolia.search;

import com.algolia.search.APIClientConfiguration;
import com.algolia.search.Index;
import com.algolia.search.IndexIterable;
import com.algolia.search.Utils;
import com.algolia.search.exceptions.AlgoliaException;
import com.algolia.search.http.AlgoliaHttpClient;
import com.algolia.search.http.AlgoliaRequest;
import com.algolia.search.http.HttpMethod;
import com.algolia.search.inputs.ApiKeys;
import com.algolia.search.inputs.Batch;
import com.algolia.search.inputs.BatchOperation;
import com.algolia.search.inputs.BatchOperations;
import com.algolia.search.inputs.MultipleQueriesRequests;
import com.algolia.search.inputs.OperationOnIndex;
import com.algolia.search.inputs.Requests;
import com.algolia.search.inputs.Search;
import com.algolia.search.inputs.batch.BatchAddObjectOperation;
import com.algolia.search.inputs.batch.BatchDeleteObjectOperation;
import com.algolia.search.inputs.batch.BatchPartialUpdateObjectOperation;
import com.algolia.search.inputs.batch.BatchUpdateObjectOperation;
import com.algolia.search.inputs.partial_update.PartialUpdateOperation;
import com.algolia.search.inputs.synonym.AbstractSynonym;
import com.algolia.search.objects.ApiKey;
import com.algolia.search.objects.IndexQuery;
import com.algolia.search.objects.IndexSettings;
import com.algolia.search.objects.Log;
import com.algolia.search.objects.LogType;
import com.algolia.search.objects.MultiQueriesStrategy;
import com.algolia.search.objects.Query;
import com.algolia.search.objects.SynonymQuery;
import com.algolia.search.objects.tasks.sync.GenericTask;
import com.algolia.search.objects.tasks.sync.Task;
import com.algolia.search.objects.tasks.sync.TaskIndexing;
import com.algolia.search.objects.tasks.sync.TaskSingleIndex;
import com.algolia.search.objects.tasks.sync.TasksMultipleIndex;
import com.algolia.search.responses.BrowseResult;
import com.algolia.search.responses.CreateUpdateKey;
import com.algolia.search.responses.DeleteKey;
import com.algolia.search.responses.Indices;
import com.algolia.search.responses.Logs;
import com.algolia.search.responses.MultiQueriesResult;
import com.algolia.search.responses.Results;
import com.algolia.search.responses.SearchResult;
import com.algolia.search.responses.SearchSynonymResult;
import com.algolia.search.responses.TaskStatus;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class APIClient {
    protected final AlgoliaHttpClient httpClient;
    protected final APIClientConfiguration configuration;

    APIClient(AlgoliaHttpClient httpClient, APIClientConfiguration configuration) {
        this.httpClient = httpClient;
        this.configuration = configuration;
    }

    public List<Index.Attributes> listIndices() throws AlgoliaException {
        Indices result = this.httpClient.requestWithRetry(new AlgoliaRequest<Indices>(HttpMethod.GET, true, Arrays.asList("1", "indexes"), Indices.class));
        return result.getItems();
    }

    public <T> Index<T> initIndex(@Nonnull String name, @Nonnull Class<T> klass) {
        return new Index<T>(name, klass, this);
    }

    public Index<?> initIndex(@Nonnull String name) {
        return new Index<Object>(name, Object.class, this);
    }

    public List<Log> getLogs() throws AlgoliaException {
        Logs result = this.httpClient.requestWithRetry(new AlgoliaRequest<Logs>(HttpMethod.GET, false, Arrays.asList("1", "logs"), Logs.class));
        return result.getLogs();
    }

    public List<Log> getLogs(@Nonnull Integer offset, @Nonnull Integer length, @Nonnull LogType logType) throws AlgoliaException {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset must be >= 0, was %s", (Object[])new Object[]{offset});
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length must be >= 0, was %s", (Object[])new Object[]{length});
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("offset", offset.toString());
        parameters.put("length", length.toString());
        parameters.put("type", logType.getName());
        Logs result = this.httpClient.requestWithRetry(new AlgoliaRequest<Logs>(HttpMethod.GET, false, Arrays.asList("1", "logs"), Logs.class).setParameters(parameters));
        return result.getLogs();
    }

    public List<ApiKey> listKeys() throws AlgoliaException {
        ApiKeys result = this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKeys>(HttpMethod.GET, false, Arrays.asList("1", "keys"), ApiKeys.class));
        return result.getKeys();
    }

    public Optional<ApiKey> getKey(@Nonnull String key) throws AlgoliaException {
        return Optional.ofNullable(this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKey>(HttpMethod.GET, false, Arrays.asList("1", "keys", key), ApiKey.class)));
    }

    public DeleteKey deleteKey(@Nonnull String key) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<DeleteKey>(HttpMethod.DELETE, false, Arrays.asList("1", "keys", key), DeleteKey.class));
    }

    public CreateUpdateKey addKey(@Nonnull ApiKey key) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.POST, false, Arrays.asList("1", "keys"), CreateUpdateKey.class).setData(key));
    }

    public CreateUpdateKey updateKey(@Nonnull String keyName, @Nonnull ApiKey key) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.PUT, false, Arrays.asList("1", "keys", keyName), CreateUpdateKey.class).setData(key));
    }

    public String generateSecuredApiKey(@Nonnull String privateApiKey, @Nonnull Query query) throws AlgoliaException {
        return this.generateSecuredApiKey(privateApiKey, query, null);
    }

    public String generateSecuredApiKey(@Nonnull String privateApiKey, @Nonnull Query query, String userToken) throws AlgoliaException {
        return Utils.generateSecuredApiKey(privateApiKey, query, userToken);
    }

    public <T> void waitTask(@Nonnull GenericTask<T> task, long timeToWait) throws AlgoliaException {
        Preconditions.checkArgument((timeToWait >= 0L ? 1 : 0) != 0, (String)"timeToWait must be >= 0, was %s", (Object[])new Object[]{timeToWait});
        TaskStatus status;
        while (!Objects.equals("published", (status = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskStatus>(HttpMethod.GET, false, Arrays.asList("1", "indexes", task.getIndexName(), "task", task.getTaskIDToWaitFor().toString()), TaskStatus.class))).getStatus())) {
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            timeToWait = (timeToWait *= 2L) > 10000L ? 10000L : timeToWait;
        }
        return;
    }

    public TasksMultipleIndex batch(@Nonnull List<BatchOperation> operations) throws AlgoliaException {
        boolean atLeastOneHaveIndexNameNull = operations.stream().anyMatch(o -> o.getIndexName() == null);
        if (atLeastOneHaveIndexNameNull) {
            throw new AlgoliaException("All batch operations must have an index name set");
        }
        TasksMultipleIndex request = this.httpClient.requestWithRetry(new AlgoliaRequest<TasksMultipleIndex>(HttpMethod.POST, true, Arrays.asList("1", "indexes", "*", "batch"), TasksMultipleIndex.class).setData(new BatchOperations(operations)));
        return request.setAPIClient(this);
    }

    public MultiQueriesResult multipleQueries(@Nonnull List<IndexQuery> queries) throws AlgoliaException {
        return this.multipleQueries(queries, MultiQueriesStrategy.NONE);
    }

    public MultiQueriesResult multipleQueries(@Nonnull List<IndexQuery> queries, @Nonnull MultiQueriesStrategy strategy) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<MultiQueriesResult>(HttpMethod.POST, true, Arrays.asList("1", "indexes", "*", "queries"), MultiQueriesResult.class).setData(new MultipleQueriesRequests(queries)).setParameters((Map<String, String>)ImmutableMap.of((Object)"strategy", (Object)strategy.getName())));
    }

    Task moveIndex(String srcIndexName, String dstIndexName) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", srcIndexName, "operation"), Task.class).setData(new OperationOnIndex("move", dstIndexName)));
        return result.setAPIClient(this).setIndex(srcIndexName);
    }

    Task copyIndex(String srcIndexName, String dstIndexName) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", srcIndexName, "operation"), Task.class).setData(new OperationOnIndex("copy", dstIndexName)));
        return result.setAPIClient(this).setIndex(srcIndexName);
    }

    Task deleteIndex(String indexName) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName), Task.class));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> TaskIndexing addObject(String indexName, T object) throws AlgoliaException {
        TaskIndexing result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskIndexing>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName), TaskIndexing.class).setData(object));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> TaskIndexing addObject(String indexName, String objectID, T object) throws AlgoliaException {
        TaskIndexing result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskIndexing>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, objectID), TaskIndexing.class).setData(object));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> Optional<T> getObject(String indexName, String objectID, Class<T> klass) throws AlgoliaException {
        return Optional.ofNullable(this.httpClient.requestWithRetry(new AlgoliaRequest<T>(HttpMethod.GET, true, Arrays.asList("1", "indexes", indexName, objectID), klass)));
    }

    <T> TaskSingleIndex addObjects(String indexName, List<T> objects) throws AlgoliaException {
        return this.batchSingleIndex(indexName, objects.stream().map(BatchAddObjectOperation::new).collect(Collectors.toList())).setAPIClient(this).setIndex(indexName);
    }

    private TaskSingleIndex batchSingleIndex(String indexName, List<BatchOperation> operations) throws AlgoliaException {
        TaskSingleIndex result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "batch"), TaskSingleIndex.class).setData(new Batch(operations)));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> Task saveObject(String indexName, String objectID, T object) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, objectID), Task.class).setData(object));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> TaskSingleIndex saveObjects(String indexName, List<T> objects) throws AlgoliaException {
        return this.batchSingleIndex(indexName, objects.stream().map(BatchUpdateObjectOperation::new).collect(Collectors.toList())).setAPIClient(this).setIndex(indexName);
    }

    Task deleteObject(String indexName, String objectID) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, objectID), Task.class));
        return result.setAPIClient(this).setIndex(indexName);
    }

    TaskSingleIndex deleteObjects(String indexName, List<String> objectIDs) throws AlgoliaException {
        return this.batchSingleIndex(indexName, objectIDs.stream().map(BatchDeleteObjectOperation::new).collect(Collectors.toList())).setAPIClient(this).setIndex(indexName);
    }

    Task clearIndex(String indexName) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "clear"), Task.class));
        return result.setAPIClient(this).setIndex(indexName);
    }

    <T> List<T> getObjects(String indexName, List<String> objectIDs, Class<T> klass) throws AlgoliaException {
        Requests requests = new Requests(objectIDs.stream().map(o -> new Requests.Request().setIndexName(indexName).setObjectID((String)o)).collect(Collectors.toList()));
        AlgoliaRequest<Results> algoliaRequest = new AlgoliaRequest<Results>(HttpMethod.POST, true, Arrays.asList("1", "indexes", "*", "objects"), Results.class, klass);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(requests)).getResults();
    }

    IndexSettings getSettings(String indexName) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<IndexSettings>(HttpMethod.GET, true, Arrays.asList("1", "indexes", indexName, "settings"), IndexSettings.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"getVersion", (Object)"2")));
    }

    Task setSettings(String indexName, IndexSettings settings, Boolean forwardToSlaves) throws AlgoliaException {
        Task result = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "settings"), Task.class).setData(settings).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString())));
        return result.setAPIClient(this).setIndex(indexName);
    }

    List<ApiKey> listKeys(String indexName) throws AlgoliaException {
        ApiKeys result = this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKeys>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "keys"), ApiKeys.class));
        return result.getKeys();
    }

    Optional<ApiKey> getKey(String indexName, String key) throws AlgoliaException {
        return Optional.ofNullable(this.httpClient.requestWithRetry(new AlgoliaRequest<ApiKey>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "keys", key), ApiKey.class)));
    }

    DeleteKey deleteKey(String indexName, String key) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<DeleteKey>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, "keys", key), DeleteKey.class));
    }

    CreateUpdateKey addKey(String indexName, ApiKey key) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "keys"), CreateUpdateKey.class).setData(key));
    }

    CreateUpdateKey updateKey(String indexName, String keyName, ApiKey key) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<CreateUpdateKey>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "keys", keyName), CreateUpdateKey.class).setData(key));
    }

    <T> SearchResult<T> search(String indexName, Query query, Class<T> klass) throws AlgoliaException {
        AlgoliaRequest<SearchResult> algoliaRequest = new AlgoliaRequest<SearchResult>(HttpMethod.POST, true, Arrays.asList("1", "indexes", indexName, "query"), SearchResult.class, klass);
        return this.httpClient.requestWithRetry(algoliaRequest.setData(new Search(query)));
    }

    TaskSingleIndex batch(String indexName, List<BatchOperation> operations) throws AlgoliaException {
        boolean onSameIndex = operations.stream().allMatch(o -> Objects.equals(null, o.getIndexName()));
        if (!onSameIndex) {
            throw new AlgoliaException("All operations are not on the same index");
        }
        TaskSingleIndex result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "batch"), TaskSingleIndex.class).setData(new BatchOperations(operations)));
        return result.setAPIClient(this).setIndex(indexName);
    }

    TaskSingleIndex partialUpdateObject(String indexName, PartialUpdateOperation operation, Boolean createIfNotExists) throws AlgoliaException {
        TaskSingleIndex result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, operation.getObjectID(), "partial"), TaskSingleIndex.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"createIfNotExists", (Object)createIfNotExists.toString())).setData(operation.toSerialize()));
        return result.setAPIClient(this).setIndex(indexName);
    }

    TaskSingleIndex partialUpdateObject(String indexName, String objectID, Object object) throws AlgoliaException {
        TaskSingleIndex result = this.httpClient.requestWithRetry(new AlgoliaRequest<TaskSingleIndex>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, objectID, "partial"), TaskSingleIndex.class).setData(object));
        return result.setAPIClient(this).setIndex(indexName);
    }

    Task saveSynonym(String indexName, String synonymID, AbstractSynonym content, Boolean forwardToSlaves, Boolean replaceExistingSynonyms) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.PUT, false, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString(), (Object)"replaceExistingSynonyms", (Object)replaceExistingSynonyms.toString())).setData(content));
        return task.setAPIClient(this).setIndex(indexName);
    }

    Optional<AbstractSynonym> getSynonym(String indexName, String synonymID) throws AlgoliaException {
        return Optional.ofNullable(this.httpClient.requestWithRetry(new AlgoliaRequest<AbstractSynonym>(HttpMethod.GET, false, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), AbstractSynonym.class)));
    }

    Task deleteSynonym(String indexName, String synonymID, Boolean forwardToSlaves) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.DELETE, false, Arrays.asList("1", "indexes", indexName, "synonyms", synonymID), Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString())));
        return task.setAPIClient(this).setIndex(indexName);
    }

    Task clearSynonyms(String indexName, Boolean forwardToSlaves) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "synonyms", "clear"), Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString())));
        return task.setAPIClient(this).setIndex(indexName);
    }

    SearchSynonymResult searchSynonyms(String indexName, SynonymQuery query) throws AlgoliaException {
        return this.httpClient.requestWithRetry(new AlgoliaRequest<SearchSynonymResult>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "synonyms", "search"), SearchSynonymResult.class).setData(query));
    }

    Task batchSynonyms(String indexName, List<AbstractSynonym> synonyms, Boolean forwardToSlaves, Boolean replaceExistingSynonyms) throws AlgoliaException {
        Task task = this.httpClient.requestWithRetry(new AlgoliaRequest<Task>(HttpMethod.POST, false, Arrays.asList("1", "indexes", indexName, "synonyms", "batch"), Task.class).setParameters((Map<String, String>)ImmutableMap.of((Object)"forwardToSlaves", (Object)forwardToSlaves.toString(), (Object)"replaceExistingSynonyms", (Object)replaceExistingSynonyms.toString())).setData(synonyms));
        return task.setAPIClient(this).setIndex(indexName);
    }

    void deleteByQuery(String indexName, Query query, int batchSize) throws AlgoliaException {
        query = query.setAttributesToRetrieve(Collections.singletonList("objectID")).setAttributesToHighlight(Collections.emptyList()).setAttributesToSnippet(Collections.emptyList()).setHitsPerPage(1000).setDistinct(false);
        ArrayList<String> objectToDelete = new ArrayList<String>(batchSize);
        for (ObjectID o : new IndexIterable<ObjectID>(this, indexName, query, ObjectID.class)) {
            objectToDelete.add(o.getObjectID());
            while (objectToDelete.size() >= batchSize) {
                List<String> subList = objectToDelete.subList(0, batchSize);
                this.deleteObjects(indexName, subList).waitForCompletion();
                subList.clear();
            }
        }
        if (!objectToDelete.isEmpty()) {
            this.deleteObjects(indexName, objectToDelete).waitForCompletion();
        }
    }

    TaskSingleIndex partialUpdateObjects(String indexName, List<Object> objects) throws AlgoliaException {
        TaskSingleIndex task = this.batch(indexName, objects.stream().map(BatchPartialUpdateObjectOperation::new).collect(Collectors.toList()));
        return task.setAPIClient(this).setIndex(indexName);
    }

    <T> BrowseResult<T> browse(String indexName, Query query, String cursor, Class<T> klass) throws AlgoliaException {
        AlgoliaRequest<BrowseResult> algoliaRequest = new AlgoliaRequest<BrowseResult>(HttpMethod.GET, true, Arrays.asList("1", "indexes", indexName, "browse"), BrowseResult.class, klass).setParameters(query.setCursor(cursor).toQueryParam());
        return this.httpClient.requestWithRetry(algoliaRequest);
    }

    private static class ObjectID {
        private String objectID;

        private ObjectID() {
        }

        public String getObjectID() {
            return this.objectID;
        }

        public ObjectID setObjectID(String objectID) {
            this.objectID = objectID;
            return this;
        }
    }
}

