/*
 * Decompiled with CFR 0.152.
 */
package com.alexnederlof.jasperreport;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import org.apache.maven.plugin.logging.Log;

public class CompileTask
implements Callable<Void> {
    private final File source;
    private final File destination;
    private final Log log;
    private final boolean verbose;

    public CompileTask(File source, File destination, Log log, boolean verbose) {
        this.source = source;
        this.destination = destination;
        this.log = log;
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        FileOutputStream out = null;
        InputStream in = null;
        try {
            out = new FileOutputStream(this.destination);
            in = new FileInputStream(this.source);
            JasperCompileManager.compileReportToStream((InputStream)in, (OutputStream)out);
            if (this.verbose) {
                this.log.info((CharSequence)("Compiling " + this.source.getName()));
            }
        }
        catch (Exception e) {
            this.cleanUpAndThrowError(this.destination, e);
        }
        finally {
            if (out != null) {
                ((OutputStream)out).close();
            }
            if (in != null) {
                in.close();
            }
        }
        return null;
    }

    private void cleanUpAndThrowError(File out, Exception e) throws JRException {
        this.log.error((CharSequence)("Could not compile " + this.source.getName() + " because " + e.getMessage()), (Throwable)e);
        if (out != null && out.exists()) {
            out.delete();
        }
        throw new JRException("Could not compile " + this.source.getName(), (Throwable)e);
    }
}

