/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.models;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.polestar.helpers.Log;
import com.polestar.naosdk.controllers.AndroidGeofencingService;

public class GeofenceTransition
extends IntentService {
    public GeofenceTransition() {
        super("ReceiveGeofenceTransitionIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        Log.writeToLog(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onHandleIntent");
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent != null) {
            if (geofencingEvent.hasError()) {
                this.a(geofencingEvent.getErrorCode());
            } else {
                int n = geofencingEvent.getGeofenceTransition();
                if (n == 1 || n == 4 || n == 2) {
                    String[] stringArray = new String[geofencingEvent.getTriggeringGeofences().size()];
                    for (int k = 0; k < geofencingEvent.getTriggeringGeofences().size(); ++k) {
                        stringArray[k] = ((Geofence)geofencingEvent.getTriggeringGeofences().get(k)).getRequestId();
                    }
                    if (n == 1 || n == 4) {
                        this.a(stringArray);
                    } else if (n == 2) {
                        this.b(stringArray);
                    }
                } else {
                    Log.writeToLog(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onHandleIntent unsupported geofence type");
                }
            }
        } else {
            Log.writeToLog(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onHandleIntent without event");
        }
    }

    protected void a(String[] stringArray) {
        Log.alwaysWarn(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onEnter");
        Intent intent = new Intent((Context)this, AndroidGeofencingService.class);
        intent.putExtra("event", "enter");
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForegroundService(intent);
        } else {
            this.startService(intent);
        }
    }

    protected void b(String[] stringArray) {
        Log.alwaysWarn(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onExit");
        Intent intent = new Intent((Context)this, AndroidGeofencingService.class);
        intent.putExtra("event", "exit");
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForegroundService(intent);
        } else {
            this.startService(intent);
        }
    }

    protected void a(int n) {
        Log.alwaysError(((Object)((Object)this)).getClass().getName(), "Error: " + n);
        Log.writeToLog(((Object)((Object)this)).getClass().getName(), "AndroidGeofencingService >> onError with code " + n);
    }
}

