package com.example.networkcalladapterlib

import okhttp3.Headers
import retrofit2.Response

sealed class ResponseNetwork<T> {

    companion object {

        fun <T> create(error: Exception): ResponseNetworkError<T> {
            return ResponseNetworkError(999,Exception(error.message ?: "Unknown Error"))
        }

        fun <T> create(response: Response<T>): ResponseNetwork<T> {
            return if (response.isSuccessful) {
                response.body()?.let {
                    ResponseNetworkSuccess(response.code(), response.headers(), it)
                } ?: ResponseNetworkEmpty(
                    response.code(),
                    response.errorBody()?.string() ?: "unknown error"
                )
            } else {
                val code = response.code()
                val exception = Exception(response.raw().message())
                ResponseNetworkError(code, exception)
                }

            }
        }

}

data class ResponseNetworkSuccess<T>(
    val code: Int,
    val header: Headers,
    val body: T
) : ResponseNetwork<T>()

data class ResponseNetworkEmpty<T>(
    val code: Int,
    val message: String
) : ResponseNetwork<T>()

data class ResponseNetworkError<T>(
    val code: Int,
    val exception: Exception
) : ResponseNetwork<T>()

