package com.example.networkcalladapterlib

import okhttp3.Headers
import retrofit2.Response

sealed class ResponseNetwork<T> {

    companion object {

        fun <T> create(error: Exception): ResponseNetworkError<T> {
            return ResponseNetworkError(999,error.message ?: "Unknown Error", error, null )
        }

        fun <T> create(response: Response<T>): ResponseNetwork<T> {
            return if (response.isSuccessful) {
                response.body()?.let {
                    ResponseNetworkSuccess(response.code(), response.headers(), it)
                } ?: ResponseNetworkEmpty(
                    response.code(),
                    response.errorBody()?.string() ?: "unknown error"
                )
            } else {
                return response.raw().use {
                    val code = it.code()
                    val message = it.message()
                    val method = it.request().method()
                    val url = it.request().url().url()
                    ResponseNetworkError(code, message, Exception("Code: $code, Method: $method, Message: $message, Url: $url"), response.raw())
                }

            }
        }

    }
}

data class ResponseNetworkSuccess<T>(
    val code: Int,
    val header: Headers,
    val body: T
) : ResponseNetwork<T>()

data class ResponseNetworkEmpty<T>(
    val code: Int,
    val message: String
) : ResponseNetwork<T>()

data class ResponseNetworkError<T>(
    val code: Int,
    val message: String,
    val exception: Exception,
    val errorResponse: okhttp3.Response?
) : ResponseNetwork<T>()

