package com.example.networkcalladapterlib

import okhttp3.Headers
import retrofit2.Response

sealed class ResponseNetwork<T> {

    companion object {

        fun <T> create(error: Exception): ResponseNetworkError<T> {
            return ResponseNetworkError(error)
        }

        fun <T> create(response: Response<T>): ResponseNetwork<T> {
            return if (response.isSuccessful) {
                response.body()?.let {
                    ResponseNetworkSuccess(response.code(), response.headers(), it)
                } ?: ResponseNetworkEmpty(
                    response.code(),
                    response.errorBody()?.string() ?: "unknown error"
                )
            } else {
                val msg = response.errorBody()?.string()
                ResponseNetworkError(Exception(msg))
            }
        }

    }
}

data class ResponseNetworkSuccess<T>(
    val code: Int,
    val header: Headers,
    val body: T
) : ResponseNetwork<T>()

data class ResponseNetworkEmpty<T>(
    val code: Int,
    val message: String
) : ResponseNetwork<T>()

data class ResponseNetworkError<T>(
    val exception: Exception
) : ResponseNetwork<T>()

