package com.example.networkcalladapterlib

import okhttp3.Request
import retrofit2.*
import java.lang.reflect.ParameterizedType
import java.lang.reflect.Type

class NetworkCallAdapterFactory : CallAdapter.Factory() {
    override fun get(
        returnType: Type,
        annotations: Array<Annotation>,
        retrofit: Retrofit
    ) = when (getRawType(returnType)) {
        Call::class.java -> {
            val callType = getParameterUpperBound(0, returnType as ParameterizedType)
            when (getRawType(callType)) {
                ResponseNetwork::class.java -> {
                    require(callType is ParameterizedType){ "resource must be paramterized" }
                    val resultType = getParameterUpperBound(0, callType )
                    ResponseNetworkAdapter<Any>(resultType)
                }
                else -> null
            }
        }
        else -> null
    }

    companion object {
        @JvmStatic
        fun create() = NetworkCallAdapterFactory()
    }

}

class ResponseNetworkAdapter<T: Any>(
    private val type: Type
) : CallAdapter<T, Any> {
    override fun responseType() = type
    override fun adapt(call: Call<T>): Any = ResponseNetworkCall(call)
}

abstract class CallDelegate<TIn, TOut>(
    protected val proxy: Call<TIn>
) : Call<TOut> {
    override fun execute(): Response<TOut> = throw NotImplementedError()
    final override fun enqueue(callback: Callback<TOut>) = enqueueImpl(callback)
    final override fun clone(): Call<TOut> = cloneImpl()

    override fun cancel() = proxy.cancel()
    override fun request(): Request = proxy.request()
    override fun isExecuted() = proxy.isExecuted
    override fun isCanceled() = proxy.isCanceled

    abstract fun enqueueImpl(callback: Callback<TOut>)
    abstract fun cloneImpl(): Call<TOut>
}


class ResponseNetworkCall<T: Any>(proxy: Call<T>) : CallDelegate<T, ResponseNetwork<T>>(proxy) {

    init {
        print(proxy::class)
    }

    override fun enqueueImpl(callback: Callback<ResponseNetwork<T>>) {

        proxy.enqueue(object : Callback<T> {

            override fun onResponse(call: Call<T>, response: Response<T>) {
                callback.onResponse(this@ResponseNetworkCall, Response.success(ResponseNetwork.create(response)))
            }

            override fun onFailure(call: Call<T>, t: Throwable) {
                callback.onResponse(this@ResponseNetworkCall, Response.success(ResponseNetwork.create(Exception(t))))
            }
        })
    }

    override fun cloneImpl() = ResponseNetworkCall(proxy.clone())
}
