/*
 * Decompiled with CFR 0.152.
 */
package com.alanapi.navigation;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import com.alanapi.navigation.BadgeItem;

public class BottomNavigationItem {
    protected int mIconResource;
    protected Drawable mIcon;
    protected int mInactiveIconResource;
    protected Drawable mInactiveIcon;
    protected boolean inActiveIconAvailable = false;
    protected int mTitleResource;
    protected String mTitle;
    protected int mActiveColorResource;
    protected String mActiveColorCode;
    protected int mActiveColor;
    protected int mInActiveColorResource;
    protected String mInActiveColorCode;
    protected int mInActiveColor;
    protected BadgeItem mBadgeItem;

    public BottomNavigationItem(@DrawableRes int mIconResource, @NonNull String mTitle) {
        this.mIconResource = mIconResource;
        this.mTitle = mTitle;
    }

    public BottomNavigationItem(Drawable mIcon, @NonNull String mTitle) {
        this.mIcon = mIcon;
        this.mTitle = mTitle;
    }

    public BottomNavigationItem(Drawable mIcon, @StringRes int mTitleResource) {
        this.mIcon = mIcon;
        this.mTitleResource = mTitleResource;
    }

    public BottomNavigationItem(@DrawableRes int mIconResource, @StringRes int mTitleResource) {
        this.mIconResource = mIconResource;
        this.mTitleResource = mTitleResource;
    }

    public BottomNavigationItem setInactiveIcon(Drawable mInactiveIcon) {
        if (mInactiveIcon != null) {
            this.mInactiveIcon = mInactiveIcon;
            this.inActiveIconAvailable = true;
        }
        return this;
    }

    public BottomNavigationItem setInactiveIconResource(@DrawableRes int mInactiveIconResource) {
        this.mInactiveIconResource = mInactiveIconResource;
        this.inActiveIconAvailable = true;
        return this;
    }

    public BottomNavigationItem setActiveColorResource(@ColorRes int colorResource) {
        this.mActiveColorResource = colorResource;
        return this;
    }

    public BottomNavigationItem setActiveColor(@Nullable String colorCode) {
        this.mActiveColorCode = colorCode;
        return this;
    }

    public BottomNavigationItem setActiveColor(int color) {
        this.mActiveColor = color;
        return this;
    }

    public BottomNavigationItem setInActiveColorResource(@ColorRes int colorResource) {
        this.mInActiveColorResource = colorResource;
        return this;
    }

    public BottomNavigationItem setInActiveColor(@Nullable String colorCode) {
        this.mInActiveColorCode = colorCode;
        return this;
    }

    public BottomNavigationItem setInActiveColor(int color) {
        this.mInActiveColor = color;
        return this;
    }

    public BottomNavigationItem setBadgeItem(@Nullable BadgeItem badgeItem) {
        this.mBadgeItem = badgeItem;
        return this;
    }

    protected Drawable getIcon(Context context) {
        if (this.mIconResource != 0) {
            return ContextCompat.getDrawable((Context)context, (int)this.mIconResource);
        }
        return this.mIcon;
    }

    protected String getTitle(Context context) {
        if (this.mTitleResource != 0) {
            return context.getString(this.mTitleResource);
        }
        return this.mTitle;
    }

    protected Drawable getInactiveIcon(Context context) {
        if (this.mInactiveIconResource != 0) {
            return ContextCompat.getDrawable((Context)context, (int)this.mInactiveIconResource);
        }
        return this.mInactiveIcon;
    }

    protected boolean isInActiveIconAvailable() {
        return this.inActiveIconAvailable;
    }

    protected int getActiveColor(Context context) {
        if (this.mActiveColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mActiveColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mActiveColorCode)) {
            return Color.parseColor((String)this.mActiveColorCode);
        }
        if (this.mActiveColor != 0) {
            return this.mActiveColor;
        }
        return -1;
    }

    protected int getInActiveColor(Context context) {
        if (this.mInActiveColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mInActiveColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mInActiveColorCode)) {
            return Color.parseColor((String)this.mInActiveColorCode);
        }
        if (this.mInActiveColor != 0) {
            return this.mInActiveColor;
        }
        return -1;
    }

    protected BadgeItem getBadgeItem() {
        return this.mBadgeItem;
    }
}

