/*
 * Decompiled with CFR 0.152.
 */
package com.alanapi.navigation;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.alanapi.navigation.BottomNavigationHelper;
import java.lang.ref.WeakReference;

public class BadgeItem {
    private int mBackgroundColorResource;
    private String mBackgroundColorCode;
    private int mBackgroundColor = -65536;
    private int mTextColorResource;
    private String mTextColorCode;
    private int mTextColor = -1;
    private CharSequence mText;
    private int mBorderColorResource;
    private String mBorderColorCode;
    private int mBorderColor = -1;
    private int mBorderWidth = 0;
    private int mOvalRadius = 0;
    private int mGravity = 8388661;
    private boolean mHideOnSelect;
    private WeakReference<TextView> mTextViewRef;
    private boolean mIsHidden = false;
    private int mAnimationDuration = 200;

    public BadgeItem setBackgroundColorResource(@ColorRes int colorResource) {
        this.mBackgroundColorResource = colorResource;
        this.refreshDrawable();
        return this;
    }

    public BadgeItem setBackgroundColor(@Nullable String colorCode) {
        this.mBackgroundColorCode = colorCode;
        this.refreshDrawable();
        return this;
    }

    public BadgeItem setBackgroundColor(int color) {
        this.mBackgroundColor = color;
        this.refreshDrawable();
        return this;
    }

    public BadgeItem setBackgroundResource() {
        return this;
    }

    public BadgeItem setTextColorResource(@ColorRes int colorResource) {
        this.mTextColorResource = colorResource;
        this.setTextColor();
        return this;
    }

    public BadgeItem setTextColor(@Nullable String colorCode) {
        this.mTextColorCode = colorCode;
        this.setTextColor();
        return this;
    }

    public BadgeItem setTextColor(int color) {
        this.mTextColor = color;
        this.setTextColor();
        return this;
    }

    public BadgeItem setText(@Nullable CharSequence text) {
        this.mText = text;
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.mTextViewRef.get();
            if (!TextUtils.isEmpty((CharSequence)text)) {
                textView.setText(text);
            }
        }
        return this;
    }

    public BadgeItem setBorderColorResource(@ColorRes int colorResource) {
        this.mBorderColorResource = colorResource;
        this.refreshDrawable();
        return this;
    }

    public BadgeItem setBorderColor(@Nullable String colorCode) {
        this.mBorderColorCode = colorCode;
        this.refreshDrawable();
        return this;
    }

    public BadgeItem setBorderColor(int color) {
        this.mBorderColor = color;
        this.refreshDrawable();
        return this;
    }

    public BadgeItem setBorderWidth(int borderWidth) {
        this.mBorderWidth = borderWidth;
        this.refreshDrawable();
        return this;
    }

    public BadgeItem setGravity(int gravity) {
        this.mGravity = gravity;
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.mTextViewRef.get();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)textView.getLayoutParams();
            layoutParams.gravity = gravity;
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        return this;
    }

    public BadgeItem setHideOnSelect(boolean hideOnSelect) {
        this.mHideOnSelect = hideOnSelect;
        return this;
    }

    public BadgeItem setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
        return this;
    }

    public BadgeItem showBadgeItemPoint() {
        TextView textView;
        if (this.isWeakReferenceValid() && (textView = (TextView)this.mTextViewRef.get()) != null) {
            BottomNavigationHelper.setBadgeItemToPoint(this, textView);
        }
        return this;
    }

    public BadgeItem hideBadgeItemPoint() {
        this.hide();
        return this;
    }

    protected BadgeItem setTextView(TextView mTextView) {
        this.mTextViewRef = new WeakReference<TextView>(mTextView);
        return this;
    }

    protected int getBackgroundColor(Context context) {
        if (this.mBackgroundColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mBackgroundColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBackgroundColorCode)) {
            return Color.parseColor((String)this.mBackgroundColorCode);
        }
        return this.mBackgroundColor;
    }

    protected int getTextColor(Context context) {
        if (this.mTextColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mTextColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTextColorCode)) {
            return Color.parseColor((String)this.mTextColorCode);
        }
        return this.mTextColor;
    }

    protected CharSequence getText() {
        return this.mText;
    }

    protected int getBorderColor(Context context) {
        if (this.mBorderColorResource != 0) {
            return ContextCompat.getColor((Context)context, (int)this.mBorderColorResource);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBorderColorCode)) {
            return Color.parseColor((String)this.mBorderColorCode);
        }
        return this.mBorderColor;
    }

    protected int getBorderWidth() {
        return this.mBorderWidth;
    }

    protected int getGravity() {
        return this.mGravity;
    }

    protected boolean isHideOnSelect() {
        return this.mHideOnSelect;
    }

    protected WeakReference<TextView> getTextView() {
        return this.mTextViewRef;
    }

    private void refreshDrawable() {
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.mTextViewRef.get();
            textView.setBackgroundDrawable((Drawable)BottomNavigationHelper.getBadgeDrawable(this, textView.getContext()));
        }
    }

    private void setTextColor() {
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.mTextViewRef.get();
            textView.setTextColor(this.getTextColor(textView.getContext()));
        }
    }

    private boolean isWeakReferenceValid() {
        return this.mTextViewRef != null && this.mTextViewRef.get() != null;
    }

    void select() {
        if (this.mHideOnSelect) {
            this.hide(true);
        }
    }

    void unSelect() {
        if (this.mHideOnSelect) {
            this.show(true);
        }
    }

    public BadgeItem toggle() {
        return this.toggle(true);
    }

    public BadgeItem toggle(boolean animate) {
        if (this.mIsHidden) {
            return this.show(animate);
        }
        return this.hide(animate);
    }

    public void setOvalRadius(int ovalRadius) {
        this.mOvalRadius = ovalRadius;
    }

    public int getOvalRadius() {
        return this.mOvalRadius;
    }

    public BadgeItem show() {
        return this.show(true);
    }

    public BadgeItem show(boolean animate) {
        this.mIsHidden = false;
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.mTextViewRef.get();
            if (animate) {
                textView.setScaleX(0.0f);
                textView.setScaleY(0.0f);
                textView.setVisibility(0);
                ViewPropertyAnimatorCompat animatorCompat = ViewCompat.animate((View)textView);
                animatorCompat.cancel();
                animatorCompat.setDuration((long)this.mAnimationDuration);
                animatorCompat.scaleX(1.0f).scaleY(1.0f);
                animatorCompat.setListener(null);
                animatorCompat.start();
            } else {
                textView.setScaleX(1.0f);
                textView.setScaleY(1.0f);
                textView.setVisibility(0);
            }
        }
        return this;
    }

    public BadgeItem hide() {
        return this.hide(true);
    }

    public BadgeItem hide(boolean animate) {
        this.mIsHidden = true;
        if (this.isWeakReferenceValid()) {
            TextView textView = (TextView)this.mTextViewRef.get();
            if (animate) {
                ViewPropertyAnimatorCompat animatorCompat = ViewCompat.animate((View)textView);
                animatorCompat.cancel();
                animatorCompat.setDuration((long)this.mAnimationDuration);
                animatorCompat.scaleX(0.0f).scaleY(0.0f);
                animatorCompat.setListener(new ViewPropertyAnimatorListener(){

                    public void onAnimationStart(View view) {
                    }

                    public void onAnimationEnd(View view) {
                        view.setVisibility(8);
                    }

                    public void onAnimationCancel(View view) {
                        view.setVisibility(8);
                    }
                });
                animatorCompat.start();
            } else {
                textView.setVisibility(8);
            }
        }
        return this;
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }
}

