/*
 * Decompiled with CFR 0.152.
 */
package com.akhgupta.easylocation;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.akhgupta.easylocation.PreferenceUtil;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;

public class LocationBgService
extends Service
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private static final long NO_FALLBACK = 0L;
    private final String TAG = LocationBgService.class.getSimpleName();
    private GoogleApiClient googleApiClient;
    private int mLocationMode;
    private LocationRequest mLocationRequest;
    private Handler handler;
    private long fallBackToLastLocationTime;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.handler = new Handler();
        this.googleApiClient = new GoogleApiClient.Builder((Context)this).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        Log.d((String)this.TAG, (String)"googleApiClient created");
        this.googleApiClient.connect();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        Log.d((String)this.TAG, (String)("googleApiClient start command " + intent.getAction()));
        if (intent.getAction().equals("location.fetch.start")) {
            this.mLocationMode = intent.getIntExtra("location_fetch_mode", 1);
            this.mLocationRequest = (LocationRequest)intent.getParcelableExtra("location_request");
            this.fallBackToLastLocationTime = intent.getLongExtra("fallback_to_last_location_time", 0L);
            if (this.mLocationRequest == null) {
                throw new IllegalStateException("Location request can't be null");
            }
            if (this.googleApiClient.isConnected()) {
                this.requestLocationUpdates();
            }
        } else if (intent.getAction().equals("location.fetch.stop")) {
            this.stopLocationService();
        }
        return 2;
    }

    private void requestLocationUpdates() {
        if (this.mLocationRequest != null) {
            this.startFallbackToLastLocationTimer();
            LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, this.mLocationRequest, (LocationListener)this);
        }
    }

    private void startFallbackToLastLocationTimer() {
        if (this.fallBackToLastLocationTime != 0L) {
            this.handler.removeCallbacksAndMessages(null);
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LocationBgService.this.onLocationChanged(LocationServices.FusedLocationApi.getLastLocation(LocationBgService.this.googleApiClient));
                }
            }, this.fallBackToLastLocationTime);
        }
    }

    public void onConnected(@Nullable Bundle bundle) {
        Log.d((String)this.TAG, (String)"googleApiClient connected");
        this.requestLocationUpdates();
    }

    public void onConnectionSuspended(int i) {
        Log.d((String)this.TAG, (String)"googleApiClient connection suspended");
        this.stopLocationService();
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Log.d((String)this.TAG, (String)"googleApiClient connection failed");
        this.stopLocationService();
    }

    private void stopLocationService() {
        if (this.handler != null) {
            this.handler.removeCallbacksAndMessages(null);
        }
        Log.d((String)this.TAG, (String)"googleApiClient removing location updates");
        if (this.googleApiClient != null && this.googleApiClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, (LocationListener)this);
            Log.d((String)this.TAG, (String)"googleApiClient disconnect");
            this.googleApiClient.disconnect();
        }
        Log.d((String)this.TAG, (String)"googleApiClient stop service");
        this.stopSelf();
    }

    public void onLocationChanged(Location location) {
        Log.d((String)this.TAG, (String)"googleApiClient location received");
        if (location != null) {
            PreferenceUtil.getInstance((Context)this).saveLastKnownLocation(location);
            Intent intent = new Intent();
            intent.setAction("intent.location.received");
            intent.putExtra("location", (Parcelable)location);
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
        }
        if (this.mLocationMode == 1) {
            this.stopLocationService();
        }
    }
}

