/*
 * Decompiled with CFR 0.152.
 */
package com.ajts.androidmads.sqliteimpex;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SQLiteImporterExporter
extends SQLiteOpenHelper {
    private Context context;
    private String DB_PATH;
    private String DB_NAME;
    public ImportListener importListener;
    public ExportListener exportListener;

    @SuppressLint(value={"SdCardPath"})
    public SQLiteImporterExporter(Context context, String DB_NAME) {
        super(context, DB_NAME, null, 1);
        this.context = context;
        this.DB_NAME = DB_NAME;
        this.DB_PATH = "/data/data/" + context.getPackageName() + "/databases/";
    }

    public void setOnImportListener(ImportListener importListener) {
        this.importListener = importListener;
    }

    public void setOnExportListener(ExportListener exportListener) {
        this.exportListener = exportListener;
    }

    public boolean isDataBaseExists() {
        File dbFile = new File(this.DB_PATH + this.DB_NAME);
        return dbFile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDataBaseFromAssets() {
        InputStream myInput = null;
        OutputStream myOutput = null;
        try {
            int length;
            this.getReadableDatabase();
            myInput = this.context.getAssets().open(this.DB_NAME);
            String outFileName = this.DB_PATH + this.DB_NAME;
            myOutput = new FileOutputStream(outFileName);
            byte[] buffer = new byte[1024];
            while ((length = myInput.read(buffer)) > 0) {
                myOutput.write(buffer, 0, length);
            }
            if (this.importListener != null) {
                this.importListener.onSuccess("Successfully Imported");
            }
        }
        catch (Exception e) {
            if (this.importListener != null) {
                this.importListener.onFailure(e);
            }
        }
        finally {
            block15: {
                try {
                    myOutput.flush();
                    myOutput.close();
                    myInput.close();
                }
                catch (IOException e) {
                    if (this.importListener == null) break block15;
                    this.importListener.onFailure(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDataBase(String path) {
        InputStream myInput = null;
        OutputStream myOutput = null;
        try {
            int length;
            this.getReadableDatabase();
            String inFileName = path + this.DB_NAME;
            myInput = new FileInputStream(inFileName);
            String outFileName = this.DB_PATH + this.DB_NAME;
            myOutput = new FileOutputStream(outFileName);
            byte[] buffer = new byte[1024];
            while ((length = myInput.read(buffer)) > 0) {
                myOutput.write(buffer, 0, length);
            }
            if (this.importListener != null) {
                this.importListener.onSuccess("Successfully Imported");
            }
        }
        catch (Exception e) {
            if (this.importListener != null) {
                this.importListener.onFailure(e);
            }
        }
        finally {
            block15: {
                try {
                    myOutput.flush();
                    myOutput.close();
                    myInput.close();
                }
                catch (IOException ioe) {
                    if (this.importListener == null) break block15;
                    this.importListener.onFailure(ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDataBase(String path) {
        InputStream myInput = null;
        OutputStream myOutput = null;
        try {
            int length;
            String inFileName = this.DB_PATH + this.DB_NAME;
            myInput = new FileInputStream(inFileName);
            String outFileName = path + this.DB_NAME;
            myOutput = new FileOutputStream(outFileName);
            byte[] buffer = new byte[1024];
            while ((length = myInput.read(buffer)) > 0) {
                myOutput.write(buffer, 0, length);
            }
            if (this.exportListener != null) {
                this.exportListener.onSuccess("Successfully Exported");
            }
        }
        catch (Exception e) {
            if (this.exportListener != null) {
                this.exportListener.onFailure(e);
            }
        }
        finally {
            block15: {
                try {
                    myOutput.flush();
                    myOutput.close();
                    myInput.close();
                }
                catch (Exception ex) {
                    if (this.exportListener == null) break block15;
                    this.exportListener.onFailure(ex);
                }
            }
        }
    }

    public void onCreate(SQLiteDatabase arg0) {
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    public static interface ExportListener {
        public void onSuccess(String var1);

        public void onFailure(Exception var1);
    }

    public static interface ImportListener {
        public void onSuccess(String var1);

        public void onFailure(Exception var1);
    }
}

