/*
 * Decompiled with CFR 0.152.
 */
package com.ajts.androidmads.library;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.RichTextString;

public class SQLiteToExcel {
    private static Handler handler = new Handler(Looper.getMainLooper());
    private SQLiteDatabase database;
    private String mExportPath;
    private HSSFWorkbook workbook;
    private List<String> mExcludeColumns = null;
    private HashMap<String, String> mPrettyNameMapping = null;
    private ExportCustomFormatter mCustomFormatter = null;

    public SQLiteToExcel(Context context, String dbName) {
        this(context, dbName, Environment.getExternalStorageDirectory().toString() + File.separator);
    }

    public SQLiteToExcel(Context context, String dbName, String exportPath) {
        this.mExportPath = exportPath;
        try {
            this.database = SQLiteDatabase.openOrCreateDatabase((String)context.getDatabasePath(dbName).getAbsolutePath(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setExcludeColumns(List<String> excludeColumns) {
        this.mExcludeColumns = excludeColumns;
    }

    public void setPrettyNameMapping(HashMap<String, String> prettyNameMapping) {
        this.mPrettyNameMapping = prettyNameMapping;
    }

    public void setCustomFormatter(ExportCustomFormatter customFormatter) {
        this.mCustomFormatter = customFormatter;
    }

    private ArrayList<String> getAllTables() {
        ArrayList<String> tables = new ArrayList<String>();
        Cursor cursor = this.database.rawQuery("select name from sqlite_master where type='table' order by name", null);
        while (cursor.moveToNext()) {
            tables.add(cursor.getString(0));
        }
        cursor.close();
        return tables;
    }

    private ArrayList<String> getColumns(String table) {
        ArrayList<String> columns = new ArrayList<String>();
        Cursor cursor = this.database.rawQuery("PRAGMA table_info(" + table + ")", null);
        while (cursor.moveToNext()) {
            columns.add(cursor.getString(1));
        }
        cursor.close();
        return columns;
    }

    private void exportTables(List<String> tables, String fileName) throws Exception {
        this.workbook = new HSSFWorkbook();
        for (int i = 0; i < tables.size(); ++i) {
            if (tables.get(i).equals("android_metadata")) continue;
            HSSFSheet sheet = this.workbook.createSheet(this.prettyNameMapping(tables.get(i)));
            this.createSheet(tables.get(i), sheet);
        }
        File file = new File(this.mExportPath, fileName);
        FileOutputStream fos = new FileOutputStream(file);
        this.workbook.write((OutputStream)fos);
        fos.flush();
        fos.close();
        this.workbook.close();
        this.database.close();
    }

    public void exportSingleTable(String table, String fileName, ExportListener listener) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(table);
        this.startExportTables(tables, fileName, listener);
    }

    public void exportSpecificTables(List<String> tables, String fileName, ExportListener listener) {
        this.startExportTables(tables, fileName, listener);
    }

    public void exportAllTables(String fileName, ExportListener listener) {
        ArrayList<String> tables = this.getAllTables();
        this.startExportTables(tables, fileName, listener);
    }

    private void startExportTables(final List<String> tables, final String fileName, final ExportListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        SQLiteToExcel.this.exportTables(tables, fileName);
                        if (listener != null) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    listener.onCompleted(SQLiteToExcel.this.mExportPath + fileName);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (SQLiteToExcel.this.database != null && SQLiteToExcel.this.database.isOpen()) {
                            SQLiteToExcel.this.database.close();
                        }
                        if (listener == null) break block4;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                listener.onError(e);
                            }
                        });
                    }
                }
            }
        }).start();
    }

    private void createSheet(String table, HSSFSheet sheet) {
        HSSFRow rowA = sheet.createRow(0);
        ArrayList<String> columns = this.getColumns(table);
        int cellIndex = 0;
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = this.prettyNameMapping("" + columns.get(i));
            if (this.excludeColumn(columnName)) continue;
            HSSFCell cellA = rowA.createCell(cellIndex);
            cellA.setCellValue((RichTextString)new HSSFRichTextString(columnName));
            ++cellIndex;
        }
        this.insertItemToSheet(table, sheet, columns);
    }

    private void insertItemToSheet(String table, HSSFSheet sheet, ArrayList<String> columns) {
        HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
        Cursor cursor = this.database.rawQuery("select * from " + table, null);
        cursor.moveToFirst();
        int n = 1;
        while (!cursor.isAfterLast()) {
            HSSFRow rowA = sheet.createRow(n);
            int cellIndex = 0;
            for (int j = 0; j < columns.size(); ++j) {
                String columnName = "" + columns.get(j);
                if (this.excludeColumn(columnName)) continue;
                HSSFCell cellA = rowA.createCell(cellIndex);
                if (cursor.getType(j) == 4) {
                    HSSFClientAnchor anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)cellIndex, n, (short)(cellIndex + 1), n + 1);
                    anchor.setAnchorType(ClientAnchor.AnchorType.DONT_MOVE_AND_RESIZE);
                    patriarch.createPicture(anchor, this.workbook.addPicture(cursor.getBlob(j), 5));
                } else {
                    String value = cursor.getString(j);
                    if (null != this.mCustomFormatter) {
                        value = this.mCustomFormatter.process(columnName, value);
                    }
                    cellA.setCellValue((RichTextString)new HSSFRichTextString(value));
                }
                ++cellIndex;
            }
            ++n;
            cursor.moveToNext();
        }
        cursor.close();
    }

    private boolean excludeColumn(String column) {
        boolean exclude = false;
        if (null != this.mExcludeColumns) {
            return this.mExcludeColumns.contains(column);
        }
        return exclude;
    }

    private String prettyNameMapping(String name) {
        if (null != this.mPrettyNameMapping && this.mPrettyNameMapping.containsKey(name)) {
            name = this.mPrettyNameMapping.get(name);
        }
        return name;
    }

    public static interface ExportCustomFormatter {
        public String process(String var1, String var2);
    }

    public static interface ExportListener {
        public void onStart();

        public void onCompleted(String var1);

        public void onError(Exception var1);
    }
}

