/*
 * Decompiled with CFR 0.152.
 */
package com.ajts.androidmads.library;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;

public class SQLiteToExcel {
    private Context mContext;
    private SQLiteDatabase database;
    private String mDbName;
    private ExportListener mListener;
    private String mExportPath;
    private static final int MESSAGE_START = 0;
    private static final int MESSAGE_COMPLETE = 1;
    private static final int MESSAGE_ERROR = 2;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            int msgId = msg.what;
            switch (msgId) {
                case 0: {
                    SQLiteToExcel.this.mListener.onStart();
                    break;
                }
                case 1: {
                    SQLiteToExcel.this.mListener.onComplete();
                    break;
                }
                case 2: {
                    SQLiteToExcel.this.mListener.onError();
                }
            }
        }
    };

    public SQLiteToExcel(Context context, String dbName) {
        this.mContext = context;
        this.mDbName = dbName;
        this.mExportPath = Environment.getExternalStorageDirectory().toString() + File.separator;
        try {
            this.database = SQLiteDatabase.openOrCreateDatabase((String)this.mContext.getDatabasePath(this.mDbName).getAbsolutePath(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SQLiteToExcel(Context context, String dbName, String exportPath) {
        this.mContext = context;
        this.mDbName = dbName;
        this.mExportPath = exportPath;
        try {
            this.database = SQLiteDatabase.openOrCreateDatabase((String)this.mContext.getDatabasePath(this.mDbName).getAbsolutePath(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> getAllTables() {
        ArrayList<String> tables = new ArrayList<String>();
        Cursor cursor = this.database.rawQuery("select name from sqlite_master where type='table' order by name", null);
        while (cursor.moveToNext()) {
            tables.add(cursor.getString(0));
        }
        cursor.close();
        return tables;
    }

    private ArrayList<String> getColumns(String table) {
        ArrayList<String> columns = new ArrayList<String>();
        Cursor cursor = this.database.rawQuery("PRAGMA table_info(" + table + ")", null);
        while (cursor.moveToNext()) {
            columns.add(cursor.getString(1));
        }
        cursor.close();
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportItems(String table, String fileName) {
        this.mHandler.sendEmptyMessage(0);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(table);
        this.createSheet(table, sheet);
        OutputStream fos = null;
        try {
            File file = new File(this.mExportPath, fileName);
            fos = new FileOutputStream(file);
            workbook.write(fos);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mHandler.sendEmptyMessage(2);
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.mHandler.sendEmptyMessage(2);
                }
            }
        }
        try {
            workbook.close();
            this.mHandler.sendEmptyMessage(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mHandler.sendEmptyMessage(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportAllItems(String fileName) {
        this.mHandler.sendEmptyMessage(0);
        ArrayList<String> tables = this.getAllTables();
        HSSFWorkbook workbook = new HSSFWorkbook();
        for (int i = 0; i < tables.size(); ++i) {
            if (tables.get(i).equals("android_metadata")) continue;
            HSSFSheet sheet = workbook.createSheet(tables.get(i));
            this.createSheet(tables.get(i), sheet);
        }
        OutputStream fos = null;
        try {
            File file = new File(this.mExportPath, fileName);
            fos = new FileOutputStream(file);
            workbook.write(fos);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mHandler.sendEmptyMessage(2);
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    ((FileOutputStream)fos).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.mHandler.sendEmptyMessage(2);
                }
            }
        }
        try {
            workbook.close();
            this.mHandler.sendEmptyMessage(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.mHandler.sendEmptyMessage(2);
        }
    }

    public void startExportSingleTable(final String table, final String fileName, ExportListener listener) {
        this.mListener = listener;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SQLiteToExcel.this.exportItems(table, fileName);
            }
        }).start();
    }

    public void startExportAllTables(final String fileName, ExportListener listener) {
        this.mListener = listener;
        new Thread(new Runnable(){

            @Override
            public void run() {
                SQLiteToExcel.this.exportAllItems(fileName);
            }
        }).start();
    }

    private void createSheet(String table, HSSFSheet sheet) {
        HSSFRow rowA = sheet.createRow(0);
        ArrayList<String> columns = this.getColumns(table);
        for (int i = 0; i < columns.size(); ++i) {
            HSSFCell cellA = rowA.createCell(i);
            cellA.setCellValue((RichTextString)new HSSFRichTextString("" + columns.get(i)));
        }
        this.insertItemToSheet(table, sheet, columns);
    }

    private void insertItemToSheet(String table, HSSFSheet sheet, ArrayList<String> columns) {
        Cursor cursor = this.database.rawQuery("select * from " + table, null);
        cursor.moveToFirst();
        int n = 1;
        while (!cursor.isAfterLast()) {
            HSSFRow rowA = sheet.createRow(n);
            for (int j = 0; j < columns.size(); ++j) {
                HSSFCell cellA = rowA.createCell(j);
                cellA.setCellValue((RichTextString)new HSSFRichTextString(cursor.getString(j)));
            }
            ++n;
            cursor.moveToNext();
        }
        cursor.close();
    }

    public static interface ExportListener {
        public void onStart();

        public void onComplete();

        public void onError();
    }
}

