/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.handler;

import com.aizuda.snailjob.client.model.RetryArgsDeserializeDTO;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.InstanceLiveInfo;
import com.aizuda.snailjob.server.common.dto.InstanceSelectCondition;
import com.aizuda.snailjob.server.common.handler.InstanceManager;
import com.aizuda.snailjob.server.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.server.retry.task.client.RetryRpcClient;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import java.util.Objects;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class RetryArgsDeserializeHandler {
    private final InstanceManager instanceManager;
    private final AccessTemplate accessTemplate;

    public String deserialize(RetryArgsDeserializeDTO retryArgsDeserializeVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        RetrySceneConfig retrySceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(retryArgsDeserializeVO.getGroup(), retryArgsDeserializeVO.getScene(), namespaceId);
        if (Objects.isNull(retrySceneConfig)) {
            return retryArgsDeserializeVO.getArgsStr();
        }
        InstanceSelectCondition condition = InstanceSelectCondition.builder().allocKey(retrySceneConfig.getSceneName()).groupName(retrySceneConfig.getGroupName()).namespaceId(retrySceneConfig.getNamespaceId()).routeKey(retrySceneConfig.getRouteKey()).targetLabels(retrySceneConfig.getLabels()).build();
        InstanceLiveInfo instance = this.instanceManager.getALiveInstanceByRouteKey(condition);
        if (Objects.isNull(instance)) {
            return retryArgsDeserializeVO.getArgsStr();
        }
        try {
            RetryRpcClient rpcClient = (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(instance).retryTimes(3).failover(false).failRetry(true).retryInterval(1).client(RetryRpcClient.class).build();
            Result result = rpcClient.deserialize(retryArgsDeserializeVO);
            if (Objects.isNull(result) || Objects.isNull(result.getData()) || result.getStatus() == StatusEnum.NO.getStatus().intValue()) {
                return retryArgsDeserializeVO.getArgsStr();
            }
            return JsonUtil.toJsonString((Object)result.getData());
        }
        catch (Throwable e) {
            SnailJobLog.LOCAL.error("deserialize is error. args:[{}]", new Object[]{retryArgsDeserializeVO.getArgsStr(), e});
            return retryArgsDeserializeVO.getArgsStr();
        }
    }

    @Generated
    public RetryArgsDeserializeHandler(InstanceManager instanceManager, AccessTemplate accessTemplate) {
        this.instanceManager = instanceManager;
        this.accessTemplate = accessTemplate;
    }
}

