/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.convert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.server.common.util.TriggerIntervalUtils;
import com.aizuda.snailjob.server.web.model.request.JobRequestVO;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface JobConverter {
    public static final JobConverter INSTANCE = (JobConverter)Mappers.getMapper(JobConverter.class);

    public List<JobRequestVO> convertList(List<Job> var1);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(JobConverter.toNotifyIds(job.getNotifyIds()))")})
    public JobRequestVO convert(Job var1);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(JobConverter.toNotifyIdsStr(jobRequestVO.getNotifyIds()))"), @Mapping(target="triggerInterval", expression="java(JobConverter.toTriggerInterval(jobRequestVO))")})
    public Job convert(JobRequestVO var1);

    public static Set<Long> toNotifyIds(String notifyIds) {
        if (StrUtil.isBlank((CharSequence)notifyIds)) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(JsonUtil.parseList((String)notifyIds, Long.class));
    }

    public static String toNotifyIdsStr(Set<Long> notifyIds) {
        if (CollUtil.isEmpty(notifyIds)) {
            return "";
        }
        return JsonUtil.toJsonString(notifyIds);
    }

    public static String toTriggerInterval(JobRequestVO jobRequestVO) {
        String triggerInterval = jobRequestVO.getTriggerInterval();
        if (StrUtil.isBlank((CharSequence)triggerInterval) || Objects.isNull(jobRequestVO.getTriggerType())) {
            return "";
        }
        return TriggerIntervalUtils.getPointInTimeStr((String)triggerInterval, (Integer)jobRequestVO.getTriggerType());
    }
}

