/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.common.vo.WorkflowBatchResponseVO;
import com.aizuda.snailjob.server.common.vo.WorkflowDetailResponseVO;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.WorkflowBatchQueryVO;
import com.aizuda.snailjob.server.web.service.WorkflowBatchService;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/batch"})
public class WorkflowBatchController {
    private final WorkflowBatchService workflowBatchService;

    @LoginRequired
    @GetMapping(value={"/page/list"})
    public PageResult<List<WorkflowBatchResponseVO>> listPage(WorkflowBatchQueryVO queryVO) {
        return this.workflowBatchService.listPage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public WorkflowDetailResponseVO getWorkflowBatchDetail(@PathVariable(value="id") Long id) {
        return this.workflowBatchService.getWorkflowBatchDetail(id);
    }

    @PostMapping(value={"/stop/{id}"})
    @LoginRequired
    public Boolean stop(@PathVariable(value="id") Long id) {
        return this.workflowBatchService.stop(id);
    }

    @DeleteMapping(value={"/ids"})
    @LoginRequired(role=RoleEnum.USER)
    public Boolean deleteByIds(@RequestBody @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") Set<Long> ids) {
        return this.workflowBatchService.deleteByIds(ids);
    }

    @Generated
    public WorkflowBatchController(WorkflowBatchService workflowBatchService) {
        this.workflowBatchService = workflowBatchService;
    }
}

