/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.BatchDeleteRetryTaskVO;
import com.aizuda.snailjob.server.web.model.request.GenerateRetryIdempotentIdVO;
import com.aizuda.snailjob.server.web.model.request.ManualTriggerTaskRequestVO;
import com.aizuda.snailjob.server.web.model.request.ParseLogsVO;
import com.aizuda.snailjob.server.web.model.request.RetryQueryVO;
import com.aizuda.snailjob.server.web.model.request.RetrySaveRequestVO;
import com.aizuda.snailjob.server.web.model.request.RetryUpdateExecutorNameRequestVO;
import com.aizuda.snailjob.server.web.model.request.RetryUpdateStatusRequestVO;
import com.aizuda.snailjob.server.web.model.response.RetryResponseVO;
import com.aizuda.snailjob.server.web.service.RetryService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/retry"})
public class RetryController {
    @Autowired
    private RetryService retryService;

    @LoginRequired
    @GetMapping(value={"list"})
    public PageResult<List<RetryResponseVO>> getRetryTaskPage(RetryQueryVO queryVO) {
        return this.retryService.getRetryPage(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public RetryResponseVO getRetryTaskById(@RequestParam(value="groupName") String groupName, @PathVariable(value="id") Long id) {
        return this.retryService.getRetryById(groupName, id);
    }

    @LoginRequired
    @PutMapping(value={"status"})
    public int updateRetryTaskStatus(@RequestBody RetryUpdateStatusRequestVO retryUpdateStatusRequestVO) {
        return this.retryService.updateRetryStatus(retryUpdateStatusRequestVO);
    }

    @LoginRequired
    @PostMapping
    public int saveRetryTask(@RequestBody @Validated RetrySaveRequestVO retryTaskRequestVO) {
        return this.retryService.saveRetryTask(retryTaskRequestVO);
    }

    @LoginRequired
    @PostMapping(value={"/generate/idempotent-id"})
    public Result<String> idempotentIdGenerate(@RequestBody @Validated GenerateRetryIdempotentIdVO generateRetryIdempotentIdVO) {
        return new Result((Object)this.retryService.idempotentIdGenerate(generateRetryIdempotentIdVO));
    }

    @LoginRequired
    @PutMapping(value={"/batch"})
    public Integer updateRetryTaskExecutorName(@RequestBody @Validated RetryUpdateExecutorNameRequestVO requestVO) {
        return this.retryService.updateRetryExecutorName(requestVO);
    }

    @LoginRequired
    @DeleteMapping(value={"/batch"})
    public boolean batchDeleteRetry(@RequestBody @Validated BatchDeleteRetryTaskVO requestVO) {
        return this.retryService.batchDeleteRetry(requestVO);
    }

    @LoginRequired
    @PostMapping(value={"/batch"})
    public Integer parseLogs(@RequestBody @Validated ParseLogsVO parseLogsVO) {
        return this.retryService.parseLogs(parseLogsVO);
    }

    @LoginRequired
    @PostMapping(value={"/manual/trigger/retry/task"})
    public boolean manualTriggerRetryTask(@RequestBody @Validated ManualTriggerTaskRequestVO requestVO) {
        return this.retryService.manualTriggerRetryTask(requestVO);
    }
}

