/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.RetryStatusEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.retry.task.support.RetryTaskConverter;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.BatchDeleteRetryDeadLetterVO;
import com.aizuda.snailjob.server.web.model.request.BatchRollBackRetryDeadLetterVO;
import com.aizuda.snailjob.server.web.model.request.RetryDeadLetterQueryVO;
import com.aizuda.snailjob.server.web.model.response.RetryDeadLetterResponseVO;
import com.aizuda.snailjob.server.web.service.RetryDeadLetterService;
import com.aizuda.snailjob.server.web.service.convert.RetryDeadLetterResponseVOConverter;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryTask;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RetryDeadLetterServiceImpl
implements RetryDeadLetterService {
    private final AccessTemplate accessTemplate;

    @Override
    public PageResult<List<RetryDeadLetterResponseVO>> getRetryDeadLetterPage(RetryDeadLetterQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        PageDTO retryDeadLetterPageDTO = this.accessTemplate.getRetryDeadLetterAccess().listPage(pageDTO, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetryDeadLetter::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), RetryDeadLetter::getSceneName, (Object)queryVO.getSceneName())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getBizNo()), RetryDeadLetter::getBizNo, (Object)queryVO.getBizNo())).eq(StrUtil.isNotBlank((CharSequence)queryVO.getIdempotentId()), RetryDeadLetter::getIdempotentId, (Object)queryVO.getIdempotentId())).between(ObjUtil.isAllNotEmpty((Object[])new Object[]{queryVO.getStartDt(), queryVO.getEndDt()}), CreateDt::getCreateDt, (Object)queryVO.getStartDt(), (Object)queryVO.getEndDt())).orderByDesc(RetryDeadLetter::getId));
        return new PageResult<List<RetryDeadLetterResponseVO>>(retryDeadLetterPageDTO, RetryDeadLetterResponseVOConverter.INSTANCE.convertList(retryDeadLetterPageDTO.getRecords()));
    }

    @Override
    public RetryDeadLetterResponseVO getRetryDeadLetterById(String groupName, Long id) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        RetryDeadLetter retryDeadLetter = (RetryDeadLetter)retryDeadLetterAccess.one((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getId, (Object)id));
        return RetryDeadLetterResponseVOConverter.INSTANCE.convert(retryDeadLetter);
    }

    @Override
    @Transactional
    public int rollback(BatchRollBackRetryDeadLetterVO rollBackRetryDeadLetterVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List<Long> ids = rollBackRetryDeadLetterVO.getIds();
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        List retryDeadLetterList = retryDeadLetterAccess.list((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryDeadLetter::getId, ids));
        Assert.notEmpty((Iterable)retryDeadLetterList, () -> new SnailJobServerException("\u6570\u636e\u4e0d\u5b58\u5728"));
        ConfigAccess sceneConfigAccess = this.accessTemplate.getSceneConfigAccess();
        Set sceneNameSet = StreamUtils.toSet((Collection)retryDeadLetterList, RetryDeadLetter::getSceneName);
        List retrySceneConfigs = sceneConfigAccess.list((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).in(RetrySceneConfig::getSceneName, (Collection)sceneNameSet));
        Map sceneConfigMap = StreamUtils.toIdentityMap((Collection)retrySceneConfigs, sceneConfig -> sceneConfig.getGroupName() + sceneConfig.getSceneName());
        ArrayList<Retry> waitRollbackList = new ArrayList<Retry>();
        for (RetryDeadLetter retryDeadLetter : retryDeadLetterList) {
            RetrySceneConfig retrySceneConfig = (RetrySceneConfig)sceneConfigMap.get(retryDeadLetter.getGroupName() + retryDeadLetter.getSceneName());
            Assert.notNull((Object)retrySceneConfig, () -> new SnailJobServerException("\u672a\u67e5\u8be2\u5230\u573a\u666f. [{}]", new Object[]{retryDeadLetter.getSceneName()}));
            Retry retry = RetryTaskConverter.INSTANCE.toRetryTask(retryDeadLetter);
            retry.setRetryStatus(RetryStatusEnum.RUNNING.getStatus());
            retry.setTaskType(SyetemTaskTypeEnum.RETRY.getType());
            WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
            waitStrategyContext.setNextTriggerAt(LocalDateTime.now());
            waitStrategyContext.setTriggerInterval(retrySceneConfig.getTriggerInterval());
            waitStrategyContext.setDelayLevel(Integer.valueOf(1));
            WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)retrySceneConfig.getBackOff());
            retry.setNextTriggerAt(waitStrategy.computeTriggerTime(waitStrategyContext));
            retry.setCreateDt(LocalDateTime.now());
            waitRollbackList.add(retry);
        }
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryAccess();
        Assert.isTrue((waitRollbackList.size() == retryTaskAccess.insertBatch(waitRollbackList) ? 1 : 0) != 0, () -> new SnailJobServerException("\u65b0\u589e\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25"));
        Set waitDelRetryDeadLetterIdSet = StreamUtils.toSet((Collection)retryDeadLetterList, RetryDeadLetter::getId);
        Assert.isTrue((waitDelRetryDeadLetterIdSet.size() == retryDeadLetterAccess.delete((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryDeadLetter::getId, (Collection)waitDelRetryDeadLetterIdSet)) ? 1 : 0) != 0, () -> new SnailJobServerException("\u5220\u9664\u6b7b\u4fe1\u961f\u5217\u6570\u636e\u5931\u8d25"));
        RetryTask retryTask = new RetryTask();
        retryTask.setTaskStatus(RetryStatusEnum.RUNNING.getStatus());
        return 1;
    }

    @Override
    public boolean batchDelete(BatchDeleteRetryDeadLetterVO deadLetterVO) {
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        Assert.isTrue((deadLetterVO.getIds().size() == retryDeadLetterAccess.delete((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getNamespaceId, (Object)namespaceId)).in(RetryDeadLetter::getId, deadLetterVO.getIds())) ? 1 : 0) != 0, () -> new SnailJobServerException("\u5220\u9664\u6b7b\u4fe1\u4efb\u52a1\u5931\u8d25"));
        return Boolean.TRUE;
    }

    @Generated
    public RetryDeadLetterServiceImpl(AccessTemplate accessTemplate) {
        this.accessTemplate = accessTemplate;
    }
}

