/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.JobOperationReasonEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.dto.JobTaskConfig;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.job.task.support.cache.MutableGraphCache;
import com.aizuda.snailjob.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.request.WorkflowBatchQueryVO;
import com.aizuda.snailjob.server.web.model.response.JobBatchResponseVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowBatchResponseVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowDetailResponseVO;
import com.aizuda.snailjob.server.web.service.WorkflowBatchService;
import com.aizuda.snailjob.server.web.service.convert.JobBatchResponseVOConverter;
import com.aizuda.snailjob.server.web.service.convert.WorkflowConverter;
import com.aizuda.snailjob.server.web.service.handler.WorkflowHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WorkflowBatchServiceImpl
implements WorkflowBatchService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowBatchServiceImpl.class);
    private static final Integer NOT_HANDLE_STATUS = 99;
    private static final Integer WORKFLOW_DECISION_FAILED_STATUS = 98;
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final WorkflowMapper workflowMapper;
    private final WorkflowNodeMapper workflowNodeMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final WorkflowHandler workflowHandler;
    private final WorkflowBatchHandler workflowBatchHandler;
    private final JobMapper jobMapper;

    private static boolean isNoOperation(JobTaskBatch i) {
        return JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(i.getOperationReason()) || i.getTaskBatchStatus().intValue() == JobTaskBatchStatusEnum.STOP.getStatus();
    }

    @Override
    public PageResult<List<WorkflowBatchResponseVO>> listPage(WorkflowBatchQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        if (userSessionVO.isUser() && CollUtil.isEmpty(groupNames)) {
            return new PageResult<List<WorkflowBatchResponseVO>>(pageDTO, Collections.emptyList());
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"batch.namespace_id", (Object)userSessionVO.getNamespaceId())).eq(queryVO.getWorkflowId() != null, (Object)"batch.workflow_id", (Object)queryVO.getWorkflowId())).in(CollUtil.isNotEmpty(groupNames), (Object)"batch.group_name", groupNames)).eq(queryVO.getTaskBatchStatus() != null, (Object)"batch.task_batch_status", (Object)queryVO.getTaskBatchStatus())).likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getWorkflowName()), (Object)"flow.workflow_name", (Object)queryVO.getWorkflowName())).between(ObjUtil.isNotNull((Object)queryVO.getDatetimeRange()), (Object)"batch.create_dt", (Object)queryVO.getStartDt(), (Object)queryVO.getEndDt())).eq((Object)"batch.deleted", (Object)0)).orderByDesc((Object)"batch.id");
        List batchResponseDOList = this.workflowTaskBatchMapper.selectWorkflowBatchPageList(pageDTO, (Wrapper)wrapper);
        List<WorkflowBatchResponseVO> batchResponseVOList = WorkflowConverter.INSTANCE.convertListToWorkflowBatchList(batchResponseDOList);
        return new PageResult<List<WorkflowBatchResponseVO>>(pageDTO, batchResponseVOList);
    }

    @Override
    public WorkflowDetailResponseVO getWorkflowBatchDetail(Long id) {
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowTaskBatch::getId, (Object)id)).eq(WorkflowTaskBatch::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId()));
        if (Objects.isNull(workflowTaskBatch)) {
            return null;
        }
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)workflowTaskBatch.getWorkflowId());
        WorkflowDetailResponseVO responseVO = WorkflowConverter.INSTANCE.convert(workflow);
        responseVO.setWorkflowBatchStatus(workflowTaskBatch.getTaskBatchStatus());
        List workflowNodes = this.workflowNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowNode::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(WorkflowNode::getWorkflowId, (Object)workflow.getId()));
        List jobs = this.jobMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Job::getId, (Collection)StreamUtils.toSet((Collection)workflowNodes, WorkflowNode::getJobId)));
        Map jobMap = StreamUtils.toIdentityMap((Collection)jobs, Job::getId);
        List alJobTaskBatchList = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)id)).orderByDesc(JobTaskBatch::getId));
        Map jobTaskBatchMap = StreamUtils.groupByKey((Collection)alJobTaskBatchList, JobTaskBatch::getWorkflowNodeId);
        List<WorkflowDetailResponseVO.NodeInfo> nodeInfos = WorkflowConverter.INSTANCE.convertList(workflowNodes);
        String flowInfo = workflowTaskBatch.getFlowInfo();
        MutableGraph graph = MutableGraphCache.getOrDefault((Long)id, (String)flowInfo);
        HashSet allNoOperationNode = Sets.newHashSet();
        Map<Long, WorkflowDetailResponseVO.NodeInfo> workflowNodeMap = nodeInfos.stream().peek(nodeInfo -> {
            List<JobTaskBatch> jobTaskBatchList;
            JobTaskConfig jobTask = nodeInfo.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobTask.setJobName(jobMap.getOrDefault(jobTask.getJobId(), new Job()).getJobName());
            }
            if (CollUtil.isNotEmpty((Collection)(jobTaskBatchList = (List<JobTaskBatch>)jobTaskBatchMap.get(nodeInfo.getId())))) {
                jobTaskBatchList = jobTaskBatchList.stream().sorted(Comparator.comparingInt(JobTaskBatch::getTaskBatchStatus)).collect(Collectors.toList());
                nodeInfo.setJobBatchList(JobBatchResponseVOConverter.INSTANCE.convertListToJobBatchList(jobTaskBatchList));
                JobTaskBatch jobTaskBatch = jobTaskBatchList.get(0);
                if (JobOperationReasonEnum.WORKFLOW_DECISION_FAILED.getReason() == jobTaskBatch.getOperationReason().intValue()) {
                    nodeInfo.setTaskBatchStatus(WORKFLOW_DECISION_FAILED_STATUS);
                } else {
                    nodeInfo.setTaskBatchStatus(jobTaskBatch.getTaskBatchStatus());
                }
                if (jobTaskBatchList.stream().filter(Objects::nonNull).anyMatch(WorkflowBatchServiceImpl::isNoOperation)) {
                    Set allDescendants = MutableGraphCache.getAllDescendants((MutableGraph)graph, (Long)nodeInfo.getId());
                    allNoOperationNode.addAll(allDescendants);
                } else {
                    allNoOperationNode.remove(nodeInfo.getId());
                }
            } else if (JobTaskBatchStatusEnum.NOT_SUCCESS.contains(workflowTaskBatch.getTaskBatchStatus())) {
                allNoOperationNode.add(nodeInfo.getId());
            }
        }).collect(Collectors.toMap(WorkflowDetailResponseVO.NodeInfo::getId, Function.identity()));
        for (Long noOperationNodeId : allNoOperationNode) {
            WorkflowDetailResponseVO.NodeInfo nodeInfo2 = (WorkflowDetailResponseVO.NodeInfo)workflowNodeMap.get(noOperationNodeId);
            List<JobTaskBatch> jobTaskBatches = (List<JobTaskBatch>)jobTaskBatchMap.get(nodeInfo2.getId());
            if (CollUtil.isNotEmpty((Collection)jobTaskBatches)) {
                jobTaskBatches = jobTaskBatches.stream().sorted(Comparator.comparingInt(JobTaskBatch::getTaskBatchStatus)).collect(Collectors.toList());
                nodeInfo2.setJobBatchList(JobBatchResponseVOConverter.INSTANCE.convertListToJobBatchList(jobTaskBatches));
                continue;
            }
            JobBatchResponseVO jobBatchResponseVO = new JobBatchResponseVO();
            JobTaskConfig jobTask = nodeInfo2.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobBatchResponseVO.setJobId(jobTask.getJobId());
            }
            nodeInfo2.setJobBatchList(Lists.newArrayList((Object[])new JobBatchResponseVO[]{jobBatchResponseVO}));
        }
        try {
            WorkflowDetailResponseVO.NodeConfig config = this.workflowHandler.buildNodeConfig((MutableGraph<Long>)graph, SystemConstants.ROOT, new HashMap<Long, WorkflowDetailResponseVO.NodeConfig>(), workflowNodeMap);
            responseVO.setNodeConfig(config);
        }
        catch (Exception e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u5931\u8d25. json:[{}]", (Object)flowInfo, (Object)e);
            throw new SnailJobServerException("\u67e5\u8be2\u5de5\u4f5c\u6d41\u6279\u6b21\u8be6\u60c5\u5931\u8d25");
        }
        return responseVO;
    }

    @Override
    public Boolean stop(Long id) {
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectById((Serializable)id);
        Assert.notNull((Object)workflowTaskBatch, () -> new SnailJobServerException("workflow batch can not be null."));
        this.workflowBatchHandler.stop(id, Integer.valueOf(JobOperationReasonEnum.MANNER_STOP.getReason()));
        return Boolean.TRUE;
    }

    public WorkflowBatchServiceImpl(WorkflowTaskBatchMapper workflowTaskBatchMapper, WorkflowMapper workflowMapper, WorkflowNodeMapper workflowNodeMapper, JobTaskBatchMapper jobTaskBatchMapper, WorkflowHandler workflowHandler, WorkflowBatchHandler workflowBatchHandler, JobMapper jobMapper) {
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
        this.workflowMapper = workflowMapper;
        this.workflowNodeMapper = workflowNodeMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.workflowHandler = workflowHandler;
        this.workflowBatchHandler = workflowBatchHandler;
        this.jobMapper = jobMapper;
    }
}

