/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.JobTaskQueryVO;
import com.aizuda.snailjob.server.web.model.response.JobTaskResponseVO;
import com.aizuda.snailjob.server.web.service.JobTaskService;
import com.aizuda.snailjob.server.web.service.convert.JobTaskResponseVOConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobTaskServiceImpl
implements JobTaskService {
    @Autowired
    private JobTaskMapper jobTaskMapper;

    @Override
    public PageResult<List<JobTaskResponseVO>> getJobTaskPage(JobTaskQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        PageDTO selectPage = (PageDTO)this.jobTaskMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Objects.nonNull(queryVO.getJobId()), JobTask::getJobId, (Object)queryVO.getJobId())).eq(Objects.nonNull(queryVO.getTaskBatchId()), JobTask::getTaskBatchId, (Object)queryVO.getTaskBatchId())).eq(Objects.nonNull(queryVO.getTaskStatus()), JobTask::getTaskStatus, (Object)queryVO.getTaskStatus())).eq(JobTask::getParentId, (Object)0)).orderByAsc(JobTask::getId));
        List records = selectPage.getRecords();
        return new PageResult<List<JobTaskResponseVO>>(pageDTO, this.convertJobTaskList(records));
    }

    @Override
    public List<JobTaskResponseVO> getTreeJobTask(JobTaskQueryVO queryVO) {
        List taskList = this.jobTaskMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Objects.nonNull(queryVO.getParentId()), JobTask::getParentId, (Object)queryVO.getParentId())).eq(Objects.nonNull(queryVO.getJobId()), JobTask::getJobId, (Object)queryVO.getJobId())).eq(Objects.nonNull(queryVO.getTaskBatchId()), JobTask::getTaskBatchId, (Object)queryVO.getTaskBatchId())).orderByAsc(JobTask::getJobId));
        return this.convertJobTaskList(taskList);
    }

    private List<JobTaskResponseVO> convertJobTaskList(List<JobTask> taskList) {
        if (CollUtil.isEmpty(taskList)) {
            return new ArrayList<JobTaskResponseVO>();
        }
        List<JobTaskResponseVO> jobTaskResponseVOs = JobTaskResponseVOConverter.INSTANCE.convertList(taskList);
        Set parentIds = StreamUtils.toSet(jobTaskResponseVOs, JobTaskResponseVO::getId);
        List jobTasks = this.jobTaskMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{JobTask::getParentId}).in(JobTask::getParentId, (Collection)parentIds));
        Set jobTaskParentIds = StreamUtils.toSet((Collection)jobTasks, JobTask::getParentId);
        jobTaskResponseVOs.forEach(jobTask -> jobTask.setChildNode(!jobTaskParentIds.contains(jobTask.getId())));
        return jobTaskResponseVOs;
    }
}

